/*
 * Decompiled with CFR 0.152.
 */
package marmot.util.eval;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import marmot.util.eval.Scorer;
import marmot.util.eval.SignificanceTest;

public class RandomizationTest
implements SignificanceTest {
    private Random random_;

    public RandomizationTest() {
        this.random_ = new Random();
    }

    public RandomizationTest(long seed) {
        this.random_ = new Random(seed);
    }

    public double getSum(List<Double> scores) {
        double sum = 0.0;
        for (double score : scores) {
            sum += score;
        }
        return sum;
    }

    @Override
    public double test(Scorer scorer, String gold, String pred1, String pred2) {
        List<Double> scores1 = scorer.getScores(gold, pred1);
        System.err.println(pred1 + ": " + this.getSum(scores1));
        List<Double> scores2 = scorer.getScores(gold, pred2);
        System.err.println(pred2 + ": " + this.getSum(scores2));
        List<Double> diffs = RandomizationTest.getDifferences(scores1, scores2, true);
        if (diffs.isEmpty()) {
            return 1.0;
        }
        System.err.println("|Diffs|: " + diffs.size());
        double diff = this.getAbsoluteDifference(diffs, false);
        int total = 0x100000;
        int error = 0;
        for (int index = 0; index < total; ++index) {
            double random_diff = this.getAbsoluteDifference(diffs, true);
            if (!(diff - random_diff < 1.0E-10)) continue;
            ++error;
        }
        return (double)error / (double)total;
    }

    public static List<Double> getDifferences(List<Double> scores1, List<Double> scores2, boolean remove_zeroes) {
        ArrayList<Double> list = new ArrayList<Double>(scores1.size());
        for (int index = 0; index < scores1.size(); ++index) {
            double diff = scores1.get(index) - scores2.get(index);
            if (remove_zeroes && Math.abs(diff) < 1.0E-99) continue;
            list.add(diff);
        }
        return list;
    }

    private double getAbsoluteDifference(List<Double> differences, boolean random) {
        double diff = 0.0;
        for (double current_diff : differences) {
            if (random && this.random_.nextBoolean()) {
                diff -= current_diff;
                continue;
            }
            diff += current_diff;
        }
        return Math.abs(diff);
    }

    public static void main(String[] args) {
        Scorer scorer;
        String scorer_string = args[0];
        try {
            scorer = (Scorer)Class.forName(scorer_string).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        String actual = args[1];
        String prediction1 = args[2];
        String prediction2 = args[3];
        if (args.length > 4) {
            String[] key_value = args[4].split("=");
            scorer.setOption(key_value[0], key_value[1]);
        }
        RandomizationTest test = new RandomizationTest();
        DecimalFormat df = new DecimalFormat("0.#######################");
        System.out.println(df.format(test.test(scorer, actual, prediction1, prediction2)));
    }
}

