/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.UserListType;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Genre;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SchemaValidationStatus;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.UnionType;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class UserUnionType
extends UserSimpleType
implements PlainType,
UnionType {
    private List<TypeReference> memberTypeReferences = null;
    private int isPlainUnion = -1;

    @Override
    public Genre getGenre() {
        return Genre.ATOMIC;
    }

    @Override
    public StructuredQName getStructuredQName() {
        return this.getTypeName();
    }

    public UserUnionType(EnterpriseConfiguration config) {
        this.setConfiguration(config);
        this.memberTypeReferences = new ArrayList<TypeReference>(3);
    }

    public void setMemberTypeReferences(List<TypeReference> members) {
        this.memberTypeReferences = members;
    }

    public void addMemberTypeReference(TypeReference member) {
        if (this.memberTypeReferences == null) {
            this.memberTypeReferences = new ArrayList<TypeReference>(5);
        }
        this.memberTypeReferences.add(member);
    }

    public List<TypeReference> getMemberTypeReferences() {
        if (this.memberTypeReferences == null) {
            this.memberTypeReferences = this.getBaseType() instanceof UserUnionType ? ((UserUnionType)this.getBaseType()).getMemberTypeReferences() : Collections.emptyList();
        }
        return this.memberTypeReferences;
    }

    @Override
    public boolean isAtomicType() {
        return false;
    }

    @Override
    public boolean containsListType() throws MissingComponentException {
        for (TypeReference ref : this.getMemberTypeReferences()) {
            SimpleType type = (SimpleType)ref.getTarget();
            if (type.isListType()) {
                return true;
            }
            if (!type.isUnionType()) continue;
            return ((UserUnionType)type).containsListType();
        }
        return false;
    }

    @Override
    public boolean isPlainType() {
        if (this.isPlainUnion == -1) {
            if (((SimpleType)this.getBaseType()).isUnionType()) {
                this.isPlainUnion = 0;
                return false;
            }
            for (TypeReference ref : this.getMemberTypeReferences()) {
                try {
                    SimpleType st = (SimpleType)ref.getTarget();
                    if (st instanceof ItemType && ((ItemType)((Object)st)).isPlainType()) continue;
                    this.isPlainUnion = 0;
                    return false;
                }
                catch (MissingComponentException e) {
                    return false;
                }
            }
            this.isPlainUnion = 1;
        }
        return this.isPlainUnion == 1;
    }

    @Override
    public SequenceType getResultTypeOfCast() {
        try {
            if (this.isPlainType()) {
                return SequenceType.makeSequenceType(this, 24576);
            }
            if (this.containsListType()) {
                return SequenceType.ATOMIC_SEQUENCE;
            }
            return ((UserUnionType)this.getBaseType()).getResultTypeOfCast();
        }
        catch (MissingComponentException e) {
            return SequenceType.ATOMIC_SEQUENCE;
        }
    }

    @Override
    public boolean isIdType() throws MissingComponentException {
        for (TypeReference ref : this.getMemberTypeReferences()) {
            SimpleType st = (SimpleType)ref.getTarget();
            if (!st.isIdType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isIdRefType() throws MissingComponentException {
        for (TypeReference ref : this.getMemberTypeReferences()) {
            SimpleType st = (SimpleType)ref.getTarget();
            if (!st.isIdRefType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isBuiltInType() {
        return false;
    }

    @Override
    public boolean isListType() {
        return false;
    }

    @Override
    public boolean isUnionType() {
        return true;
    }

    @Override
    public UType getUType() {
        UType u = UType.VOID;
        for (TypeReference ref : this.getMemberTypeReferences()) {
            try {
                SimpleType st = (SimpleType)ref.getTarget();
                if (st instanceof PlainType) {
                    u = u.union(((PlainType)((Object)st)).getUType());
                    continue;
                }
                throw new UnsupportedOperationException("Union type is not a plain type");
            }
            catch (MissingComponentException e) {
                throw new UnsupportedOperationException("Union type is not a plain type. " + e.getMessage());
            }
        }
        return u;
    }

    @Override
    public String getBasicAlphaCode() {
        return "A";
    }

    @Override
    public boolean isNamespaceSensitive() {
        try {
            for (TypeReference ref : this.getMemberTypeReferences()) {
                SimpleType st = (SimpleType)ref.getTarget();
                if (!st.isNamespaceSensitive()) continue;
                return true;
            }
        }
        catch (MissingComponentException e) {
            return true;
        }
        return false;
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        boolean result = true;
        switch (this.getValidationStatus()) {
            case VALIDATED: 
            case INVALID: {
                return true;
            }
            case VALIDATING: {
                compiler.error("The definition of the union type " + this.getDescription() + " is circular", this);
                return false;
            }
        }
        super.validate(compiler);
        this.setValidationStatus(SchemaValidationStatus.VALIDATING);
        this.getMemberTypeReferences();
        this.lookForCycles(new Stack<SchemaComponent>(), compiler);
        this.setValidationStatus(SchemaValidationStatus.VALIDATED);
        return result;
    }

    @Override
    public void elaborate(SchemaCompiler compiler) throws SchemaException {
        for (TypeReference ref : this.getMemberTypeReferences()) {
            SimpleType member = (SimpleType)ref.getTarget();
            if (!(member instanceof UserSimpleType)) continue;
            ((UserSimpleType)member).elaborate(compiler);
        }
        super.elaborate(compiler);
    }

    @Override
    public void lookForCycles(Stack<SchemaComponent> references, SchemaCompiler compiler) throws SchemaException {
        for (Object e : references) {
            if (!((SchemaType)e).isSameType(this)) continue;
            compiler.error("The definition of the union type " + this.getDescription() + " is circular", this);
            throw new SchemaException("Circular definition found");
        }
        references.push(this);
        for (TypeReference typeReference : this.getMemberTypeReferences()) {
            SchemaType stb;
            typeReference.tryToResolve(compiler, false);
            if (!typeReference.isResolved()) continue;
            SchemaType st = (SchemaType)typeReference.getTarget();
            if (st instanceof SimpleTypeDefinition) {
                ((SimpleTypeDefinition)st).fixup(compiler);
                st = ((SimpleTypeDefinition)st).getWorkingType();
            }
            if (st instanceof UserUnionType) {
                SchemaType stb2;
                ((UserUnionType)st).lookForCycles(references, compiler);
                while ((stb2 = st.getBaseType()) instanceof UserUnionType) {
                    ((UserUnionType)stb2).lookForCycles(references, compiler);
                    st = stb2;
                }
                continue;
            }
            if (!(st instanceof UserListType)) continue;
            SimpleType it = ((UserListType)st).getItemType();
            if (it instanceof SimpleTypeDefinition) {
                ((SimpleTypeDefinition)it).fixup(compiler);
                it = ((SimpleTypeDefinition)it).getWorkingType();
            }
            if (it.isSameType(this)) {
                compiler.error("The definition of the union type " + this.getDescription() + " is circular", this);
                throw new SchemaException("Circular definition found");
            }
            if (!(it instanceof UserUnionType)) continue;
            ((UserUnionType)it).lookForCycles(references, compiler);
            while ((stb = it.getBaseType()) instanceof UserUnionType) {
                ((UserUnionType)stb).lookForCycles(references, compiler);
                it = (UserUnionType)stb;
            }
        }
        references.pop();
    }

    @Override
    public ValidationFailure validateContent(UnicodeString value, NamespaceResolver nsResolver, ConversionRules rules) {
        ValidationFailure result = null;
        SimpleType matchingType = null;
        for (TypeReference ref : this.getMemberTypeReferences()) {
            ValidationFailure err;
            SimpleType type = null;
            try {
                type = (SimpleType)ref.getTarget();
            }
            catch (MissingComponentException e) {
                result = new ValidationFailure("Cannot validate against union type because the schema is incomplete. " + e.getMessage());
            }
            if (type == null || (err = type.validateContent(value, nsResolver, rules)) != null) continue;
            matchingType = type;
            break;
        }
        if (matchingType != null) {
            SchemaType base = this.getBaseType();
            if (base instanceof UserUnionType) {
                try {
                    int action = matchingType.getWhitespaceAction();
                    value = Whitespace.applyWhitespaceNormalization(action, value);
                    AtomicSequence typedValue = matchingType.getTypedValue(value, nsResolver, rules);
                    result = this.checkAgainstFacets(typedValue, value, this.getExtendedFacetList(), rules);
                }
                catch (XPathException e) {
                    result = new ValidationFailure("Value " + Err.wrap(value, 4) + " does not match base type of union type " + this.getDescription());
                }
            } else {
                result = null;
            }
        } else if (result == null) {
            result = new ValidationFailure("Value " + Err.wrap(value, 4) + " does not match any member of union type " + this.getDescription());
        }
        return result;
    }

    @Override
    public ValidationFailure checkAgainstFacets(AtomicValue value, ConversionRules rules) {
        return this.checkAgainstFacets(value, value.getCanonicalLexicalRepresentation(), this.getExtendedFacetList(), rules);
    }

    private SimpleType getMatchingMemberType(UnicodeString value, NamespaceResolver resolver, ConversionRules rules) {
        for (TypeReference ref : this.getMemberTypeReferences()) {
            try {
                SimpleType type = (SimpleType)ref.getTarget();
                ValidationFailure err = type.validateContent(value, resolver, rules);
                if (err != null) continue;
                return type;
            }
            catch (MissingComponentException missingComponentException) {
            }
        }
        return null;
    }

    @Override
    public AtomicSequence getTypedValue(UnicodeString value, NamespaceResolver resolver, ConversionRules rules) throws ValidationException {
        AtomicSequence result = null;
        for (TypeReference ref : this.getMemberTypeReferences()) {
            SimpleType type = null;
            try {
                type = (SimpleType)ref.getTarget();
            }
            catch (MissingComponentException e) {
                ValidationFailure ve = new ValidationFailure("Cannot validate against union type because the schema is incomplete. " + e.getMessage());
                ve.setSchemaType(this);
                throw ve.makeException();
            }
            try {
                ValidationFailure err = type.validateContent(value, resolver, rules);
                if (err != null) continue;
                result = type.getTypedValue(value, resolver, rules);
                break;
            }
            catch (ValidationException validationException) {
            }
        }
        if (result != null) {
            AtomicSequence typedValue;
            ValidationFailure failure;
            SchemaType base = this.getBaseType();
            if (base instanceof UserUnionType && (failure = this.checkAgainstFacets(typedValue = ((UserUnionType)base).getTypedValue(value, resolver, rules), value, this.getExtendedFacetList(), rules)) != null) {
                throw failure.makeException();
            }
            return result;
        }
        ValidationFailure ve = new ValidationFailure("Value " + Err.wrap(value, 4) + " does not match any member of union type " + this.getDescription());
        ve.setSchemaType(this);
        throw ve.makeException();
    }

    @Override
    protected void serializeVariety(SchemaModelSerializer serializer) throws XPathException {
        serializer.emitAttribute("variety", "union");
        StringBuilder sb = new StringBuilder(64);
        for (TypeReference ref : this.getMemberTypeReferences()) {
            SimpleType type = (SimpleType)ref.getTarget();
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(serializer.getTypeLink(type));
        }
        serializer.emitAttribute("memberTypes", sb.toString());
    }

    @Override
    public boolean matches(Item item, TypeHierarchy th) {
        if (!(item instanceof AtomicValue)) {
            return false;
        }
        for (TypeReference ref : this.getMemberTypeReferences()) {
            try {
                PlainType pt = (PlainType)((Object)ref.getTarget());
                if (!pt.matches(item, th)) continue;
                return true;
            }
            catch (MissingComponentException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public AtomicType getPrimitiveItemType() {
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    @Override
    public int getPrimitiveType() {
        return 632;
    }

    @Override
    public PlainType getAtomizedItemType() {
        return this;
    }

    @Override
    public boolean isAtomizable(TypeHierarchy th) {
        return true;
    }

    @Override
    public List<? extends PlainType> getPlainMemberTypes() throws MissingComponentException {
        ArrayList<PlainType> s = new ArrayList<PlainType>(10);
        this.gatherPlainMemberTypes(s);
        return s;
    }

    private void gatherPlainMemberTypes(List<PlainType> s) throws MissingComponentException {
        for (TypeReference ref : this.getMemberTypeReferences()) {
            SimpleType pt = (SimpleType)ref.getTarget();
            if (pt instanceof PlainType) {
                s.add((PlainType)((Object)pt));
            }
            if (!(pt instanceof UserUnionType)) continue;
            ((UserUnionType)pt).gatherPlainMemberTypes(s);
        }
    }

    @Override
    public double getDefaultPriority() {
        try {
            double result = 1.0;
            for (PlainType plainType : this.getPlainMemberTypes()) {
                result *= plainType.getDefaultPriority();
            }
            return result;
        }
        catch (MissingComponentException e) {
            return -1.0;
        }
    }

    @Override
    public String toString() {
        if (this.isAnonymousType()) {
            StringBuilder fsb = new StringBuilder(256);
            fsb.append("union(");
            for (TypeReference ref : this.getMemberTypeReferences()) {
                String member = ref.getTargetComponentName().getDisplayName();
                fsb.append(member);
                fsb.append(", ");
            }
            fsb.setLength(fsb.length() - 2);
            fsb.append(")");
            return fsb.toString();
        }
        return this.getDisplayName();
    }

    @Override
    public String toExportString() {
        if (this.isAnonymousType()) {
            StringBuilder fsb = new StringBuilder(256);
            fsb.append("union(");
            for (TypeReference ref : this.getMemberTypeReferences()) {
                try {
                    PlainType member = (PlainType)((Object)ref.getTarget());
                    fsb.append(member.toExportString());
                }
                catch (MissingComponentException err) {
                    fsb.append("xs:anyAtomicType");
                }
                fsb.append(", ");
            }
            fsb.setLength(fsb.length() - 2);
            fsb.append(")");
            return fsb.toString();
        }
        return this.getEQName();
    }

    @Override
    public String getDescription() {
        if (this.isAnonymousType()) {
            return this.toString();
        }
        return super.getDescription();
    }
}

