/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korapxmltools;

import java.io.InputStream;
import java.io.InputStreamReader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\fH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0018\u00010\tj\u0004\u0018\u0001`\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lde/ids_mannheim/korapxmltools/XMLCommentFilterReader;", "Ljava/io/InputStreamReader;", "in", "Ljava/io/InputStream;", "charsetName", "", "<init>", "(Ljava/io/InputStream;Ljava/lang/String;)V", "commentBuffer", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "read", "", "cbuf", "", "off", "len", "close", "", "Companion", "app"})
public final class XMLCommentFilterReader
extends InputStreamReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String charsetName;
    @Nullable
    private StringBuilder commentBuffer;
    @NotNull
    public static final String COMMENT_START = "<!--";
    @NotNull
    public static final String COMMENT_END = "-->";

    public XMLCommentFilterReader(@NotNull InputStream in, @NotNull String charsetName) {
        Intrinsics.checkNotNullParameter(in, "in");
        Intrinsics.checkNotNullParameter(charsetName, "charsetName");
        super(in, charsetName);
        this.charsetName = charsetName;
    }

    @Override
    public int read(@NotNull char[] cbuf, int off, int len) {
        Intrinsics.checkNotNullParameter(cbuf, "cbuf");
        int bytesRead = super.read(cbuf, off, len);
        if (bytesRead <= 0) {
            return bytesRead;
        }
        StringBuilder filteredBuffer = new StringBuilder();
        int currentIndex = off;
        boolean isFiltered = false;
        while (currentIndex < off + bytesRead) {
            char currentChar = cbuf[currentIndex];
            if (this.commentBuffer != null) {
                StringBuilder stringBuilder = this.commentBuffer;
                Intrinsics.checkNotNull(stringBuilder);
                if (currentChar == COMMENT_END.charAt(stringBuilder.length())) {
                    StringBuilder stringBuilder2 = this.commentBuffer;
                    Intrinsics.checkNotNull(stringBuilder2);
                    stringBuilder2.append(currentChar);
                    StringBuilder stringBuilder3 = this.commentBuffer;
                    Intrinsics.checkNotNull(stringBuilder3);
                    if (StringsKt.endsWith$default((CharSequence)stringBuilder3, (CharSequence)COMMENT_END, false, 2, null)) {
                        this.commentBuffer = null;
                    }
                    v3 = Unit.INSTANCE;
                } else {
                    StringBuilder stringBuilder4 = this.commentBuffer;
                    Intrinsics.checkNotNull(stringBuilder4);
                    v3 = StringsKt.clear(stringBuilder4);
                }
            } else if (currentChar == '<') {
                StringBuilder peekBuffer = new StringBuilder();
                int peekIndex = currentIndex;
                while (peekIndex < off + bytesRead && peekBuffer.length() < 4) {
                    peekBuffer.append(cbuf[peekIndex++]);
                }
                if (Intrinsics.areEqual(peekBuffer.toString(), COMMENT_START)) {
                    isFiltered = true;
                    this.commentBuffer = new StringBuilder();
                    currentIndex = peekIndex;
                    continue;
                }
                v3 = filteredBuffer.append(currentChar);
            } else {
                v3 = filteredBuffer.append(currentChar);
            }
            ++currentIndex;
        }
        if (!isFiltered) {
            return bytesRead;
        }
        String string = filteredBuffer.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String filterdString = string;
        char[] cArray = filterdString.toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
        char[] filteredChars = cArray;
        System.arraycopy(filteredChars, 0, cbuf, off, filteredChars.length);
        bytesRead = filteredChars.length;
        return bytesRead;
    }

    @Override
    public int read() {
        throw new UnsupportedOperationException("read() is not supported. Use read(char[], int, int) instead.");
    }

    @Override
    public void close() {
        super.close();
        this.commentBuffer = null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lde/ids_mannheim/korapxmltools/XMLCommentFilterReader$Companion;", "", "<init>", "()V", "COMMENT_START", "", "COMMENT_END", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

