/*
 * Decompiled with CFR 0.152.
 */
package marmot.core;

import marmot.core.State;
import marmot.core.WeightVector;

public class Transition
extends State {
    private State previous_state_;
    private State state_;
    private int order_;

    public Transition(State previous_state, State state, int order) {
        this.previous_state_ = previous_state;
        this.state_ = state;
        this.order_ = order;
    }

    @Override
    public int getOrder() {
        return this.order_;
    }

    @Override
    public boolean canTransitionTo(State other) {
        if (other.getOrder() != this.getOrder()) {
            assert (other.getOrder() == 1);
            assert (other.getIndex() == 0);
            return true;
        }
        State next = this.state_;
        State previous = ((Transition)other).previous_state_;
        return previous.equalIndexes(next);
    }

    @Override
    public boolean equalIndexes(State other) {
        assert (other instanceof Transition);
        Transition t = (Transition)other;
        return t.state_.equalIndexes(this.state_) && t.previous_state_.equalIndexes(this.previous_state_);
    }

    @Override
    public void incrementEstimatedCounts(double d) {
        this.estimated_count_ += d;
        this.state_.incrementEstimatedCounts(d);
    }

    @Override
    public void updateWeights(WeightVector weights) {
        if (this.estimated_count_ != 0.0) {
            weights.updateWeights(this, this.estimated_count_, true);
            this.state_.updateWeights(weights);
            this.estimated_count_ = 0.0;
        }
    }

    @Override
    public State getZeroOrderState() {
        return this.state_.getZeroOrderState();
    }

    @Override
    public State getPreviousSubOrderState() {
        return this.previous_state_;
    }

    @Override
    public State getSubOrderState() {
        return this.state_;
    }

    @Override
    public int getIndex() {
        return this.state_.getIndex();
    }

    @Override
    public State getSubLevelState() {
        return this.state_.getSubLevelState();
    }

    @Override
    public void setSubLevelState(State sub_level_state) {
        throw new UnsupportedOperationException();
    }

    @Override
    public State getSubLevel(int depth) {
        return this.state_.getSubLevel(depth);
    }

    @Override
    public String toString() {
        return "(" + this.previous_state_.toString() + " " + this.getZeroOrderState().toString() + ")";
    }

    @Override
    public int getLevel() {
        return this.state_.getLevel();
    }

    @Override
    public boolean check() {
        return this.previous_state_.check() && this.state_.check();
    }

    @Override
    public State copy() {
        return super.copy(new Transition(this.previous_state_, this.state_, this.order_));
    }
}

