/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.beans.BeansUtils;
import com.mchange.v2.c3p0.DriverManagerDataSource;
import com.mchange.v2.c3p0.PoolBackedDataSource;
import com.mchange.v2.c3p0.PooledDataSource;
import com.mchange.v2.c3p0.WrapperConnectionPoolDataSource;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.sql.SqlUtils;
import java.beans.IntrospectionException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;

public final class DataSources {
    static final MLogger logger = MLog.getLogger(DataSources.class);

    public static DataSource unpooledDataSource() throws SQLException {
        DriverManagerDataSource driverManagerDataSource = new DriverManagerDataSource();
        return driverManagerDataSource;
    }

    public static DataSource unpooledDataSource(String string) throws SQLException {
        DriverManagerDataSource driverManagerDataSource = new DriverManagerDataSource();
        driverManagerDataSource.setJdbcUrl(string);
        return driverManagerDataSource;
    }

    public static DataSource unpooledDataSource(String string, String string2, String string3) throws SQLException {
        Properties properties = new Properties();
        properties.put("user", string2);
        properties.put("password", string3);
        return DataSources.unpooledDataSource(string, properties);
    }

    public static DataSource unpooledDataSource(String string, Properties properties) throws SQLException {
        DriverManagerDataSource driverManagerDataSource = new DriverManagerDataSource();
        driverManagerDataSource.setJdbcUrl(string);
        driverManagerDataSource.setProperties(properties);
        return driverManagerDataSource;
    }

    public static DataSource pooledDataSource(DataSource dataSource) throws SQLException {
        return DataSources.pooledDataSource(dataSource, null, null);
    }

    public static DataSource pooledDataSource(DataSource dataSource, int n) throws SQLException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("maxStatements", new Integer(n));
        return DataSources.pooledDataSource(dataSource, null, hashMap);
    }

    public static DataSource pooledDataSource(DataSource dataSource, String string) throws SQLException {
        return DataSources.pooledDataSource(dataSource, string, null);
    }

    public static DataSource pooledDataSource(DataSource dataSource, Map map) throws SQLException {
        return DataSources.pooledDataSource(dataSource, null, map);
    }

    public static DataSource pooledDataSource(DataSource dataSource, String string, Map map) throws SQLException {
        try {
            WrapperConnectionPoolDataSource wrapperConnectionPoolDataSource = new WrapperConnectionPoolDataSource(string);
            wrapperConnectionPoolDataSource.setNestedDataSource(dataSource);
            if (map != null) {
                DataSources.overwriteJavaBeanProperties(wrapperConnectionPoolDataSource, map, true);
            }
            PoolBackedDataSource poolBackedDataSource = new PoolBackedDataSource(string);
            poolBackedDataSource.setConnectionPoolDataSource(wrapperConnectionPoolDataSource);
            if (map != null) {
                DataSources.overwriteJavaBeanProperties(poolBackedDataSource, map, true);
            }
            return poolBackedDataSource;
        }
        catch (Exception exception) {
            SQLException sQLException = SqlUtils.toSQLException("Exception configuring pool-backed DataSource: " + exception, exception);
            if (logger.isLoggable(MLevel.FINE) && exception != sQLException) {
                logger.log(MLevel.FINE, "Converted exception to throwable SQLException", exception);
            }
            throw sQLException;
        }
    }

    private static Properties prefixedToPeeledProperties(Properties properties) {
        Properties properties2 = new Properties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            String string3 = string.startsWith("c3p0.") ? string.substring(5) : string;
            properties2.put(string3, string2);
        }
        return properties2;
    }

    public static DataSource pooledDataSource(DataSource dataSource, Properties properties) throws SQLException {
        Properties properties2 = DataSources.prefixedToPeeledProperties(properties);
        return DataSources.pooledDataSource(dataSource, null, properties2);
    }

    public static void destroy(DataSource dataSource) throws SQLException {
        DataSources.destroy(dataSource, false);
    }

    public static void forceDestroy(DataSource dataSource) throws SQLException {
        DataSources.destroy(dataSource, true);
    }

    private static void destroy(DataSource dataSource, boolean bl) throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource;
        if (dataSource instanceof PoolBackedDataSource && (connectionPoolDataSource = ((PoolBackedDataSource)dataSource).getConnectionPoolDataSource()) instanceof WrapperConnectionPoolDataSource) {
            DataSources.destroy(((WrapperConnectionPoolDataSource)connectionPoolDataSource).getNestedDataSource(), bl);
        }
        if (dataSource instanceof PooledDataSource) {
            ((PooledDataSource)dataSource).close(bl);
        }
    }

    private static void _overwriteJavaBeanProperties(Object object, Map map, boolean bl) throws IntrospectionException {
        BeansUtils.overwriteAccessiblePropertiesFromMap(map, object, false, null, bl, MLevel.WARNING, MLevel.WARNING, false);
    }

    public static void overwriteJavaBeanProperties(DataSource dataSource, Map map, boolean bl) throws IntrospectionException {
        DataSources._overwriteJavaBeanProperties(dataSource, map, bl);
    }

    public static void overwriteJavaBeanProperties(ConnectionPoolDataSource connectionPoolDataSource, Map map, boolean bl) throws IntrospectionException {
        DataSources._overwriteJavaBeanProperties(connectionPoolDataSource, map, bl);
    }

    public static void overwriteC3P0PrefixedProperties(DataSource dataSource, Properties properties) throws IntrospectionException {
        Properties properties2 = DataSources.prefixedToPeeledProperties(properties);
        DataSources.overwriteJavaBeanProperties(dataSource, (Map)properties2, true);
    }

    public static void overwriteC3P0PrefixedProperties(ConnectionPoolDataSource connectionPoolDataSource, Properties properties) throws IntrospectionException {
        Properties properties2 = DataSources.prefixedToPeeledProperties(properties);
        DataSources.overwriteJavaBeanProperties(connectionPoolDataSource, (Map)properties2, true);
    }

    private DataSources() {
    }
}

