/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korapxmltools;

import de.ids_mannheim.korapxmltools.KorapXmlTool;
import de.ids_mannheim.korapxmltools.TaggerToolBridge;
import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import opennlp.tools.postag.POSModel;
import opennlp.tools.postag.POSTaggerME;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J:\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u00152\u0014\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\tR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lde/ids_mannheim/korapxmltools/OpenNlpBridge;", "Lde/ids_mannheim/korapxmltools/TaggerToolBridge;", "model", "", "logger", "Ljava/util/logging/Logger;", "<init>", "(Ljava/lang/String;Ljava/util/logging/Logger;)V", "getModel", "()Ljava/lang/String;", "getLogger", "()Ljava/util/logging/Logger;", "foundry", "getFoundry", "tagger", "Lopennlp/tools/postag/POSTaggerME;", "getTagger", "()Lopennlp/tools/postag/POSTaggerME;", "tagSentence", "", "sentenceTokens", "", "sentenceTokenOffsets", "morphoMap", "", "Lde/ids_mannheim/korapxmltools/KorapXmlTool$MorphoSpan;", "Companion", "app"})
@SourceDebugExtension(value={"SMAP\nOpenNlpBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenNlpBridge.kt\nde/ids_mannheim/korapxmltools/OpenNlpBridge\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,51:1\n37#2,2:52\n*S KotlinDebug\n*F\n+ 1 OpenNlpBridge.kt\nde/ids_mannheim/korapxmltools/OpenNlpBridge\n*L\n40#1:52,2\n*E\n"})
public final class OpenNlpBridge
extends TaggerToolBridge {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String model;
    @NotNull
    private final Logger logger;
    @NotNull
    private final String foundry;
    @NotNull
    private final POSTaggerME tagger;
    @Nullable
    private static POSModel POSmodel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenNlpBridge(@NotNull String model, @NotNull Logger logger) {
        Intrinsics.checkNotNullParameter(model, "model");
        Intrinsics.checkNotNullParameter(logger, "logger");
        this.model = model;
        this.logger = logger;
        this.foundry = "opennlp";
        String string = this.getModel();
        synchronized (string) {
            boolean bl = false;
            if (POSmodel == null) {
                this.getLogger().info("Initializing OpenNLP with model " + this.getModel());
                String string2 = this.getModel();
                Intrinsics.checkNotNull(string2, "null cannot be cast to non-null type kotlin.String");
                File file = new File(string2);
                POSmodel = new POSModel(new FileInputStream(file));
                this.getLogger().info("Model " + this.getModel() + " loaded");
            }
            Unit unit = Unit.INSTANCE;
        }
        this.tagger = new POSTaggerME(POSmodel);
    }

    @Override
    @NotNull
    public String getModel() {
        return this.model;
    }

    @Override
    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public String getFoundry() {
        return this.foundry;
    }

    @NotNull
    public final POSTaggerME getTagger() {
        return this.tagger;
    }

    @Override
    public void tagSentence(@NotNull List<String> sentenceTokens, @NotNull List<String> sentenceTokenOffsets, @Nullable Map<String, KorapXmlTool.MorphoSpan> morphoMap) {
        Intrinsics.checkNotNullParameter(sentenceTokens, "sentenceTokens");
        Intrinsics.checkNotNullParameter(sentenceTokenOffsets, "sentenceTokenOffsets");
        Collection $this$toTypedArray$iv = sentenceTokens;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] result = this.tagger.tag(thisCollection$iv.toArray(new String[0]));
        double[] probs = this.tagger.probs();
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            String string = result[i];
            Locale locale = Locale.ROOT;
            String string2 = "%.5f";
            Object[] objectArray = new Object[]{probs[i]};
            String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
            KorapXmlTool.MorphoSpan taggedWord = new KorapXmlTool.MorphoSpan(null, null, string, null, null, null, null, string3, 123, null);
            Map<String, KorapXmlTool.MorphoSpan> map2 = morphoMap;
            if (map2 == null) continue;
            map2.put(sentenceTokenOffsets.get(i), taggedWord);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lde/ids_mannheim/korapxmltools/OpenNlpBridge$Companion;", "", "<init>", "()V", "POSmodel", "Lopennlp/tools/postag/POSModel;", "getPOSmodel", "()Lopennlp/tools/postag/POSModel;", "setPOSmodel", "(Lopennlp/tools/postag/POSModel;)V", "app"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final POSModel getPOSmodel() {
            return POSmodel;
        }

        public final void setPOSmodel(@Nullable POSModel pOSModel) {
            POSmodel = pOSModel;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

