/*
 * Decompiled with CFR 0.152.
 */
package marmot.util.edit;

import marmot.util.Counter;
import marmot.util.edit.EditTree;
import marmot.util.edit.EditTreeBuilder;

public class MatchNode
implements EditTree {
    private static final long serialVersionUID = 1L;
    private EditTree left_;
    private EditTree right_;
    private int left_length_;
    private int right_length_;
    int hash_code_ = 0;

    public MatchNode(EditTree left, EditTree right, int left_length, int right_length) {
        this.left_length_ = left_length;
        this.right_length_ = right_length;
        this.left_ = left;
        this.right_ = right;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('(');
        if (this.left_ != null) {
            sb.append(this.left_length_);
            sb.append(this.left_);
        }
        if (sb.length() > 1) {
            sb.append(" ");
        }
        if (this.right_ != null) {
            sb.append(" ");
            sb.append(this.right_length_);
            sb.append(this.right_);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public double getCost(EditTreeBuilder builder) {
        double cost = 0.0;
        if (this.left_ != null) {
            cost += this.left_.getCost(builder);
        }
        if (this.right_ != null) {
            cost += this.right_.getCost(builder);
        }
        return cost;
    }

    public EditTree getLeft() {
        return this.left_;
    }

    public EditTree getRight() {
        return this.right_;
    }

    @Override
    public void increment(Counter<String> counter) {
        if (this.left_ != null) {
            this.left_.increment(counter);
        }
        if (this.right_ != null) {
            this.right_.increment(counter);
        }
    }

    @Override
    public String apply(String input, int start, int end) {
        int middle_length;
        String left = "";
        if (this.left_ != null) {
            if (start + this.left_length_ > end) {
                return null;
            }
            left = this.left_.apply(input, start, start + this.left_length_);
            if (left == null) {
                return null;
            }
        }
        String right = "";
        if (this.right_ != null) {
            if (end - this.right_length_ < start) {
                return null;
            }
            right = this.right_.apply(input, end - this.right_length_, end);
            if (right == null) {
                return null;
            }
        }
        if ((middle_length = end - start - this.left_length_ - this.right_length_) <= 0) {
            return null;
        }
        String middle = input.substring(start + this.left_length_, start + this.left_length_ + middle_length);
        return left + middle + right;
    }

    public int getLeftInputLength() {
        return this.left_length_;
    }

    public int getRightnputLength() {
        return this.right_length_;
    }

    @Override
    public int getFixedInputLength() {
        int fixed_length = 0;
        if (this.left_ != null) {
            fixed_length += this.left_.getFixedInputLength();
        }
        if (this.right_ != null) {
            fixed_length += this.right_.getFixedInputLength();
        }
        return fixed_length;
    }

    @Override
    public int getFixedOutputLength() {
        int fixed_length = 0;
        if (this.left_ != null) {
            fixed_length += this.left_.getFixedOutputLength();
        }
        if (this.right_ != null) {
            fixed_length += this.right_.getFixedOutputLength();
        }
        return fixed_length;
    }

    public int hashCode() {
        if (this.hash_code_ == 0) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.left_ == null ? 0 : this.left_.hashCode());
            result = 31 * result + this.left_length_;
            result = 31 * result + (this.right_ == null ? 0 : this.right_.hashCode());
            this.hash_code_ = result = 31 * result + this.right_length_;
        }
        return this.hash_code_;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MatchNode other = (MatchNode)obj;
        if (this.left_ == null ? other.left_ != null : !this.left_.equals(other.left_)) {
            return false;
        }
        if (this.left_length_ != other.left_length_) {
            return false;
        }
        if (this.right_ == null ? other.right_ != null : !this.right_.equals(other.right_)) {
            return false;
        }
        return this.right_length_ == other.right_length_;
    }
}

