/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.doccat;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.SystemInputStreamFactory;
import opennlp.tools.cmdline.doccat.DoccatModelLoader;
import opennlp.tools.doccat.DoccatModel;
import opennlp.tools.doccat.DocumentCategorizerME;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.ParagraphStream;
import opennlp.tools.util.PlainTextByLineStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoccatTool
extends BasicCmdLineTool {
    private static final Logger logger = LoggerFactory.getLogger(DoccatTool.class);

    @Override
    public String getShortDescription() {
        return "Learned document categorizer";
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model < documents";
    }

    @Override
    public void run(String[] args) {
        if (0 == args.length) {
            logger.info(this.getHelp());
        } else {
            DoccatModel model = (DoccatModel)new DoccatModelLoader().load(new File(args[0]));
            DocumentCategorizerME documentCategorizerME = new DocumentCategorizerME(model);
            PerformanceMonitor perfMon = new PerformanceMonitor("doc");
            perfMon.start();
            try {
                String document;
                ParagraphStream documentStream = new ParagraphStream(new PlainTextByLineStream((InputStreamFactory)new SystemInputStreamFactory(), SystemInputStreamFactory.encoding()));
                while ((document = (String)documentStream.read()) != null) {
                    String[] tokens = WhitespaceTokenizer.INSTANCE.tokenize(document);
                    double[] prob = documentCategorizerME.categorize(tokens);
                    String category = documentCategorizerME.getBestCategory(prob);
                    DocumentSample sample2 = new DocumentSample(category, tokens);
                    logger.info(sample2.toString());
                    perfMon.incrementCounter();
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError(e);
            }
            perfMon.stopAndPrintFinalResult();
        }
    }
}

