/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import opennlp.tools.namefind.BilouNameFinderSequenceValidator;
import opennlp.tools.namefind.BioCodec;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.SequenceValidator;
import opennlp.tools.util.Span;

public class BilouCodec
implements SequenceCodec<String> {
    public static final String START = "start";
    public static final String CONTINUE = "cont";
    public static final String LAST = "last";
    public static final String UNIT = "unit";
    public static final String OTHER = "other";

    @Override
    public Span[] decode(List<String> c) {
        int start = -1;
        int end = -1;
        ArrayList<Span> spans = new ArrayList<Span>(c.size());
        for (int li = 0; li < c.size(); ++li) {
            String chunkTag = c.get(li);
            if (chunkTag.endsWith(START)) {
                start = li;
                end = li + 1;
                continue;
            }
            if (chunkTag.endsWith(CONTINUE)) {
                end = li + 1;
                continue;
            }
            if (chunkTag.endsWith(LAST)) {
                if (start == -1) continue;
                spans.add(new Span(start, end + 1, BioCodec.extractNameType(c.get(li - 1))));
                start = -1;
                end = -1;
                continue;
            }
            if (!chunkTag.endsWith(UNIT)) continue;
            spans.add(new Span(li, li + 1, BioCodec.extractNameType(c.get(li))));
        }
        return spans.toArray(new Span[0]);
    }

    public String[] encode(Span[] names, int length) {
        Object[] outcomes = new String[length];
        Arrays.fill(outcomes, OTHER);
        for (Span name : names) {
            if (name.length() > 1) {
                outcomes[name.getStart()] = name.getType() == null ? "default-start" : name.getType() + "-start";
                for (int i = name.getStart() + 1; i < name.getEnd() - 1; ++i) {
                    outcomes[i] = name.getType() == null ? "default-cont" : name.getType() + "-cont";
                }
                if (name.getType() == null) {
                    outcomes[name.getEnd() - 1] = "default-last";
                    continue;
                }
                outcomes[name.getEnd() - 1] = name.getType() + "-last";
                continue;
            }
            outcomes[name.getEnd() - 1] = name.getType() == null ? "default-unit" : name.getType() + "-unit";
        }
        return outcomes;
    }

    @Override
    public SequenceValidator<String> createSequenceValidator() {
        return new BilouNameFinderSequenceValidator();
    }

    @Override
    public boolean areOutcomesCompatible(String[] outcomes) {
        HashSet<String> start = new HashSet<String>();
        HashSet<String> cont = new HashSet<String>();
        HashSet<String> last2 = new HashSet<String>();
        HashSet<String> unit = new HashSet<String>();
        for (String outcome : outcomes) {
            if (outcome.endsWith(START)) {
                start.add(outcome.substring(0, outcome.length() - START.length()));
                continue;
            }
            if (outcome.endsWith(CONTINUE)) {
                cont.add(outcome.substring(0, outcome.length() - CONTINUE.length()));
                continue;
            }
            if (outcome.endsWith(LAST)) {
                last2.add(outcome.substring(0, outcome.length() - LAST.length()));
                continue;
            }
            if (outcome.endsWith(UNIT)) {
                unit.add(outcome.substring(0, outcome.length() - UNIT.length()));
                continue;
            }
            if (outcome.equals(OTHER)) continue;
            return false;
        }
        if (start.isEmpty() && unit.isEmpty()) {
            return false;
        }
        for (String startPrefix : start) {
            if (last2.contains(startPrefix)) continue;
            return false;
        }
        for (String contPrefix : cont) {
            if (start.contains(contPrefix) || last2.contains(contPrefix)) continue;
            return false;
        }
        for (String lastPrefix : last2) {
            if (start.contains(lastPrefix)) continue;
            return false;
        }
        return true;
    }
}

