/*
 * Decompiled with CFR 0.152.
 */
package experimental.analyzer.simple;

import experimental.analyzer.Analyzer;
import experimental.analyzer.AnalyzerInstance;
import experimental.analyzer.AnalyzerReading;
import experimental.analyzer.AnalyzerTag;
import experimental.analyzer.simple.SimpleAnalyzerInstance;
import experimental.analyzer.simple.SimpleAnalyzerModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import marmot.util.Numerics;
import marmot.util.SymbolTable;
import org.javatuples.Pair;

public class SimpleAnalyzer
implements Analyzer {
    private static final long serialVersionUID = 1L;
    private SimpleAnalyzerModel model_;
    private double threshold_;
    private Mode mode_;
    private List<List<Integer>> pairs_;

    public SimpleAnalyzer(SimpleAnalyzerModel model, double threshold, Mode mode, Collection<Pair<AnalyzerTag, AnalyzerTag>> coupled) {
        this.model_ = model;
        this.threshold_ = threshold;
        this.mode_ = mode;
        if (coupled != null) {
            SymbolTable<AnalyzerTag> table = this.model_.getTagTable();
            this.pairs_ = new ArrayList<List<Integer>>(table.size());
            for (int i = 0; i < table.size(); ++i) {
                this.pairs_.add(Collections.emptyList());
            }
            for (Pair<AnalyzerTag, AnalyzerTag> pair : coupled) {
                List<Integer> list;
                int index = table.toIndex((AnalyzerTag)pair.getValue0());
                int other_index = table.toIndex((AnalyzerTag)pair.getValue1());
                assert (index != other_index);
                if (index > other_index) {
                    int temp = other_index;
                    other_index = index;
                    index = temp;
                }
                if ((list = this.pairs_.get(other_index)).isEmpty()) {
                    list = new LinkedList<Integer>();
                    this.pairs_.set(other_index, list);
                }
                list.add(index);
            }
        }
    }

    @Override
    public Collection<AnalyzerReading> analyze(AnalyzerInstance instance) {
        SimpleAnalyzerInstance simple_instance = this.model_.getInstance(instance);
        double[] scores = new double[this.model_.getNumTags()];
        this.model_.score(simple_instance, scores);
        LinkedList<AnalyzerReading> readings = new LinkedList<AnalyzerReading>();
        SymbolTable<AnalyzerTag> tag_table = this.model_.getTagTable();
        tag_table.setBidirectional(true);
        Set<Map.Entry<AnalyzerTag, Integer>> tags = tag_table.entrySet();
        switch (this.mode_) {
            case binary: {
                this.binaryScore(scores);
                break;
            }
            case classifier: {
                this.classifierScore(scores);
                break;
            }
            default: {
                throw new RuntimeException("Unknown mode: " + this.mode_);
            }
        }
        boolean[] activated = new boolean[scores.length];
        for (int tag_index = 0; tag_index < activated.length; ++tag_index) {
            boolean bl = activated[tag_index] = scores[tag_index] > this.threshold_;
            if (this.pairs_ == null) continue;
            List<Integer> related_tags = this.pairs_.get(tag_index);
            for (int other_index : related_tags) {
                double other_diff;
                assert (other_index < tag_index);
                if (activated[other_index] == activated[tag_index]) continue;
                double d = Math.abs(this.threshold_ - scores[tag_index]);
                if (d > (other_diff = Math.abs(this.threshold_ - scores[other_index]))) {
                    activated[other_index] = activated[tag_index];
                } else {
                    activated[tag_index] = activated[other_index];
                }
                System.err.format("%s: %s %s [%s]\n", instance.getForm(), tag_table.toSymbol(tag_index), tag_table.toSymbol(other_index), activated[tag_index]);
            }
        }
        AnalyzerTag max_tag = null;
        double max_prob = Double.NEGATIVE_INFINITY;
        for (Map.Entry entry : tags) {
            double prob;
            int tag_index = (Integer)entry.getValue();
            if (activated[tag_index]) {
                AnalyzerTag tag = (AnalyzerTag)entry.getKey();
                readings.add(new AnalyzerReading(tag, null));
            }
            if (!((prob = scores[tag_index]) > max_prob)) continue;
            max_prob = prob;
            max_tag = (AnalyzerTag)entry.getKey();
        }
        if (readings.isEmpty()) {
            readings.add(new AnalyzerReading(max_tag, null));
        }
        return readings;
    }

    private void classifierScore(double[] scores) {
        double sum = Double.NEGATIVE_INFINITY;
        for (double v : scores) {
            sum = Numerics.sumLogProb(v, sum);
        }
        for (int tag_index = 0; tag_index < scores.length; ++tag_index) {
            double prob;
            double score = scores[tag_index];
            scores[tag_index] = prob = Math.exp(score - sum);
        }
    }

    private void binaryScore(double[] scores) {
        for (int tag_index = 0; tag_index < scores.length; ++tag_index) {
            double prob;
            double score = scores[tag_index];
            scores[tag_index] = prob = Math.exp(score - Numerics.sumLogProb(score, 0.0));
        }
    }

    @Override
    public String represent(AnalyzerInstance instance) {
        SimpleAnalyzerInstance simple_instance = this.model_.getInstance(instance);
        return Arrays.toString(simple_instance.getFeatIndexes());
    }

    @Override
    public int getNumTags() {
        return this.model_.getNumTags();
    }

    @Override
    public boolean isUnknown(AnalyzerInstance instance) {
        return this.model_.isUnknown(instance);
    }

    public SimpleAnalyzerModel getModel() {
        return this.model_;
    }

    public Mode getMode() {
        return this.mode_;
    }

    public static enum Mode {
        binary,
        classifier;

    }
}

