/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class FileOptions {
    public static final String FORM_INDEX = "form-index";
    public static final String LEMMA_INDEX = "lemma-index";
    public static final String TAG_INDEX = "tag-index";
    public static final String MORPH_INDEX = "morph-index";
    public static final String LIMIT = "limit";
    public static final String FST_MORPH_INDEX = "token-feature-index";
    private int form_index_;
    private int lemma_index_;
    private int tag_index_;
    private int morph_index_;
    private List<Integer> token_feature_index_;
    private String filename_;
    private int limit_;

    public FileOptions(String option_string) {
        this.parse(option_string);
    }

    private void parse(String option_string) {
        String[] args;
        this.form_index_ = -1;
        this.lemma_index_ = -1;
        this.tag_index_ = -1;
        this.morph_index_ = -1;
        this.limit_ = -1;
        this.token_feature_index_ = new LinkedList<Integer>();
        this.filename_ = null;
        for (String arg : args = option_string.split(",")) {
            if (arg.length() == 0) continue;
            int index = arg.indexOf(61);
            if (index < 0) {
                if (this.filename_ != null) {
                    throw new RuntimeException("Option string contains more than one filename: " + option_string);
                }
                this.filename_ = arg;
                continue;
            }
            String option = arg.substring(0, index);
            String value = arg.substring(index + 1, arg.length());
            if (option.equalsIgnoreCase(FORM_INDEX)) {
                if (this.form_index_ != -1) {
                    throw new RuntimeException("Option string contains more than one form index: " + option_string);
                }
                this.form_index_ = Integer.parseInt(value);
                continue;
            }
            if (option.equalsIgnoreCase(LEMMA_INDEX)) {
                if (this.lemma_index_ != -1) {
                    throw new RuntimeException("Option string contains more than one lemma index: " + option_string);
                }
                this.lemma_index_ = Integer.parseInt(value);
                continue;
            }
            if (option.equalsIgnoreCase(TAG_INDEX)) {
                if (this.tag_index_ != -1) {
                    throw new RuntimeException("Option string contains more than one tag index: " + option_string);
                }
                this.tag_index_ = Integer.parseInt(value);
                continue;
            }
            if (option.equalsIgnoreCase(MORPH_INDEX)) {
                if (this.morph_index_ != -1) {
                    throw new RuntimeException("Option string contains more than one morph index: " + option_string);
                }
                this.morph_index_ = Integer.parseInt(value);
                continue;
            }
            if (option.equalsIgnoreCase(FST_MORPH_INDEX)) {
                this.token_feature_index_.add(Integer.parseInt(value));
                continue;
            }
            if (option.equalsIgnoreCase(LIMIT)) {
                if (this.limit_ != -1) {
                    throw new RuntimeException("Option string contains more than one limit: " + option_string);
                }
                this.limit_ = Integer.parseInt(value);
                continue;
            }
            throw new RuntimeException("Unknown option: " + option);
        }
        if (this.filename_ == null) {
            throw new RuntimeException("No filename in option string: " + option_string);
        }
    }

    public String getFilename() {
        return this.filename_;
    }

    public int getLimit() {
        return this.limit_;
    }

    public int getFormIndex() {
        return this.form_index_;
    }

    public int getTagIndex() {
        return this.tag_index_;
    }

    public int getMorphIndex() {
        return this.morph_index_;
    }

    public void setTagIndex(int index) {
        this.tag_index_ = index;
    }

    public void setMorphIndex(int index) {
        this.morph_index_ = index;
    }

    public InputStream getInputStream() {
        InputStream input_stream = null;
        try {
            if (this.filename_.toLowerCase().startsWith("res://")) {
                String name = this.filename_.substring(6);
                input_stream = this.getClass().getResourceAsStream(name);
                if (input_stream == null) {
                    throw new RuntimeException("Resource not found: " + this.filename_);
                }
            } else {
                input_stream = new FileInputStream(this.filename_);
            }
            if (this.filename_.toLowerCase().endsWith(".gz")) {
                input_stream = new GZIPInputStream(input_stream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return input_stream;
    }

    public List<Integer> getTokenFeatureIndex() {
        return this.token_feature_index_;
    }

    public void dieIfPropertyIsEmpty(String property) {
        if (this.morph_index_ == -1) {
            System.err.format("Error: File property '%s' needs to be set!\n", property);
            System.exit(1);
        }
    }

    public int getLemmaIndex() {
        return this.lemma_index_;
    }
}

