/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn.instruct;

import java.util.function.Supplier;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.PushElaborator;
import net.sf.saxon.expr.elab.PushEvaluator;
import net.sf.saxon.expr.elab.SequenceEvaluator;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class Assign
extends Instruction
implements BindingReference {
    private final Operand selectOp;
    private GlobalVariable binding;

    public Assign(Expression select) {
        this.selectOp = new Operand(this, select, OperandRole.NAVIGATE);
    }

    @Override
    public void setStaticType(SequenceType type, GroundedValue constantValue, int properties) {
    }

    public void setSelectExpr(Expression select) {
        this.selectOp.setChildExpression(select);
    }

    public Expression getSelectExpr() {
        return this.selectOp.getChildExpression();
    }

    @Override
    public Iterable<Operand> operands() {
        return this.selectOp;
    }

    @Override
    public void fixup(Binding binding) {
        this.binding = (GlobalVariable)binding;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        if (this.binding.getRequiredType() != null) {
            TypeChecker tc = visitor.getConfiguration().getTypeChecker(false);
            Supplier<RoleDiagnostic> role = () -> new RoleDiagnostic(3, this.binding.getObjectName().getDisplayName(), 0);
            this.selectOp.setChildExpression(tc.staticTypeCheck(this.getSelectExpr(), this.binding.getRequiredType(), role, visitor));
        }
        return this;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 0x2000000;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        Assign a2 = new Assign(this.getSelectExpr().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, a2);
        a2.binding = this.binding;
        return a2;
    }

    @Override
    public int getInstructionNameCode() {
        return 257;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        if ("JS".equals(out.getOptions().target)) {
            throw new XPathException("Export failure: SaxonJS does not implement saxon:assign", "SXJS0001");
        }
        out.startElement("assign", this);
        out.emitAttribute("name", this.binding.getVariableQName());
        this.getSelectExpr().export(out);
        out.endElement();
    }

    @Override
    public Elaborator getElaborator() {
        return new AssignElaborator();
    }

    private static class AssignElaborator
    extends PushElaborator {
        private AssignElaborator() {
        }

        @Override
        public PushEvaluator elaborateForPush() {
            Assign expr = (Assign)this.getExpression();
            if (expr.binding == null) {
                throw new IllegalStateException("saxon:assign binding has not been fixed up");
            }
            SequenceEvaluator select = expr.getSelectExpr().makeElaborator().eagerly();
            return (output, context) -> {
                GroundedValue value = select.evaluate(context).materialize();
                Controller controller = context.getController();
                assert (controller != null);
                controller.getBindery(expr.getPackageData()).setGlobalVariable(expr.binding, value);
                return null;
            };
        }
    }
}

