/*
 * Decompiled with CFR 0.152.
 */
package lemming.test.lemma.toutanova;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import lemming.lemma.toutanova.Aligner;
import lemming.lemma.toutanova.SimpleAligner;
import org.junit.Assert;
import org.junit.Test;

public class SimpleAlignerTest {
    @Test
    public void mergeEmptyInputTest() {
        this.mergeEmptyInputTest(Arrays.asList(0, 1, 2, 3), Arrays.asList(2, 4));
        this.mergeEmptyInputTest(Arrays.asList(0, 1, 0, 3, 4, 5), Arrays.asList(4, 9));
        this.mergeEmptyInputTest(Arrays.asList(1, 1, 0, 1, 2, 3), Arrays.asList(1, 2, 2, 3));
    }

    private void mergeEmptyInputTest(List<Integer> alignment, List<Integer> expected) {
        List<Integer> merged = Aligner.StaticMethods.mergeEmptyInputSegments(alignment);
        Assert.assertEquals(expected, merged);
    }

    @Test
    public void test() {
        SimpleAligner aligner = new SimpleAligner();
        this.testAligner(aligner, "read", "read", Arrays.asList(1, 1, 1, 1, 1, 1, 1, 1));
        this.testAligner(aligner, "reads", "read", Arrays.asList(1, 1, 1, 1, 1, 1, 2, 1));
        this.testAligner(aligner, "^reading$", "^read$", Arrays.asList(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1));
    }

    @Test
    public void testToPairs() {
        this.testToPairs("read", "read", Arrays.asList(1, 1, 1, 1, 1, 1, 1, 1), Arrays.asList("r", "r", "e", "e", "a", "a", "d", "d"));
        this.testToPairs("reads", "read", Arrays.asList(1, 1, 1, 1, 1, 1, 2, 1), Arrays.asList("r", "r", "e", "e", "a", "a", "ds", "d"));
        this.testToPairs("^s\u00e4nge$", "^singen$", Arrays.asList(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2), Arrays.asList("^", "^", "s", "s", "\u00e4", "i", "n", "n", "g", "g", "e", "e", "$", "n$"));
    }

    protected void testToPairs(String input, String output, List<Integer> indexes, List<String> expected_strings) {
        LinkedList<Aligner.Pair> expected = new LinkedList<Aligner.Pair>();
        Iterator<String> iterator2 = expected_strings.iterator();
        while (iterator2.hasNext()) {
            String input_segment = iterator2.next();
            String output_segment = iterator2.next();
            Aligner.Pair pair = new Aligner.Pair(input_segment, output_segment);
            expected.add(pair);
        }
        Assert.assertEquals(expected, Aligner.Pair.toPairs(input, output, indexes));
    }

    protected void testAligner(Aligner aligner, String input, String output, List<Integer> expected) {
        List<Integer> actual = aligner.align(input, output);
        Assert.assertEquals(expected, actual);
    }
}

