/*
 * Decompiled with CFR 0.152.
 */
package marmot.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Counter<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<T, Double> storage_;
    private Double total_count_;
    private Double default_value_;

    public Set<Map.Entry<T, Double>> entrySet() {
        return this.storage_.entrySet();
    }

    public Counter(Double defaultValue, int initialCapacity) {
        this.storage_ = new HashMap<T, Double>(initialCapacity);
        this.default_value_ = defaultValue;
        this.total_count_ = 0.0;
    }

    public Counter(Double defaultValue) {
        this(defaultValue, 10);
    }

    public Counter() {
        this(0.0);
    }

    public void set(T item, Double freq) {
        if (freq != this.default_value_) {
            this.storage_.put(item, freq);
        } else {
            this.storage_.remove(item);
        }
    }

    public void increment(T item, Double freq) {
        if (!this.storage_.containsKey(item)) {
            this.storage_.put(item, freq + this.default_value_);
        } else {
            this.storage_.put(item, freq + this.storage_.get(item));
        }
        Double newFreq = this.storage_.get(item);
        if (newFreq == this.default_value_) {
            this.storage_.remove(item);
        }
        this.total_count_ = this.total_count_ + freq;
    }

    public Double count(T item) {
        if (!this.storage_.containsKey(item)) {
            return this.default_value_;
        }
        return this.storage_.get(item);
    }

    public Double totalCount() {
        return this.total_count_;
    }

    public int size() {
        return this.storage_.size();
    }

    public String toString() {
        return this.storage_.toString();
    }

    public Collection<Double> counts() {
        return this.storage_.values();
    }

    public void clear() {
        this.storage_.clear();
    }

    public Set<T> keySet() {
        return this.storage_.keySet();
    }

    public List<Map.Entry<T, Double>> sortedEntries() {
        ArrayList<Map.Entry<T, Double>> list = new ArrayList<Map.Entry<T, Double>>(this.storage_.entrySet());
        list.sort((o1, o2) -> -Double.compare((Double)o1.getValue(), (Double)o2.getValue()));
        return list;
    }

    public List<Map.Entry<T, Double>> sortedEntries(int length) {
        List<Map.Entry<T, Double>> list = this.sortedEntries();
        if (list.size() > length) {
            list = list.subList(0, length);
        }
        return list;
    }

    public T max() {
        Map.Entry<T, Double> max_entry = null;
        for (Map.Entry<T, Double> entry : this.storage_.entrySet()) {
            if (max_entry != null && !((Double)max_entry.getValue() < entry.getValue())) continue;
            max_entry = entry;
        }
        return (T)max_entry.getKey();
    }
}

