/*
 * Decompiled with CFR 0.152.
 */
package chipmunk.segmenter;

import cc.mallet.optimize.LimitedMemoryBFGS;
import cc.mallet.optimize.Optimizable;
import cc.mallet.optimize.OptimizationException;
import chipmunk.segmenter.Scorer;
import chipmunk.segmenter.SegmentationDecoder;
import chipmunk.segmenter.SegmentationInstance;
import chipmunk.segmenter.SegmentationResult;
import chipmunk.segmenter.Segmenter;
import chipmunk.segmenter.SegmenterModel;
import chipmunk.segmenter.SegmenterOptions;
import chipmunk.segmenter.SemiCrfObjective;
import chipmunk.segmenter.StatSegmenter;
import chipmunk.segmenter.Word;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import marmot.util.DynamicWeights;
import marmot.util.Numerics;

public class SegmenterTrainer {
    private SegmenterOptions options_;

    public SegmenterTrainer(SegmenterOptions options) {
        this.options_ = options;
    }

    public Segmenter train(Collection<Word> words) {
        SegmenterModel model = new SegmenterModel();
        model.init(this.options_, words);
        if (this.options_.getBoolean("crf-mode").booleanValue()) {
            if (this.options_.getBoolean("verbose").booleanValue()) {
                System.err.println("Training CRF");
            }
            this.run_crf(model, words);
        } else {
            if (this.options_.getBoolean("verbose").booleanValue()) {
                System.err.println("Training Perceptron");
            }
            this.run_perceptron(model, words);
        }
        model.setFinal();
        StatSegmenter segmenter = new StatSegmenter(model);
        return segmenter;
    }

    private void run_crf(SegmenterModel model, Collection<Word> words) {
        SemiCrfObjective objective = new SemiCrfObjective(model, words, this.options_.getDouble("penalty"));
        objective.init();
        LimitedMemoryBFGS optimizer = new LimitedMemoryBFGS((Optimizable.ByGradientValue)objective);
        Logger.getLogger(optimizer.getClass().getName()).setLevel(Level.OFF);
        try {
            optimizer.optimize(1);
            for (int i = 0; i < 200 && !optimizer.isConverged(); ++i) {
                optimizer.optimize(1);
            }
        }
        catch (OptimizationException | IllegalArgumentException throwable) {
            // empty catch block
        }
    }

    private void run_perceptron(SegmenterModel model, Collection<Word> words) {
        DynamicWeights weights = new DynamicWeights(null);
        DynamicWeights sum_weights = null;
        if (this.options_.getBoolean("averaging").booleanValue()) {
            sum_weights = new DynamicWeights(null);
        }
        model.setWeights(weights);
        SegmentationDecoder decoder = new SegmentationDecoder(model);
        ArrayList<Word> word_array = new ArrayList<Word>(words);
        for (int iter = 0; iter < this.options_.getInt("num-iterations"); ++iter) {
            int number = 0;
            Collections.shuffle(word_array, this.options_.getRandom());
            for (Word word : word_array) {
                SegmentationInstance instance = model.getInstance(word);
                SegmentationResult result = decoder.decode(instance);
                double score = result.getScore();
                double exact_score = model.getScore(instance, result);
                assert (Numerics.approximatelyEqual(score, exact_score)) : String.format("%d %d", score, exact_score);
                if (!result.isCorrect(instance)) {
                    SegmentationResult closest_result = Scorer.closest(result, instance.getResults(), instance.getLength());
                    model.update(instance, result, -1.0);
                    model.update(instance, closest_result, 1.0);
                    if (sum_weights != null) {
                        double amount = word_array.size() - number;
                        assert (amount > 0.0);
                        model.setWeights(sum_weights);
                        model.update(instance, result, -amount);
                        model.update(instance, closest_result, amount);
                        model.setWeights(weights);
                    }
                }
                ++number;
            }
            if (sum_weights == null) continue;
            double weights_scaling = 1.0 / (((double)iter + 1.0) * (double)word_array.size());
            double sum_weights_scaling = ((double)iter + 2.0) / ((double)iter + 1.0);
            for (int i = 0; i < weights.getLength(); ++i) {
                weights.set(i, sum_weights.get(i) * weights_scaling);
                sum_weights.set(i, sum_weights.get(i) * sum_weights_scaling);
            }
        }
    }
}

