/*
 * Decompiled with CFR 0.152.
 */
package marmot.util;

import java.security.InvalidParameterException;

public class Timer {
    private long total_time_;
    private long current_start_time_;
    private State state_;

    public Timer() {
        this.reset();
    }

    public void start() {
        this.current_start_time_ = System.currentTimeMillis();
        this.state_ = State.Running;
    }

    public void stop() {
        if (this.state_.equals((Object)State.Stopped)) {
            throw new InvalidParameterException();
        }
        this.total_time_ += System.currentTimeMillis() - this.current_start_time_;
    }

    public long getTime() {
        long time = this.total_time_;
        if (this.state_.equals((Object)State.Running)) {
            time += System.currentTimeMillis() - this.current_start_time_;
        }
        return time;
    }

    public long getTimeInSeconds() {
        return this.getTime() / 1000L;
    }

    public void reset() {
        this.total_time_ = 0L;
        this.current_start_time_ = -1L;
        this.state_ = State.Stopped;
    }

    private static enum State {
        Running,
        Stopped;

    }
}

