/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.conllu;

import java.io.IOException;
import opennlp.tools.formats.conllu.ConlluSentence;
import opennlp.tools.formats.conllu.ConlluWordLine;
import opennlp.tools.tokenize.TokenSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.StringUtil;

public class ConlluTokenSampleStream
extends FilterObjectStream<ConlluSentence, TokenSample> {
    public ConlluTokenSampleStream(ObjectStream<ConlluSentence> samples) {
        super(samples);
    }

    @Override
    public TokenSample read() throws IOException {
        ConlluSentence sentence = (ConlluSentence)this.samples.read();
        if (sentence != null) {
            if (sentence.getTextComment() != null) {
                StringBuilder text = new StringBuilder(sentence.getTextComment());
                int searchIndex = 0;
                for (ConlluWordLine wordLine : sentence.getWordLines()) {
                    if (wordLine.getId().contains(".")) continue;
                    String token2 = wordLine.getForm();
                    int tokenIndex = text.indexOf(token2, searchIndex);
                    if (tokenIndex == -1) {
                        throw new IOException(String.format("Failed to match token [%s] in sentence [%s] with text [%s]", token2, sentence.getSentenceIdComment(), text));
                    }
                    searchIndex = tokenIndex + token2.length();
                    if (searchIndex >= text.length() || StringUtil.isWhitespace(text.charAt(searchIndex))) continue;
                    text.insert(searchIndex, "<SPLIT>");
                }
                return TokenSample.parse(text.toString(), "<SPLIT>");
            }
            throw new IOException("Sentence is missing raw text sample!");
        }
        return null;
    }
}

