/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.IdentityConstraint;
import com.saxonica.ee.schema.IdentityConstraintReference;
import com.saxonica.ee.schema.IdentityField;
import com.saxonica.ee.schema.IdentitySelector;
import com.saxonica.ee.schema.Key;
import com.saxonica.ee.schema.KeyRef;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SingleNamespaceSchema;
import com.saxonica.ee.schema.Unique;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.XSDFieldOrSelector;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.SchemaException;

public class XSDIdentityConstraint
extends SchemaElement {
    private boolean isRef = false;
    private StructuredQName constraintName;
    private IdentityConstraint identityConstraint = null;

    @Override
    public void prepareAttributes() throws SchemaException {
        StructuredQName nameCode;
        String[] allowed;
        AttributeCollection atts = this.getAttributeList();
        if (this.getFingerprint() == 600) {
            allowed = new String[]{"id", "name", "ref", "refer"};
            this.allowAttributes(atts, allowed);
        } else {
            allowed = new String[]{"id", "name", "ref"};
            this.allowAttributes(atts, allowed);
        }
        this.processId();
        this.checkMutuallyExclusiveAttributes("ref", "name");
        this.checkMutuallyExclusiveAttributes("ref", "refer");
        String refAtt = atts.getValue("", "ref");
        if (refAtt != null) {
            if (this.getXSDSchema().getSchemaCompiler().getLanguageVersion() == 10) {
                this.error("The @ref attribute cannot be used on an integrity constraint unless XSD 1.1 is enabled");
            }
            nameCode = this.getComponentName(refAtt, 0);
            this.isRef = true;
        } else {
            String name = atts.getValue("", "name");
            if (name == null) {
                this.missingAttribute("name");
                name = "saxon-error-" + this.getLocalPart() + "-name";
            }
            nameCode = this.getComponentName(name, 1);
            if (this.getFingerprint() == 600) {
                StructuredQName referFingerprint;
                String referAtt = atts.getValue("", "refer");
                if (referAtt == null) {
                    this.missingAttribute("refer");
                    return;
                }
                try {
                    referFingerprint = this.getComponentName(referAtt, 0);
                }
                catch (SchemaException err) {
                    referFingerprint = StandardNames.SQ_XS_INVALID_NAME;
                    this.error(err.getMessage());
                }
                this.identityConstraint = new KeyRef((EnterpriseConfiguration)this.getConfiguration(), referFingerprint);
            } else {
                this.identityConstraint = this.getFingerprint() == 625 ? new Unique() : new Key();
            }
            SingleNamespaceSchema schema = this.getSchema();
            this.identityConstraint.setConfiguration((EnterpriseConfiguration)this.getConfiguration());
            this.identityConstraint.setLocator(this);
            this.identityConstraint.setConstraintName(nameCode);
            if (schema.getIdentityConstraint(nameCode) != null) {
                this.duplicate("identity constraint", name);
            }
            schema.addIdentityConstraint(this.identityConstraint);
        }
        this.constraintName = nameCode;
    }

    public boolean isReference() {
        return this.isRef;
    }

    public IdentityConstraintReference getIdentityConstraint() {
        if (this.constraintName == null) {
            return null;
        }
        IdentityConstraintReference ref = new IdentityConstraintReference(this.constraintName, this.getFingerprint(), (EnterpriseConfiguration)this.getConfiguration(), this);
        if (this.isRef) {
            return ref;
        }
        if (this.identityConstraint == null) {
            return null;
        }
        ref.setTarget(this.identityConstraint);
        return ref;
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        NodeImpl child;
        boolean foundAnnotation = false;
        boolean foundSelector = false;
        boolean foundField = false;
        AxisIterator iter = this.iterateAxis((byte)3);
        block5: while ((child = (NodeImpl)iter.next()) != null) {
            switch (child.getFingerprint()) {
                case 578: {
                    if (foundAnnotation) {
                        this.duplicateElement("annotation");
                    }
                    if (foundSelector || foundField) {
                        this.mustBeFirstElement("annotation");
                    }
                    foundAnnotation = true;
                    continue block5;
                }
                case 618: {
                    if (foundField) {
                        this.mustPrecede("selector", "field");
                    }
                    if (foundSelector) {
                        this.duplicateElement("selector");
                    }
                    foundSelector = true;
                    continue block5;
                }
                case 594: {
                    foundField = true;
                    continue block5;
                }
            }
            this.illegalElement(child);
        }
        if (this.isRef) {
            if (foundSelector) {
                this.mutuallyExclusiveElementAndAttribute("selector", "ref");
            }
            if (foundField) {
                this.mutuallyExclusiveElementAndAttribute("field", "ref");
            }
        } else {
            if (!foundSelector) {
                this.missingChildElement("selector");
            }
            if (!foundField) {
                this.missingChildElement("field");
            }
        }
    }

    @Override
    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        NodeImpl child;
        if (this.identityConstraint == null) {
            return;
        }
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeImpl)iter.next()) != null) {
            switch (child.getFingerprint()) {
                case 578: {
                    break;
                }
                case 618: {
                    IdentitySelector selector = ((XSDFieldOrSelector)child).getIdentitySelector();
                    this.identityConstraint.setSelector(selector);
                    break;
                }
                case 594: {
                    IdentityField field = ((XSDFieldOrSelector)child).getIdentityField();
                    this.identityConstraint.addField(field);
                    break;
                }
            }
        }
    }
}

