/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.extfn;

import com.saxonica.config.JavaExtensionLibrary;
import com.saxonica.config.ProfessionalConfiguration;
import com.saxonica.functions.hof.CurriedFunction;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.ma.map.DictionaryMap;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyFunctionType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.SequenceType;

public class ObjectMap
extends SystemFunction {
    public MapItem call(XPathContext context, Sequence[] arguments) throws XPathException {
        ObjectValue value = (ObjectValue)arguments[0].head();
        return ObjectMap.toMap(context.getConfiguration(), value, null);
    }

    public static MapItem toMap(Configuration config, ObjectValue value, String required) {
        Object obj = value.getObject();
        DictionaryMap mapView = new DictionaryMap();
        if (!config.isLicensedFeature(8) || !config.getBooleanProperty(Feature.ALLOW_EXTERNAL_FUNCTIONS)) {
            return mapView;
        }
        Map<String, Function> methodMap = ObjectMap.makeMethodMap(config, obj.getClass(), required);
        for (String key : methodMap.keySet()) {
            Function method = methodMap.get(key);
            Sequence[] boundArgs = new Sequence[method.getArity()];
            boundArgs[0] = value;
            CurriedFunction fn = new CurriedFunction(method, boundArgs);
            mapView.initialPut(key, fn);
        }
        Callable returnThis = (context, args) -> value;
        mapView.initialPut("this", new CallableFunction(0, returnThis, (FunctionItemType)AnyFunctionType.getInstance()));
        return mapView;
    }

    public static Map<String, Function> makeMethodMap(Configuration config, Class javaClass, String required) {
        HashMap<String, Function> methodMap = new HashMap<String, Function>();
        Object theException = null;
        ArrayList candidateMethods = new ArrayList(10);
        Object resultClass = null;
        HashSet<String> methodsFound = new HashSet<String>();
        HashMap<String, Method> retainedMethods = new HashMap<String, Method>();
        Method[] methods = javaClass.getMethods();
        boolean consistentReturnType = true;
        for (Method theMethod : methods) {
            if (!Modifier.isPublic(theMethod.getModifiers()) || Modifier.isStatic(theMethod.getModifiers()) || theMethod.isSynthetic()) continue;
            for (String name : new String[]{theMethod.getName(), theMethod.getName() + "_" + theMethod.getParameterCount()}) {
                if (required != null && !required.equals(name)) continue;
                if (methodsFound.contains(name)) {
                    retainedMethods.remove(name);
                    continue;
                }
                methodsFound.add(name);
                retainedMethods.put(name, theMethod);
            }
        }
        JavaExtensionLibrary lib = new JavaExtensionLibrary((ProfessionalConfiguration)config);
        IndependentContext env = new IndependentContext(config);
        for (Map.Entry entry : retainedMethods.entrySet()) {
            Function fn = ObjectMap.makeFunction(lib, env, javaClass, (Method)entry.getValue());
            if (fn == null) continue;
            methodMap.put((String)entry.getKey(), fn);
        }
        return methodMap;
    }

    private static Function makeFunction(JavaExtensionLibrary library, StaticContext env, Class javaClass, Method theMethod) {
        try {
            StructuredQName functionName = new StructuredQName("java", "java:" + javaClass.getName() + "?void=this", theMethod.getName());
            int methodArgs = theMethod.getParameterCount();
            int arity = 1 + methodArgs;
            if (methodArgs >= 1 && theMethod.getParameterTypes()[0].equals(XPathContext.class)) {
                --arity;
            }
            SymbolicName.F sName = new SymbolicName.F(functionName, arity);
            return library.getFunctionItem(sName, env);
        }
        catch (XPathException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static SequenceType getFieldType(Map<String, Function> methodMap, String field) {
        Function fn = methodMap.get(field);
        if (fn == null) {
            return null;
        }
        FunctionItemType base = fn.getFunctionItemType();
        SequenceType resultType = base.getResultType();
        SequenceType[] baseArgTypes = base.getArgumentTypes();
        SequenceType[] curriedArgTypes = Arrays.copyOfRange(baseArgTypes, 1, baseArgTypes.length);
        SpecificFunctionType curried = new SpecificFunctionType(curriedArgTypes, resultType);
        return SequenceType.makeSequenceType(curried, 16384);
    }
}

