/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn.instruct;

import net.sf.saxon.Controller;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BindingReference;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class Assign
extends Instruction
implements BindingReference {
    private Operand selectOp;
    private GlobalVariable binding;

    public Assign(Expression select) {
        this.selectOp = new Operand(this, select, OperandRole.NAVIGATE);
    }

    @Override
    public void setStaticType(SequenceType type, GroundedValue<?> constantValue, int properties) {
    }

    public void setSelectExpr(Expression select) {
        this.selectOp.setChildExpression(select);
    }

    public Expression getSelectExpr() {
        return this.selectOp.getChildExpression();
    }

    @Override
    public Iterable<Operand> operands() {
        return this.selectOp;
    }

    @Override
    public void fixup(Binding binding) {
        this.binding = (GlobalVariable)binding;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 0x2000000;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        Assign a2 = new Assign(this.getSelectExpr().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, a2);
        a2.binding = this.binding;
        return a2;
    }

    @Override
    public int getInstructionNameCode() {
        return 257;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        if (this.binding == null) {
            throw new IllegalStateException("saxon:assign binding has not been fixed up");
        }
        GroundedValue<?> value = this.getSelectExpr().iterate(context).materialize();
        Controller controller = context.getController();
        assert (controller != null);
        controller.getBindery(this.getPackageData()).setGlobalVariable(this.binding, value);
        return null;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("assign", this);
        out.emitAttribute("name", this.binding.getVariableQName());
        this.getSelectExpr().export(out);
        out.endElement();
    }
}

