/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.ids_mannheim.korap.response.Message;
import de.ids_mannheim.korap.util.KrillString;
import de.ids_mannheim.korap.util.QueryException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class Messages
implements Cloneable,
Iterable<Message> {
    ObjectMapper mapper = new ObjectMapper();
    private ArrayList<Message> messages = new ArrayList(3);

    @Override
    public Iterator<Message> iterator() {
        return new MessageIterator();
    }

    public Message add(int code, String message, String ... terms) {
        Message newMsg = new Message(code, message);
        this.messages.add(newMsg);
        if (terms != null) {
            for (String t : terms) {
                newMsg.addParameter(t);
            }
        }
        return newMsg;
    }

    public Message add(Message msg) {
        try {
            Message msgClone = (Message)msg.clone();
            this.messages.add(msgClone);
            return msgClone;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Message add(JsonNode msg) throws QueryException {
        if (!msg.isArray() || !msg.has(0)) {
            throw new QueryException(750, "Passed notifications are not well formed");
        }
        Message newMsg = new Message();
        int i = 1;
        if (msg.get(0).isNumber()) {
            newMsg.setCode(msg.get(0).asInt());
            if (!msg.has(1)) {
                throw new QueryException(750, "Passed notifications are not well formed");
            }
            newMsg.setMessage(msg.get(1).asText());
            i = (short)(i + 1);
        } else {
            newMsg.setMessage(msg.get(0).asText());
        }
        while (msg.has(i)) {
            int n = i;
            i = (short)(i + 1);
            newMsg.addParameter(msg.get(n).asText());
        }
        this.add(newMsg);
        return newMsg;
    }

    public Messages add(Messages msgs) {
        try {
            for (Message msg : msgs.getMessages()) {
                this.add((Message)msg.clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return this;
    }

    public Messages clear() {
        this.messages.clear();
        return this;
    }

    public int size() {
        return this.messages.size();
    }

    @JsonIgnore
    public Message get(int index) {
        if (index >= this.size()) {
            return null;
        }
        return this.messages.get(index);
    }

    @JsonIgnore
    public List<Message> getMessages() {
        return this.messages;
    }

    public Object clone() throws CloneNotSupportedException {
        Messages clone = new Messages();
        for (Message m : this.messages) {
            clone.add((Message)m.clone());
        }
        return clone;
    }

    public JsonNode toJsonNode() {
        ArrayNode messageArray = this.mapper.createArrayNode();
        for (Message msg : this.messages) {
            messageArray.add(msg.toJsonNode());
        }
        return messageArray;
    }

    public String toJsonString() {
        Object msg = "";
        try {
            return this.mapper.writeValueAsString(this.toJsonNode());
        }
        catch (Exception e) {
            msg = ", " + KrillString.quote(e.getLocalizedMessage());
            return "[620, \"Unable to generate JSON\"" + (String)msg + "]";
        }
    }

    private class MessageIterator
    implements Iterator<Message> {
        int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < Messages.this.messages.size();
        }

        @Override
        public Message next() {
            return Messages.this.messages.get(this.index++);
        }

        @Override
        public void remove() {
            Messages.this.messages.remove(this.index);
        }
    }
}

