/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode.converter;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.MessageTemplate;
import com.saxonica.ee.bytecode.util.OnEmpty;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.Converter;
import net.sf.saxon.value.AtomicValue;

public abstract class ConverterCompiler {
    public abstract void compileToItem(CompilerService var1, Expression var2) throws CannotCompileException;

    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        throw new CannotCompileException();
    }

    public static class GenericConverterCompiler
    extends ConverterCompiler {
        @Override
        public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
            throw new UnsupportedOperationException("compileToPrimitive for generic target type");
        }

        @Override
        public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
            CastExpression cast = (CastExpression)expression;
            Expression base = cast.getBaseExpression();
            AtomicType targetType = cast.getTargetType();
            Converter converter = cast.getConverter();
            Generator ga = compiler.getCurrentGenerator();
            GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
            ExpressionCompiler.visitAnnotation(compiler, "GenericConverterCompiler-Item");
            ExpressionCompiler.visitLineNumber(compiler, ga, expression);
            LabelInfo end = methodInfo.newLabel("endCast");
            LabelInfo notNull = methodInfo.newLabel("notNull");
            compiler.compileToItem(base);
            ga.dup();
            ga.ifNonNull(notNull.label());
            ga.pop();
            ga.push((String)null);
            ga.goTo(end);
            methodInfo.placeLabel(notNull);
            ga.checkClass(AtomicValue.class);
            int valueVar = methodInfo.allocateLocal(AtomicValue.class);
            ga.storeLocal(valueVar);
            if (converter == null) {
                LabelInfo weHaveAConverter = methodInfo.newLabel("weHaveAConverter");
                ConversionRules conversionRules = compiler.getConfiguration().getConversionRules();
                ExpressionCompiler.allocateStatic(compiler, conversionRules);
                ga.loadLocal(valueVar);
                ga.invokeInstanceMethod(AtomicValue.class, "getPrimitiveType", new Class[0]);
                ExpressionCompiler.allocateStatic(compiler, targetType);
                ga.invokeInstanceMethod(ConversionRules.class, "getConverter", AtomicType.class, AtomicType.class);
                ga.dup();
                ga.ifNonNull(weHaveAConverter.label());
                ga.pop();
                compiler.generateParameterizedDynamicError(new MessageTemplate(ga, "Casting {$1} to " + targetType + " is not permitted", valueVar), "XPTY0004", base.getLocation(), true);
                methodInfo.placeLabel(weHaveAConverter);
                if (((CastExpression)expression).getNamespaceResolver() != null) {
                    ExpressionCompiler.allocateStatic(compiler, ((CastExpression)expression).getNamespaceResolver());
                    ga.invokeInstanceMethod(Converter.class, "setNamespaceResolver", NamespaceResolver.class);
                }
            } else {
                ExpressionCompiler.allocateStatic(compiler, converter);
            }
            ga.loadLocal(valueVar);
            ga.invokeInstanceMethod(Converter.class, "convert", AtomicValue.class);
            if (converter != null && converter.isAlwaysSuccessful()) {
                ga.checkClass(AtomicValue.class);
            } else {
                ga.invokeInstanceMethod(ConversionResult.class, "asAtomic", new Class[0]);
            }
            methodInfo.placeLabel(end);
            methodInfo.releaseLocal(valueVar);
        }
    }
}

