/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.optim;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.bytecode.ByteCodeCandidate;
import com.saxonica.ee.bytecode.CompiledExpression;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.optim.CommonSubexpressionPromoter;
import com.saxonica.ee.optim.GeneralComparisonEE;
import com.saxonica.ee.optim.GlobalExtractor;
import com.saxonica.ee.optim.IndexedFilterExpression;
import com.saxonica.ee.optim.MultithreadedForEach;
import com.saxonica.ee.optim.SearchableValue;
import com.saxonica.ee.optim.SwitchExpression;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.StreamInstr;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import com.saxonica.ee.trans.TemplateRuleEE;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.Assignation;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.BooleanExpression;
import net.sf.saxon.expr.Calculator;
import net.sf.saxon.expr.CompareToIntegerConstant;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionOwner;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.GeneralComparison20;
import net.sf.saxon.expr.ItemChecker;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalBinding;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.OrExpression;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SimpleStepExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.SuppliedParameterReference;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.TailExpression;
import net.sf.saxon.expr.TryCatch;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.accum.Accumulator;
import net.sf.saxon.expr.accum.AccumulatorRegistry;
import net.sf.saxon.expr.accum.AccumulatorRule;
import net.sf.saxon.expr.compat.GeneralComparison10;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.CopyOf;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.expr.instruct.Fork;
import net.sf.saxon.expr.instruct.GlobalParam;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.NumberInstruction;
import net.sf.saxon.expr.instruct.OnEmptyExpr;
import net.sf.saxon.expr.instruct.OnNonEmptyExpr;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.TemplateRule;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.expr.instruct.UserFunctionParameter;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.ICompilerService;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.ConditionalSorter;
import net.sf.saxon.expr.sort.DocumentSorter;
import net.sf.saxon.expr.sort.SortExpression;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.expr.sort.SortKeyDefinitionList;
import net.sf.saxon.functions.Doc;
import net.sf.saxon.functions.DocumentFn;
import net.sf.saxon.functions.KeyFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.registry.VendorFunctionSetHE;
import net.sf.saxon.functions.registry.XSLT30FunctionSet;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.ma.map.DictionaryMap;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.MapFunctionSet;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.IntersectPattern;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeSetPattern;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternThatSetsCurrent;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.style.XSLFunction;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.trans.FunctionStreamability;
import net.sf.saxon.trans.GlobalVariableManager;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.SimpleMode;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.VisibilityProvenance;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.Rule;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.NumericType;
import net.sf.saxon.type.PlainType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;

public class OptimizerEE
extends Optimizer {
    public OptimizerEE(Configuration config) {
        super(config);
    }

    @Override
    public Expression optimizeGeneralComparison(ExpressionVisitor visitor, GeneralComparison gc, boolean backwardsCompatible, ContextItemStaticInfo contextItemType) {
        if (gc instanceof GeneralComparisonEE) {
            return gc;
        }
        if (!"EE".equals(visitor.getTargetEdition())) {
            return gc;
        }
        if (gc.getOperator() == 6) {
            Expression p0 = gc.getLhsExpression();
            Expression p1 = gc.getRhsExpression();
            boolean many0 = Cardinality.expectsMany(p0);
            boolean many1 = Cardinality.expectsMany(p1);
            if (many0 || many1) {
                Expression mapTest;
                if ((gc.getAtomicComparer().getCollator() == null || gc.getAtomicComparer().getCollator() == CodepointCollator.getInstance()) && (p1 instanceof Literal && ((Literal)p1).getValue().getLength() > 8 ? (mapTest = this.makeMapTest(visitor, p0, (Literal)p1, contextItemType)) != null : p0 instanceof Literal && ((Literal)p0).getValue().getLength() > 8 && (mapTest = this.makeMapTest(visitor, p1, (Literal)p0, contextItemType)) != null)) {
                    return mapTest;
                }
                GeneralComparisonEE gcee = new GeneralComparisonEE(p0, gc.getOperator(), p1);
                gcee.setRetainedStaticContext(gc.getRetainedStaticContext());
                gcee.setAtomicComparer(gc.getAtomicComparer());
                gcee.setComparisonCardinality(gc.getComparisonCardinality());
                gcee.setNeedsRuntimeCheck(gc.needsRuntimeCheck());
                return gcee;
            }
        }
        return gc;
    }

    private Expression makeMapTest(ExpressionVisitor visitor, Expression exp, Literal literal, ContextItemStaticInfo contextInfo) {
        try {
            Expression e2;
            MapItem map;
            boolean allStrings = true;
            for (Object item : literal.getValue()) {
                if (item instanceof StringValue) continue;
                allStrings = false;
                break;
            }
            if (allStrings) {
                DictionaryMap dict = new DictionaryMap();
                for (Item item : literal.getValue()) {
                    dict.initialPut(item.getStringValue(), BooleanValue.TRUE);
                }
                map = dict;
            } else {
                HashTrieMap trie = new HashTrieMap();
                for (Item item : literal.getValue()) {
                    if (item instanceof AtomicValue) {
                        if (item instanceof CalendarValue && !((CalendarValue)item).hasTimezone()) {
                            return null;
                        }
                        if (((AtomicValue)item).isNaN()) {
                            return null;
                        }
                        if (item instanceof UntypedAtomicValue) {
                            return null;
                        }
                        trie.initialPut((AtomicValue)item, BooleanValue.TRUE);
                        continue;
                    }
                    return null;
                }
                map = trie;
            }
            TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
            SystemFunction containsFn = allStrings || th.relationship(exp.getItemType(), BuiltInAtomicType.UNTYPED_ATOMIC) == 4 ? MapFunctionSet.getInstance().makeFunction("contains", 2) : VendorFunctionSetHE.getInstance().makeFunction("map-untyped-contains", 2);
            if (exp.getCardinality() == 16384) {
                e2 = containsFn.makeFunctionCall(Literal.makeLiteral(map, exp), exp);
            } else {
                Expression contains = containsFn.makeFunctionCall(Literal.makeLiteral(map, exp), new ContextItemExpression());
                FilterExpression fe = new FilterExpression(exp, contains);
                e2 = SystemFunction.makeCall("exists", exp.getRetainedStaticContext(), fe);
            }
            assert (e2 != null);
            e2.setRetainedStaticContext(exp.getRetainedStaticContext());
            e2 = e2.typeCheck(visitor, contextInfo);
            e2 = e2.optimize(visitor, contextInfo);
            return e2;
        }
        catch (XPathException e) {
            return null;
        }
    }

    @Override
    public Expression optimizeSaxonStreamFunction(ExpressionVisitor visitor, ContextItemStaticInfo cisi, Expression select) throws XPathException {
        Expression e = super.optimizeSaxonStreamFunction(visitor, cisi, select);
        if (e != null) {
            return e;
        }
        if (!this.config.getBooleanProperty(Feature.ALLOW_MULTITHREADING)) {
            this.streamingNotPossible("Cannot use saxon:stream(): multithreading is not enabled", select, visitor);
            return null;
        }
        if (!(select instanceof SlashExpression)) {
            if (select instanceof DocumentSorter) {
                this.streamingNotPossible("Cannot use saxon:stream(): expression is not provably in document order", select, visitor);
            } else {
                this.streamingNotPossible("Cannot use saxon:stream(): not a path expression", select, visitor);
            }
            return null;
        }
        SlashExpression pexp = (SlashExpression)select;
        Expression start = pexp.getFirstStep();
        if (!start.isCallOn(Doc.class) && !start.isCallOn(DocumentFn.class) || ((SystemFunctionCall)start).getArity() != 1) {
            this.streamingNotPossible("Cannot use saxon:stream(): path must start with call on doc#1 or document#1", select, visitor);
            return null;
        }
        SystemFunctionCall documentExp = (SystemFunctionCall)start;
        Expression rest = pexp.getRemainingSteps();
        Expression snap = SystemFunction.makeCall("snapshot", select.getRetainedStaticContext(), rest);
        Set accList = Collections.emptySet();
        ParseOptions options = new ParseOptions(this.config.getParseOptions());
        options.setSchemaValidationMode(4);
        options.setTopLevelType(null);
        options.setApplicableAccumulators(accList);
        StreamInstr stream = new StreamInstr(new ContextItemExpression(), snap, options);
        this.trace("Using streaming for saxon:stream", stream);
        ForEach each = new ForEach(documentExp.getArg(0), stream);
        return each.optimize(visitor, cisi);
    }

    private void streamingNotPossible(String reason, Expression select, ExpressionVisitor visitor) {
        this.trace(reason, select);
        visitor.issueWarning(reason, select.getLocation());
    }

    @Override
    public void makeCopyOperationsExplicit(Expression parent, Operand childOp) {
        Expression child = childOp.getChildExpression();
        boolean atomic = child.getItemType() instanceof AtomicType || child.getItemType() instanceof FunctionItemType;
        boolean replace = false;
        if (child instanceof ContextItemExpression) {
            replace = true;
        }
        if (!atomic && child.hasSpecialProperty(0x100000)) {
            replace = true;
        }
        if (child instanceof OnEmptyExpr || child instanceof OnNonEmptyExpr) {
            replace = false;
        }
        if (replace) {
            CopyOf copy = new CopyOf(child, true, 3, null, false);
            childOp.setChildExpression(copy);
            return;
        }
        if (child instanceof SimpleStepExpression) {
            return;
        }
        if (child instanceof Fork) {
            return;
        }
        for (Operand action : child.operands()) {
            if (action.getOperandRole().getUsage() != OperandUsage.TRANSMISSION) continue;
            this.makeCopyOperationsExplicit(child, action);
        }
    }

    @Override
    public void checkStreamability(XSLTemplate sourceTemplate, TemplateRule compiledTemplate) throws XPathException {
        if (compiledTemplate.isDeclaredStreamable()) {
            boolean actuallyStreamable;
            ArrayList<String> reasons = new ArrayList<String>();
            int streamabilityRules = this.getConfiguration().getStreamability();
            if (streamabilityRules == 0) {
                reasons.add("Streaming is disabled for this Saxon Configuration");
                actuallyStreamable = false;
            } else {
                actuallyStreamable = ((TemplateRuleEE)compiledTemplate).isActuallyStreamable(reasons);
            }
            if (!actuallyStreamable) {
                boolean fallback = this.getConfiguration().getBooleanProperty(Feature.STREAMING_FALLBACK);
                StringBuilder message = new StringBuilder("Template rule is declared streamable but it does not satisfy the streamability rules. ");
                for (String reason : reasons) {
                    message.append("\n  * ").append(reason);
                }
                XPathException err = new XPathException(message.toString());
                err.setErrorCode("XTSE3430");
                err.setLocator(sourceTemplate);
                if (fallback) {
                    message.append("\n  * Falling back to non-streaming implementation");
                    sourceTemplate.getStaticContext().issueWarning(message.toString(), sourceTemplate);
                    compiledTemplate.setDeclaredStreamable(false);
                } else {
                    throw err;
                }
            }
        }
    }

    @Override
    public Expression optimizeForExpressionForStreaming(ForExpression expr) {
        Expression e2 = Streamability.rewriteForExpressionAsMappingExpression(expr);
        if (e2 != null) {
            return e2;
        }
        return expr;
    }

    @Override
    public Expression optimizeQuantifiedExpressionForStreaming(QuantifiedExpression expr) throws XPathException {
        Expression rewrite = Streamability.rewriteQuantifiedExpressionAsFilterExpression(expr);
        if (rewrite != null) {
            return rewrite;
        }
        return null;
    }

    private static Expression promoteUnion(SlashExpression path) {
        Expression start = path.getFirstStep();
        Expression rest = path.getRemainingSteps();
        if (rest instanceof SlashExpression) {
            rest = OptimizerEE.promoteUnion((SlashExpression)rest);
        }
        ArrayList<Expression> operands = new ArrayList<Expression>(3);
        OptimizerEE.gatherUnionOperands(rest, operands);
        if (operands.size() < 2) {
            return path;
        }
        Expression p = ExpressionTool.makePathExpression(start, (Expression)operands.get(0));
        for (int i = 1; i < operands.size(); ++i) {
            p = new VennExpression(p, 1, ExpressionTool.makePathExpression(start.copy(new RebindingMap()), (Expression)operands.get(i)));
        }
        return p;
    }

    private static void gatherUnionOperands(Expression exp, List<Expression> list) {
        if (exp instanceof VennExpression && ((VennExpression)exp).getOperator() == 1) {
            VennExpression ve = (VennExpression)exp;
            OptimizerEE.gatherUnionOperands(ve.getLhsExpression(), list);
            OptimizerEE.gatherUnionOperands(ve.getRhsExpression(), list);
        } else {
            list.add(exp);
        }
    }

    @Override
    public Expression convertPathExpressionToKey(SlashExpression pathExp, ExpressionVisitor visitor) {
        if (!this.isOptionSet(32)) {
            return null;
        }
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        Expression copy = pathExp.copy(new RebindingMap());
        if (!(copy instanceof SlashExpression)) {
            return null;
        }
        SlashExpression p = ((SlashExpression)copy).tryToMakeAbsolute();
        if (p != null) {
            Expression match = p.getRemainingSteps();
            FilterExpression f = null;
            if (match instanceof FilterExpression) {
                f = (FilterExpression)match;
                if (f.getFilter() instanceof BooleanExpression) {
                    f = this.expandComplexFilter(f.getSelectExpression(), f.getFilter());
                }
            } else if (match instanceof SlashExpression) {
                f = this.convertToFilterExpression((SlashExpression)match, th);
            }
            if (f != null) {
                return this.convertFilterExpressionToKey(f, visitor, p.getFirstStep());
            }
        }
        return null;
    }

    @Override
    public Expression tryIndexedFilter(FilterExpression f, ExpressionVisitor visitor, boolean indexFirstOperand, boolean contextIsDoc) {
        if ("EE".equals(visitor.getTargetEdition())) {
            if (!Cardinality.allowsMany(f.getLhsExpression().getCardinality())) {
                return f;
            }
            Expression k = this.tryToConvertFilterExpressionToKey(f, visitor, contextIsDoc);
            if (k != null) {
                return k;
            }
            f.restoreParentPointers();
            if (f.getSelectExpression() instanceof VariableReference) {
                VariableReference varRef = (VariableReference)f.getSelectExpression();
                Binding binding = varRef.getBinding();
                if (binding instanceof LocalBinding && ExpressionTool.isLoopingReference(varRef, binding)) {
                    ((LocalBinding)binding).setIndexedVariable();
                    IndexedFilterExpression ife = new IndexedFilterExpression(varRef, (ComparisonExpression)((Object)f.getFilter()), indexFirstOperand);
                    this.trace("Created indexed filter expression: ", ife);
                    return ife;
                }
                if (binding instanceof GlobalVariable && !(binding instanceof GlobalParam)) {
                    ((GlobalVariable)binding).setIndexedVariable();
                    return new IndexedFilterExpression((VariableReference)f.getSelectExpression(), (ComparisonExpression)((Object)f.getFilter()), indexFirstOperand);
                }
            }
        } else {
            return f;
        }
        return f;
    }

    @Override
    public Expression reorderPredicates(FilterExpression f, ExpressionVisitor visitor, ContextItemStaticInfo cisi) throws XPathException {
        Expression base = ((FilterExpression)f.getLhsExpression()).getLhsExpression();
        Expression predicate1 = ((FilterExpression)f.getLhsExpression()).getRhsExpression();
        Expression predicate2 = f.getRhsExpression();
        if (predicate1.getCost() > 2.0 * predicate2.getCost()) {
            FilterExpression fe1 = new FilterExpression(base, predicate2);
            FilterExpression fe2 = new FilterExpression(fe1, predicate1);
            ExpressionTool.copyLocationInfo(f, fe2);
            if (this.tracing) {
                this.trace("Reordered predicates in filter expression", fe2);
            }
            return fe2.optimize(visitor, cisi);
        }
        return f;
    }

    private Expression tryToConvertFilterExpressionToKey(FilterExpression f, ExpressionVisitor visitor, boolean contextIsDoc) {
        Expression base = f.getSelectExpression();
        while (!(base instanceof SlashExpression)) {
            if (base instanceof AxisExpression) {
                if (!contextIsDoc) break;
                base = new SlashExpression(new RootExpression(), base);
                ExpressionTool.copyLocationInfo(f, base);
                break;
            }
            if (base instanceof VariableReference) {
                Binding b = ((VariableReference)base).getBinding();
                if (b instanceof LetExpression) {
                    base = ((LetExpression)b).getSequence().copy(new RebindingMap());
                    continue;
                }
                return null;
            }
            if (base instanceof DocumentSorter) {
                base = ((DocumentSorter)base).getBaseExpression();
                continue;
            }
            if (base instanceof FilterExpression) {
                FilterExpression baseF = (FilterExpression)base;
                if (!baseF.isFilterIsPositional() && this.isIndexableFilter(baseF.getFilter()) == 0) {
                    Expression baseFB = baseF.getSelectExpression();
                    Expression baseFF = baseF.getFilter();
                    RebindingMap rm = new RebindingMap();
                    FilterExpression fe2 = new FilterExpression(baseFB.copy(rm), f.getFilter().copy(rm));
                    FilterExpression fe3 = new FilterExpression(fe2, baseFF);
                    return this.tryToConvertFilterExpressionToKey(fe3, visitor, contextIsDoc);
                }
                return null;
            }
            return null;
        }
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        if (base instanceof SlashExpression) {
            SlashExpression path = (SlashExpression)base;
            SlashExpression p = path.tryToMakeAbsolute();
            if (p == null) {
                return null;
            }
            Expression doc = p.getFirstStep();
            if (!th.isSubType(doc.getItemType(), NodeKindTest.DOCUMENT)) {
                return null;
            }
            return this.convertFilterExpressionToKey(f, visitor, doc);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Expression convertFilterExpressionToKey(FilterExpression f, ExpressionVisitor visitor, Expression doc) {
        Expression call;
        StructuredQName keyName;
        KeyDefinitionSet keySet;
        KeyManager keyManager;
        boolean convertUntypedToOther;
        Expression value;
        if (!this.isOptionSet(32)) {
            return null;
        }
        if (f.getFilter() instanceof BooleanExpression) {
            f = this.expandComplexFilter(f.getSelectExpression(), f.getFilter());
        }
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        RetainedStaticContext rsc = f.getRetainedStaticContext();
        int indexableFlag = this.isIndexableFilter(f.getFilter());
        if (indexableFlag == 0) {
            if (f.isPositional(th)) {
                return null;
            }
            return this.tryConvertingInnerPredicate(f, visitor, doc);
        }
        boolean indexFirstOperand = indexableFlag > 0;
        Expression path = f.getSelectExpression().copy(new RebindingMap());
        if ((path.getDependencies() & 0xFFFFF3ED) != 0) {
            return this.tryConvertingInnerPredicate(f, visitor, doc);
        }
        if (path instanceof SlashExpression && !(doc instanceof RootExpression) && (doc.getDependencies() & 0x1E) != 0) {
            path = new SlashExpression(new RootExpression(), path);
        }
        ComparisonExpression fc = (ComparisonExpression)((Object)f.getFilter().copy(new RebindingMap()));
        Expression use = indexFirstOperand ? fc.getLhsExpression() : fc.getRhsExpression();
        Expression expression = value = indexFirstOperand ? fc.getRhsExpression() : fc.getLhsExpression();
        if ((use.getDependencies() & 0xFFFFF3FD) != 0) {
            return null;
        }
        int props = path.getSpecialProperties();
        if ((props & 0x800000) == 0 || (props & 0x1000000) == 0) {
            return null;
        }
        if ((props & 0x20000) == 0) {
            DocumentSorter sorter = new DocumentSorter(path);
            ExpressionTool.copyLocationInfo(path, sorter);
            path = sorter;
        }
        NodeSetPattern pathFinder = new NodeSetPattern(path);
        ItemType useType = use.getItemType();
        if (!useType.isPlainType()) {
            try {
                use = Atomizer.makeAtomizer(use, null).simplify();
            }
            catch (XPathException e) {
                return null;
            }
            ExpressionTool.copyLocationInfo(f, use);
            useType = use.getItemType();
            if (((AtomicType)useType).isExternalType()) {
                return null;
            }
        }
        if (convertUntypedToOther = fc.convertsUntypedToOther()) {
            PlainType valueType = value.getItemType().getAtomizedItemType();
            if (!useType.equals(BuiltInAtomicType.ANY_ATOMIC) || !valueType.equals(BuiltInAtomicType.ANY_ATOMIC)) {
                AtomicType targetType;
                if (!(!useType.equals(BuiltInAtomicType.ANY_ATOMIC) && !useType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || valueType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || th.isSubType(valueType, BuiltInAtomicType.STRING) || th.isSubType(valueType, BuiltInAtomicType.ANY_ATOMIC))) {
                    targetType = (AtomicType)valueType;
                    if (th.isSubType(targetType, NumericType.getInstance())) {
                        targetType = BuiltInAtomicType.DOUBLE;
                    }
                    use = new AtomicSequenceConverter(use, targetType);
                    ((AtomicSequenceConverter)use).allocateConverterStatically(this.config, false);
                } else if (!(!valueType.equals(BuiltInAtomicType.ANY_ATOMIC) && !valueType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || useType.equals(BuiltInAtomicType.UNTYPED_ATOMIC) || th.isSubType(useType, BuiltInAtomicType.STRING) || th.isSubType(valueType, BuiltInAtomicType.ANY_ATOMIC))) {
                    targetType = (AtomicType)valueType;
                    if (th.isSubType(targetType, NumericType.getInstance())) {
                        targetType = BuiltInAtomicType.DOUBLE;
                    }
                    value = new AtomicSequenceConverter(value, targetType);
                    ((AtomicSequenceConverter)value).allocateConverterStatically(this.config, false);
                }
            }
        }
        StaticContext env = visitor.getStaticContext();
        String defaultCollationName = env.getDefaultCollationName();
        KeyManager keyManager2 = keyManager = env.getKeyManager();
        synchronized (keyManager2) {
            keySet = keyManager.findKeyDefinition(pathFinder, use, defaultCollationName);
            if (keySet == null) {
                StringCollator collator;
                Configuration config = this.getConfiguration();
                SlotManager slotManager = config.makeSlotManager();
                int slots = ExpressionTool.allocateSlots(pathFinder.getSelectionExpression(), 0, slotManager);
                ExpressionTool.allocateSlots(use, slots, slotManager);
                try {
                    collator = config.getCollation(defaultCollationName);
                }
                catch (XPathException e) {
                    return null;
                }
                keyName = new StructuredQName("saxon", "http://saxon.sf.net/", "kk" + (100 + keyManager.getNumberOfKeyDefinitions()));
                SymbolicName symbolicName = new SymbolicName(165, keyName);
                KeyDefinition key = new KeyDefinition(symbolicName, pathFinder, use, defaultCollationName, collator);
                key.setPackageData(f.getPackageData());
                key.setIndexedItemType((BuiltInAtomicType)useType.getPrimitiveItemType());
                key.setConvertUntypedToOther(convertUntypedToOther);
                key.setStackFrameMap(slotManager);
                if (f.getFilter() instanceof ValueComparison) {
                    key.setStrictComparison(true);
                }
                try {
                    keyManager.addKeyDefinition(keyName, key, true, this.getConfiguration());
                }
                catch (XPathException err) {
                    throw new AssertionError((Object)err);
                }
                keySet = keyManager.getKeyDefinitionSet(keyName);
            } else {
                keyName = keySet.getKeyName();
            }
        }
        if (doc.getCardinality() != 16384) {
            ForExpression forExp = new ForExpression();
            forExp.setRequiredType(SequenceType.makeSequenceType(doc.getItemType(), doc.getCardinality()));
            forExp.setVariableQName(new StructuredQName("vv", "http://saxon.sf.net/generated-variable", "dd" + forExp.hashCode()));
            Expression docs = doc;
            if (!docs.hasSpecialProperty(131072)) {
                docs = new DocumentSorter(docs);
            }
            forExp.setSequence(docs);
            LocalVariableReference docVar = new LocalVariableReference(forExp);
            call = KeyFn.internalKeyCall(keyManager, keySet, keyName.getEQName(), value, docVar, rsc);
            forExp.setAction(call);
            call = forExp;
        } else {
            call = KeyFn.internalKeyCall(keyManager, keySet, keyName.getEQName(), value, doc, rsc);
        }
        ExpressionTool.copyLocationInfo(f, call);
        this.trace("Replaced filter expression with call to key function: ", call);
        return call;
    }

    private Expression tryConvertingInnerPredicate(FilterExpression f, ExpressionVisitor visitor, Expression doc) {
        Expression base = f.getSelectExpression();
        if (base instanceof FilterExpression) {
            Expression pred = f.getFilter();
            Expression k = this.convertFilterExpressionToKey((FilterExpression)base, visitor, doc);
            if (k != null) {
                FilterExpression kf = new FilterExpression(k, pred);
                ExpressionTool.copyLocationInfo(f, kf);
                return kf;
            }
            return null;
        }
        return null;
    }

    @Override
    public FilterExpression convertToFilterExpression(SlashExpression pathExp, TypeHierarchy th) {
        Expression head = pathExp.getFirstStep();
        Expression tail = pathExp.getRemainingSteps();
        ArrayList<Expression> path = new ArrayList<Expression>(3);
        path.add(head);
        while (tail instanceof SlashExpression) {
            head = ((SlashExpression)tail).getFirstStep();
            path.add(head);
            tail = ((SlashExpression)tail).getRemainingSteps();
        }
        if (tail instanceof FilterExpression && !((FilterExpression)tail).isPositional(th)) {
            FilterExpression e;
            Expression predicate = ((FilterExpression)tail).getFilter();
            Expression last = ((FilterExpression)tail).getSelectExpression();
            boolean repeat = last instanceof FilterExpression;
            for (int i = path.size() - 1; i >= 0; --i) {
                last = ExpressionTool.makePathExpression((Expression)path.get(i), last);
                ExpressionTool.copyLocationInfo(pathExp, last);
            }
            if (last instanceof SlashExpression && repeat && (e = this.convertToFilterExpression((SlashExpression)last, th)) != null) {
                last = e;
            }
            if (predicate instanceof BooleanExpression) {
                return this.expandComplexFilter(last, predicate);
            }
            FilterExpression fe = new FilterExpression(last, predicate);
            ExpressionTool.copyLocationInfo(pathExp, fe);
            this.trace("Moved predicate to outer level of path expression: ", fe);
            return fe;
        }
        return null;
    }

    private FilterExpression expandComplexFilter(Expression base, Expression predicate) {
        ArrayList<Expression> list = new ArrayList<Expression>(4);
        BooleanExpression.listAndComponents(predicate, list);
        for (Expression exp : list) {
            FilterExpression fe = new FilterExpression(base, exp);
            ExpressionTool.copyLocationInfo(base, fe);
            base = fe;
        }
        this.trace("Split composite predicate into multiple predicates: ", base);
        return (FilterExpression)base;
    }

    @Override
    public int isIndexableFilter(Expression filter) {
        if (filter instanceof ComparisonExpression && ((ComparisonExpression)((Object)filter)).getSingletonOperator() == 50) {
            return OptimizerEE.isIndexableComparison((ComparisonExpression)((Object)filter));
        }
        return 0;
    }

    private static int isIndexableComparison(ComparisonExpression filter) {
        boolean d1v;
        if (filter instanceof GeneralComparison10) {
            return 0;
        }
        Expression op0 = filter.getLhsExpression();
        Expression op1 = filter.getRhsExpression();
        boolean d0f = ExpressionTool.dependsOnFocus(op0);
        boolean d0v = (op0.getDependencies() & 0x80) != 0;
        boolean d1f = ExpressionTool.dependsOnFocus(op1);
        boolean bl = d1v = (op1.getDependencies() & 0x80) != 0;
        if (d0f && !d1f && !d0v) {
            return 1;
        }
        if (d1f && !d0f && !d1v) {
            return -1;
        }
        return 0;
    }

    @Override
    public <T extends Item<?>> GroundedValue<T> makeIndexedValue(SequenceIterator<? extends T> iter) throws XPathException {
        return SearchableValue.makeSearchableValue(iter);
    }

    @Override
    public void prepareForStreaming(Expression exp) throws XPathException {
        ExpressionTool.processExpressionTree(exp, new Object(), (expr, obj) -> {
            expr.prepareForStreaming();
            return false;
        });
    }

    @Override
    public Sequence<?> evaluateStreamingArgument(Expression expr, XPathContext context) throws XPathException {
        PostureAndSweep ps = Streamability.getPostureAndSweepIfKnown(expr);
        if (ps == null) {
            return super.evaluateStreamingArgument(expr, context);
        }
        if (ps.getPosture() == Posture.GROUNDED) {
            return ExpressionTool.eagerEvaluate(expr, context);
        }
        return EmptySequence.getInstance();
    }

    @Override
    public Expression makeConditionalDocumentSorter(DocumentSorter sorter, SlashExpression path) {
        Expression head;
        Expression h2 = head = path.getFirstStep();
        if (head instanceof ItemChecker && ((ItemChecker)head).getRequiredType() instanceof NodeTest) {
            h2 = ((ItemChecker)head).getBaseExpression();
        }
        Expression steps = path.getRemainingSteps();
        int stepProps = steps.getSpecialProperties();
        if (!Cardinality.allowsMany(h2.getCardinality()) && (stepProps & 0x20000) != 0) {
            return path;
        }
        if (h2 instanceof VariableReference && (stepProps & 0x20000) != 0) {
            Expression ref = head.copy(new RebindingMap());
            TailExpression tailExp = new TailExpression(ref, 2);
            Expression exists = SystemFunction.makeCall("exists", sorter.getRetainedStaticContext(), tailExp);
            return new ConditionalSorter(exists, sorter);
        }
        return sorter;
    }

    @Override
    public Expression tryInlineFunctionCall(UserFunctionCall functionCall, ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) {
        boolean isInlineable;
        if (!this.isOptionSet(8)) {
            return functionCall;
        }
        if (functionCall.isBeingInlined()) {
            return functionCall;
        }
        UserFunction function = functionCall.getFunction();
        Boolean b = function.isInlineable();
        if (function.getDeclaredStreamability() != FunctionStreamability.UNCLASSIFIED) {
            isInlineable = false;
        } else if (b == null) {
            if (function.getBody() == null) {
                return functionCall;
            }
            ArrayList<UserFunction> calledFunctions = new ArrayList<UserFunction>(10);
            ExpressionTool.gatherCalledFunctions(function.getBody(), calledFunctions);
            isInlineable = calledFunctions.isEmpty() && !ExpressionTool.changesXsltContext(function.getBody()) && ExpressionTool.expressionSize(function.getBody()) <= this.config.getConfigurationProperty(Feature.THRESHOLD_FOR_FUNCTION_INLINING) && !function.isMemoFunction() && !ExpressionTool.dependsOnFocus(function.getBody()) && functionCall.getRetainedStaticContext().getPackageData() == function.getPackageData();
            function.setInlineable(isInlineable);
        } else {
            isInlineable = b;
        }
        if (isInlineable) {
            functionCall.setBeingInlined(true);
            function.markAsInlined();
            Expression newBody = function.getBody().copy(new RebindingMap());
            newBody.setRetainedStaticContext(function.getRetainedStaticContext());
            UserFunctionParameter[] params = function.getParameterDefinitions();
            for (int p = params.length - 1; p >= 0; --p) {
                UserFunctionParameter param = params[p];
                LetExpression let = new LetExpression();
                let.setRequiredType(param.getRequiredType());
                let.setVariableQName(param.getVariableQName());
                let.setSequence(functionCall.getArg(p).copy(new RebindingMap()));
                let.setAction(newBody);
                let.setRetainedStaticContext(function.getRetainedStaticContext());
                ExpressionTool.rebindVariableReferences(newBody, param, let);
                newBody = let;
            }
            try {
                StructuredQName fName = function.getFunctionName();
                this.trace("Moved function " + (fName == null ? "(anonymous)" : fName.getDisplayName()) + " inline: ", newBody);
                newBody = newBody.simplify();
                boolean saveSuppressed = visitor.isSuppressWarnings();
                visitor.setSuppressWarnings(true);
                newBody = newBody.typeCheck(visitor, contextItemType);
                newBody = ExpressionTool.optimizeComponentBody(newBody, null, visitor, contextItemType, true);
                if (function.getDeterminism() != UserFunction.Determinism.PROACTIVE) {
                    newBody.setStaticProperty(0x800000);
                }
                visitor.setSuppressWarnings(saveSuppressed);
                functionCall.setBeingInlined(false);
                return newBody;
            }
            catch (XPathException e) {
                return functionCall;
            }
        }
        return functionCall;
    }

    @Override
    public Expression trySwitch(Choose choose, ExpressionVisitor visitor) {
        if (!"EE".equals(visitor.getTargetEdition()) || !this.isOptionSet(512)) {
            return choose;
        }
        if (choose.getNumberOfConditions() < 4) {
            return choose;
        }
        SwitchExpression.SwitchCaseInfo switchCaseInfo = new SwitchExpression.SwitchCaseInfo();
        switchCaseInfo.commonlhs = null;
        switchCaseInfo.commontype = null;
        switchCaseInfo.index = new HashMap(choose.getNumberOfConditions());
        String defaultCollation = choose.getRetainedStaticContext().getDefaultCollationName();
        try {
            switchCaseInfo.collation = this.getConfiguration().getCollation(defaultCollation);
        }
        catch (XPathException e) {
            return choose;
        }
        switchCaseInfo.defaultAction = Literal.makeEmptySequence();
        int size = choose.getNumberOfConditions();
        for (int c = 0; c < size; ++c) {
            boolean isOtherwise;
            Expression condition = choose.getCondition(c);
            boolean bl = isOtherwise = c == size - 1 && Literal.hasEffectiveBooleanValue(condition, true);
            if (isOtherwise) {
                switchCaseInfo.defaultAction = choose.getAction(c);
                continue;
            }
            if (!defaultCollation.equals(condition.getRetainedStaticContext().getDefaultCollationName())) {
                return choose;
            }
            if (this.processSwitchCondition(condition, choose.getAction(c), switchCaseInfo)) continue;
            return choose;
        }
        if (!switchCaseInfo.makeIndex()) {
            return null;
        }
        return new SwitchExpression(switchCaseInfo);
    }

    private boolean processSwitchCondition(Expression condition, Expression action, SwitchExpression.SwitchCaseInfo switchCaseInfo) {
        AtomicValue value;
        if (condition instanceof OrExpression) {
            boolean b = this.processSwitchCondition(((OrExpression)condition).getLhsExpression(), action, switchCaseInfo);
            return b && this.processSwitchCondition(((OrExpression)condition).getRhsExpression(), action, switchCaseInfo);
        }
        if (!(condition instanceof ComparisonExpression)) {
            return false;
        }
        if (condition instanceof GeneralComparison) {
            return false;
        }
        if (((ComparisonExpression)((Object)condition)).getSingletonOperator() != 50) {
            return false;
        }
        Expression lhs = ((ComparisonExpression)((Object)condition)).getLhsExpression();
        Expression rhs = ((ComparisonExpression)((Object)condition)).getRhsExpression();
        if (!Literal.isAtomic(rhs)) {
            return false;
        }
        if (switchCaseInfo.commonlhs == null) {
            switchCaseInfo.commonlhs = lhs;
            switchCaseInfo.commontype = (BuiltInAtomicType)rhs.getItemType().getPrimitiveItemType();
            if (!switchCaseInfo.commontype.isOrdered(false)) {
                return false;
            }
        } else {
            if (!switchCaseInfo.commonlhs.isEqual(lhs)) {
                return false;
            }
            if (!switchCaseInfo.commontype.equals(rhs.getItemType().getPrimitiveItemType())) {
                return false;
            }
        }
        if ((value = (AtomicValue)((Literal)rhs).getValue()) instanceof CalendarValue) {
            return false;
        }
        switchCaseInfo.values.add(value);
        switchCaseInfo.actions.add(action);
        return true;
    }

    public int gatherOrExpressions(int commonParts, ExpressionVisitor visitor, ContextItemStaticInfo contextItemType, HashMap<Expression, List<Expression>> map, List<Expression> otherExps, Expression expr) {
        if (expr instanceof OrExpression) {
            OrExpression orExpr = (OrExpression)expr;
            commonParts = this.gatherOrExpressions(commonParts, visitor, contextItemType, map, otherExps, orExpr.getLhsExpression());
            commonParts = this.gatherOrExpressions(commonParts, visitor, contextItemType, map, otherExps, orExpr.getRhsExpression());
            return commonParts;
        }
        if (expr instanceof ComparisonExpression) {
            int op;
            ComparisonExpression compExpr = (ComparisonExpression)((Object)expr);
            if (compExpr instanceof BinaryExpression) {
                BinaryExpression exprBin = (BinaryExpression)expr;
                op = exprBin.getOperator();
            } else if (compExpr instanceof CompareToIntegerConstant) {
                CompareToIntegerConstant intConst = (CompareToIntegerConstant)expr;
                op = intConst.getSingletonOperator();
            } else {
                otherExps.add(expr);
                return commonParts;
            }
            Expression left = compExpr.getLhsExpression();
            Expression right = compExpr.getRhsExpression();
            if (!compExpr.convertsUntypedToOther() && (left.getItemType().getUType().overlaps(UType.UNTYPED_ATOMIC) && !UType.STRING_LIKE.subsumes(right.getItemType().getUType()) || right.getItemType().getUType().overlaps(UType.UNTYPED_ATOMIC) && !UType.STRING_LIKE.subsumes(left.getItemType().getUType()))) {
                otherExps.add(expr);
                return commonParts;
            }
            if (op == 50 || op == 6) {
                TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
                commonParts = this.comparisonExprFixup(commonParts, map, otherExps, th, expr, left, right);
                return commonParts;
            }
        }
        otherExps.add(expr);
        return commonParts;
    }

    @Override
    public Expression tryGeneralComparison(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType, OrExpression orExpr) throws XPathException {
        int commonParts = 0;
        HashMap<Expression, List<Expression>> map = new HashMap<Expression, List<Expression>>();
        ArrayList<Expression> otherExp = new ArrayList<Expression>();
        if ((commonParts = this.gatherOrExpressions(commonParts, visitor, contextItemType, map, otherExp, orExpr)) <= 1) {
            return orExpr;
        }
        Expression newExpr = null;
        Expression previous = null;
        RetainedStaticContext nsResolver = orExpr.getRetainedStaticContext();
        for (Map.Entry<Expression, List<Expression>> entry : map.entrySet()) {
            Expression comparison = new GeneralComparison20(entry.getKey(), 6, Block.makeBlock(entry.getValue()));
            comparison.setRetainedStaticContext(nsResolver);
            Expression e = ((Expression)comparison).typeCheck(visitor, contextItemType);
            if (e != null) {
                comparison = e;
            }
            if (previous != null) {
                previous = newExpr = new OrExpression(previous, comparison);
                continue;
            }
            newExpr = previous = comparison;
        }
        previous = newExpr;
        for (Expression expri : otherExp) {
            if (previous != null) {
                previous = newExpr = new OrExpression(previous, expri);
                continue;
            }
            previous = expri;
        }
        if (newExpr != null) {
            if ((newExpr = newExpr.typeCheck(visitor, contextItemType).optimize(visitor, contextItemType)) instanceof GeneralComparison) {
                return this.optimizeGeneralComparison(visitor, (GeneralComparison)newExpr, false, contextItemType);
            }
            return newExpr;
        }
        return orExpr;
    }

    private int comparisonExprFixup(int commonParts, HashMap<Expression, List<Expression>> map, List<Expression> otherExp, TypeHierarchy th, Expression second, Expression left, Expression right) {
        boolean checkSecondExpr = second instanceof ValueComparison;
        boolean checkOperands = checkSecondExpr && (left.getSpecialProperties() & 0x4000000) == 0 && th.relationship(left.getItemType(), BuiltInAtomicType.UNTYPED_ATOMIC) != 4 && (th.relationship(right.getItemType(), BuiltInAtomicType.STRING) != 4 || th.relationship(right.getItemType(), BuiltInAtomicType.UNTYPED_ATOMIC) != 4);
        boolean bl = checkOperands = checkSecondExpr && (checkOperands || (right.getSpecialProperties() & 0x4000000) == 0 && th.relationship(right.getItemType(), BuiltInAtomicType.UNTYPED_ATOMIC) != 4 && (th.relationship(left.getItemType(), BuiltInAtomicType.STRING) != 4 || th.relationship(left.getItemType(), BuiltInAtomicType.UNTYPED_ATOMIC) != 4));
        if (checkOperands) {
            otherExp.add(second);
        } else if (!map.containsKey(left)) {
            ArrayList<Expression> valueList = new ArrayList<Expression>();
            valueList.add(right);
            map.put(left, valueList);
        } else {
            map.get(left).add(right);
            ++commonParts;
        }
        return commonParts;
    }

    @Override
    public Expression promoteExpressionsToGlobal(Expression expr, GlobalVariableManager globalVariableManager, ExpressionVisitor visitor) throws XPathException {
        if (this.isOptionSet(2)) {
            GlobalExtractor extractor = new GlobalExtractor(expr, globalVariableManager, visitor);
            return extractor.extractGlobals();
        }
        return null;
    }

    @Override
    public Expression eliminateCommonSubexpressions(Expression in) {
        if (this.isOptionSet(128)) {
            return new CommonSubexpressionPromoter(this).promoteCommonSubexpressions(in);
        }
        return in;
    }

    @Override
    public Expression generateMultithreadedInstruction(Expression instruction) {
        if (instruction instanceof ForEach && this.config.getBooleanProperty(Feature.ALLOW_MULTITHREADING)) {
            ForEach base = (ForEach)instruction;
            MultithreadedForEach result = new MultithreadedForEach(base.getSelectExpression(), base.getActionExpression(), false, base.getNumberOfThreadsExpression());
            result.setInstruction(base.isInstruction());
            return result;
        }
        return instruction;
    }

    @Override
    public Expression compileToByteCode(ICompilerService compilerService, Expression expr, String objectName, int evaluationMethods) {
        if (expr instanceof CompiledExpression || expr instanceof Literal || expr instanceof VariableReference) {
            return expr;
        }
        try {
            return ((CompilerService)compilerService).compileToByteCode(expr, objectName, evaluationMethods);
        }
        catch (CannotCompileException e) {
            return expr;
        }
    }

    @Override
    public Expression makeByteCodeCandidate(ExpressionOwner owner, Expression expr, String objectName, int requiredEvaluationModes) {
        if (!this.isOptionSet(64) || !this.config.getBooleanProperty(Feature.GENERATE_BYTE_CODE)) {
            return expr;
        }
        if (owner instanceof TemplateRule && ((TemplateRule)owner).isDeclaredStreamable()) {
            return expr;
        }
        if (expr instanceof CompiledExpression || expr instanceof Literal || expr instanceof VariableReference || expr instanceof ByteCodeCandidate) {
            return expr;
        }
        ByteCodeCandidate candidate = new ByteCodeCandidate(owner, expr, objectName, requiredEvaluationModes);
        candidate.setCountDown(this.config.getCountDown());
        if (this.config.getBooleanProperty(Feature.MONITOR_HOT_SPOT_BYTE_CODE)) {
            candidate.setByteCodeMonitor(((EnterpriseConfiguration)this.config).obtainByteCodeMonitor());
        }
        return candidate;
    }

    @Override
    public void injectByteCodeCandidates(Expression expression) {
        if (this.getOptimizerOptions().isSet(64) && this.config.getBooleanProperty(Feature.GENERATE_BYTE_CODE)) {
            Expression action;
            Object actionOp;
            Expression owner;
            if (expression instanceof FilterExpression) {
                owner = (BinaryExpression)expression;
                actionOp = ((BinaryExpression)owner).getRhs();
                action = ((Operand)actionOp).getChildExpression();
                ((BinaryExpression)owner).setRhsExpression(this.makeByteCodeCandidate((ExpressionOwner)actionOp, action, expression.getExpressionName(), 32));
            } else if (expression instanceof ForExpression) {
                owner = (ForExpression)expression;
                actionOp = ((Assignation)owner).getActionOp();
                action = ((Operand)actionOp).getChildExpression();
                ((Assignation)owner).setAction(this.makeByteCodeCandidate((ExpressionOwner)actionOp, action, expression.getExpressionName(), 0));
            } else if (expression instanceof TryCatch) {
                owner = (TryCatch)expression;
                actionOp = ((TryCatch)owner).getTryOperand();
                action = ((Operand)actionOp).getChildExpression();
                ((Operand)actionOp).setChildExpression(this.makeByteCodeCandidate((ExpressionOwner)actionOp, action, expression.getExpressionName(), 0));
            } else if (expression instanceof SortExpression) {
                SortKeyDefinitionList skdl = ((SortExpression)expression).getSortKeyDefinitionList();
                for (SortKeyDefinition skd : skdl) {
                    Operand sk = skd.getSortKeyOperand();
                    sk.setChildExpression(this.makeByteCodeCandidate(sk, sk.getChildExpression(), expression.getExpressionName(), 0));
                }
            } else if (expression instanceof StreamInstr) {
                return;
            }
            for (Operand o : expression.operands()) {
                this.injectByteCodeCandidates(o.getChildExpression());
            }
        }
    }

    @Override
    public Expression optimizeNumberInstruction(NumberInstruction ni, ContextItemStaticInfo contextInfo) {
        if (ni.getLevel() == 2 && ni.getSelect() instanceof ContextItemExpression) {
            Pattern count = ni.getCount();
            if (count == null) {
                if (contextInfo.getItemType() instanceof NameTest) {
                    count = new NodeTestPattern((NameTest)contextInfo.getItemType());
                } else {
                    return null;
                }
            }
            Pattern from = ni.getFrom();
            if (Pattern.patternContainsVariable(count) || Pattern.patternContainsVariable(from)) {
                return null;
            }
            if (count instanceof PatternThatSetsCurrent || from instanceof PatternThatSetsCurrent) {
                return null;
            }
            TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
            if (th.relationship(contextInfo.getItemType(), NodeKindTest.ATTRIBUTE) != 4) {
                return null;
            }
            if (th.relationship(contextInfo.getItemType(), NodeKindTest.NAMESPACE) != 4) {
                return null;
            }
            SlotManager slots = this.getConfiguration().makeSlotManager();
            StructuredQName valueName = new StructuredQName("", "", "value");
            slots.allocateSlotNumber(valueName);
            SuppliedParameterReference ref = new SuppliedParameterReference(0);
            ArithmeticExpression increment = new ArithmeticExpression(ref, 15, Literal.makeLiteral(Int64Value.PLUS_ONE, ni));
            increment.setCalculator(Calculator.INTEGER_INTEGER[0]);
            increment.setRetainedStaticContext(ni.getRetainedStaticContext());
            ExpressionTool.allocateSlots(increment, 1, slots);
            AccumulatorRule ruleTarget = new AccumulatorRule(increment, slots, false);
            Rule rule = new Rule(count, ruleTarget, 0, 0, 0.0, 0, 0);
            StructuredQName genName = new StructuredQName("anon", "http://ns.saxonica.com/anonymous-type", "n" + ni.hashCode());
            SimpleMode rules = new SimpleMode(genName);
            rules.addRule(count, rule);
            if (from != null) {
                ruleTarget = new AccumulatorRule(Literal.makeLiteral(Int64Value.ZERO, ni), slots, false);
                rule = new Rule(from, ruleTarget, 1, 0, 1.0, 0, 0);
                rules.addRule(from, rule);
                if (th.relationship(count.getItemType(), from.getItemType()) != 4) {
                    IntersectPattern both = new IntersectPattern(from, count);
                    ruleTarget = new AccumulatorRule(Literal.makeLiteral(Int64Value.PLUS_ONE, ni), slots, false);
                    rule = new Rule(both, ruleTarget, 2, 0, 2.0, 0, 0);
                    rules.addRule(both, rule);
                }
            }
            rules.allocateAllPatternSlots();
            try {
                rules.computeRankings(1);
            }
            catch (XPathException e) {
                return null;
            }
            Accumulator acc = new Accumulator();
            acc.setType(SequenceType.SINGLE_INTEGER);
            acc.setPreDescentRules(rules);
            acc.setAccumulatorName(genName);
            acc.setInitialValueExpression(Literal.makeLiteral(Int64Value.ZERO, ni));
            acc.setSlotManagerForInitialValueExpression(this.getConfiguration().makeSlotManager());
            acc.setUniversallyApplicable(true);
            StylesheetPackage pack = (StylesheetPackage)ni.getPackageData();
            AccumulatorRegistry registry = pack.getAccumulatorRegistry();
            registry.addAccumulator(acc);
            Component co = Component.makeComponent(acc, Visibility.PRIVATE, VisibilityProvenance.DEFAULTED, pack, pack);
            acc.setDeclaringComponent(co);
            try {
                SystemFunction fn = XSLT30FunctionSet.getInstance().makeFunction("accumulator-before", 1);
                fn.setRetainedStaticContext(ni.getRetainedStaticContext());
                Expression call = fn.makeFunctionCall(new StringLiteral(genName.getEQName()));
                CompareToIntegerConstant nonZero = new CompareToIntegerConstant(new ContextItemExpression(), 51, 0L);
                BinaryExpression result = new FilterExpression(call, nonZero);
                if (!(ni.getSelect() instanceof ContextItemExpression)) {
                    result = new SlashExpression(ni.getSelect(), result);
                }
                ExpressionTool.copyLocationInfo(ni, result);
                result.setRetainedStaticContext(ni.getRetainedStaticContext());
                this.trace("Replaced xsl:number instruction by accumulator", result);
                return result;
            }
            catch (XPathException e) {
                throw new AssertionError((Object)e);
            }
        }
        return null;
    }

    @Override
    public void assessFunctionStreamability(XSLFunction sourceFunction, UserFunction compiledFunction) {
        FunctionStreamability ability = compiledFunction.getDeclaredStreamability();
        if (ability == FunctionStreamability.UNCLASSIFIED) {
            return;
        }
        ArrayList<String> reasons = new ArrayList<String>();
        PostureAndSweep ps = Streamability.getStreamability(compiledFunction.getBody(), ContextItemStaticInfoEE.ABSENT, reasons);
        switch (ability) {
            case ABSORBING: {
                if (ps.getPosture() == Posture.ROAMING || ps.getSweep() == Sweep.FREE_RANGING) {
                    StringBuilder message = new StringBuilder("Function " + compiledFunction.getFunctionName().getDisplayName() + " is not streamable");
                    for (String reason : reasons) {
                        message.append(". ").append(reason);
                    }
                    this.unstreamableFunction(sourceFunction, compiledFunction, message.toString());
                } else if (ps.getPosture() != Posture.GROUNDED) {
                    String message = "A function with streamability=absorbing must return grounded items";
                    this.unstreamableFunction(sourceFunction, compiledFunction, message);
                }
                return;
            }
            case ASCENT: {
                if (Cardinality.allowsMany(compiledFunction.getArgumentType(0).getCardinality())) {
                    String message = "The first argument of a function with streamability=ascent must not accept a sequence of more than one item";
                    this.unstreamableFunction(sourceFunction, compiledFunction, message);
                } else if (ps.getPosture() != Posture.GROUNDED && ps.getPosture() != Posture.CLIMBING) {
                    String message = "A function with streamability=ascent must return either grounded items or nodes reachable via the ancestor-or-self axis";
                    this.unstreamableFunction(sourceFunction, compiledFunction, message);
                } else if (ps.getSweep() != Sweep.MOTIONLESS) {
                    String message = "A function with streamability=ascent must not consume the input stream";
                    this.unstreamableFunction(sourceFunction, compiledFunction, message);
                }
                return;
            }
            case FILTER: {
                if (Cardinality.allowsMany(compiledFunction.getArgumentType(0).getCardinality())) {
                    String message = "The first argument of a function with streamability=filter must not accept a sequence of more than one item";
                    this.unstreamableFunction(sourceFunction, compiledFunction, message);
                } else if (ps.getPosture() != Posture.STRIDING) {
                    String message = "A function with streamability=filter must return striding nodes";
                    this.unstreamableFunction(sourceFunction, compiledFunction, message);
                } else if (ps.getSweep() != Sweep.MOTIONLESS) {
                    String message = "A function with streamability=filter must not consume the input stream";
                    this.unstreamableFunction(sourceFunction, compiledFunction, message);
                }
                return;
            }
            case INSPECTION: {
                if (Cardinality.allowsMany(compiledFunction.getArgumentType(0).getCardinality())) {
                    String message = "The first argument of a function with streamability=inspection must not accept a sequence of more than one item";
                    this.unstreamableFunction(sourceFunction, compiledFunction, message);
                } else if (ps.getPosture() != Posture.GROUNDED) {
                    String message = "A function with streamability=inspection must not return streamed nodes";
                    this.unstreamableFunction(sourceFunction, compiledFunction, message);
                } else if (ps.getSweep() != Sweep.MOTIONLESS) {
                    String message = "A function with streamability=inspection must not consume the input stream";
                    this.unstreamableFunction(sourceFunction, compiledFunction, message);
                }
                return;
            }
            case SHALLOW_DESCENT: {
                if (Cardinality.allowsMany(compiledFunction.getArgumentType(0).getCardinality())) {
                    String message = "The first argument of a function with streamability=shallow-descent must not accept a sequence of more than one item";
                    this.unstreamableFunction(sourceFunction, compiledFunction, message);
                } else if (ps.getPosture() != Posture.STRIDING) {
                    String message = "A function with streamability=shallow-descent must be striding (that is, must return nodes reachable via the child or attribute axis)";
                    this.unstreamableFunction(sourceFunction, compiledFunction, message);
                } else if (ps.getSweep() == Sweep.FREE_RANGING) {
                    String message = "The function body is free-ranging";
                    this.unstreamableFunction(sourceFunction, compiledFunction, message);
                }
                return;
            }
        }
    }

    private void unstreamableFunction(XSLFunction fn, UserFunction compiledFunction, String message) {
        if (this.config.getBooleanProperty(Feature.STREAMING_FALLBACK)) {
            message = message + ". Falling back to unstreamed implementation";
            fn.compileWarning(message, "XTSE3430");
            compiledFunction.setDeclaredStreamability(FunctionStreamability.UNCLASSIFIED);
            fn.getCompilation().setFallbackToNonStreaming(true);
        } else {
            fn.compileError(message, "XTSE3430");
        }
    }
}

