/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.axiom;

import java.util.Iterator;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.option.axiom.AxiomDocument;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.tree.wrapper.AbstractNodeWrapper;
import net.sf.saxon.tree.wrapper.SiblingCountingNode;
import net.sf.saxon.value.UntypedAtomicValue;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;

public abstract class AxiomParentNodeWrapper
extends AbstractNodeWrapper
implements SiblingCountingNode {
    protected OMContainer node;

    protected AxiomParentNodeWrapper(OMContainer node) {
        this.node = node;
    }

    public OMContainer getUnderlyingNode() {
        return this.node;
    }

    @Override
    public AtomicSequence atomize() {
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    @Override
    public CharSequence getStringValueCS() {
        FastStringBuffer buff = new FastStringBuffer(256);
        Iterator iter = this.node.getDescendants(false);
        while (iter.hasNext()) {
            OMNode next = (OMNode)iter.next();
            if (!(next instanceof OMText)) continue;
            buff.append(((OMText)next).getText());
        }
        return buff.condense();
    }

    @Override
    public boolean hasChildNodes() {
        return this.node.getFirstOMChild() != null;
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        Navigator.appendSequentialKey(this, buffer, true);
    }

    @Override
    protected final AxisIterator iterateChildren(NodeTest nodeTest) {
        return new ChildWrappingIterator(this, nodeTest);
    }

    @Override
    protected AxisIterator iterateDescendants(NodeTest nodeTest, boolean includeSelf) {
        return new DescendantWrappingIterator(this, nodeTest, includeSelf);
    }

    protected class ChildWrappingIterator
    extends AxiomWrappingIterator {
        AxiomParentNodeWrapper commonParent;
        AxiomDocument docWrapper;
        int index;

        public ChildWrappingIterator(AxiomParentNodeWrapper commonParent, NodeTest nodeTest) {
            super(AxiomParentNodeWrapper.this.node.getChildren(), nodeTest);
            this.index = 0;
            this.commonParent = commonParent;
            this.nodeTest = nodeTest;
            this.docWrapper = (AxiomDocument)commonParent.getTreeInfo();
        }

        @Override
        protected NodeInfo wrap(Object node) {
            return AxiomDocument.makeWrapper((OMNode)node, this.docWrapper, this.commonParent, this.index++);
        }
    }

    protected class DescendantWrappingIterator
    extends AxiomWrappingIterator {
        AxiomParentNodeWrapper parentWrapper;
        AxiomDocument docWrapper;
        boolean includeSelf;

        public DescendantWrappingIterator(AxiomParentNodeWrapper parentWrapper, NodeTest nodeTest, boolean includeSelf) {
            super(AxiomParentNodeWrapper.this.node.getDescendants(includeSelf), nodeTest);
            this.parentWrapper = parentWrapper;
            this.docWrapper = (AxiomDocument)parentWrapper.getTreeInfo();
            this.includeSelf = includeSelf;
        }

        @Override
        protected NodeInfo wrap(Object node) {
            if (node instanceof OMDocument) {
                return this.docWrapper.getRootNode();
            }
            return AxiomDocument.makeWrapper((OMNode)node, this.docWrapper, null, -1);
        }
    }

    private abstract class AxiomWrappingIterator
    implements AxisIterator {
        Iterator base;
        NodeTest nodeTest;

        public AxiomWrappingIterator(Iterator base, NodeTest nodeTest) {
            this.base = base;
            this.nodeTest = nodeTest;
        }

        @Override
        public NodeInfo next() {
            while (this.base.hasNext()) {
                Object node = this.base.next();
                NodeInfo wrapper = this.wrap(node);
                if (!this.nodeTest.matchesNode(wrapper)) continue;
                return wrapper;
            }
            return null;
        }

        protected abstract NodeInfo wrap(Object var1);
    }
}

