/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import java.util.List;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.FLWORExpression;
import net.sf.saxon.expr.flwor.ReturnClauseIterator;
import net.sf.saxon.expr.flwor.ReturnClausePush;
import net.sf.saxon.expr.flwor.SingularityPull;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.flwor.WindowClause;

public class FLWORExpressionCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        FLWORExpressionCompiler.visitAnnotation(compiler, "FLWORExpressionCompiler-Iter");
        FLWORExpression flworExpr = (FLWORExpression)expression;
        List<Clause> clauses = flworExpr.getClauseList();
        for (int i = 1; i < clauses.size(); ++i) {
            if (!(clauses.get(i) instanceof WindowClause)) continue;
            compiler.generateGetContext();
            ga.invokeInstanceMethod(XPathContext.class, "getController", new Class[0]);
            ga.invokeInstanceMethod(Controller.class, "allocateSequenceOutputter", new Class[0]);
            ga.dup();
            ga.invokeInstanceMethod(SequenceOutputter.class, "getPipelineConfiguration", new Class[0]);
            ga.push(expression.getPackageData().getHostLanguage());
            ga.invokeInstanceMethod(PipelineConfiguration.class, "setHostLanguage", Integer.TYPE);
            compiler.pushNewReceiverInfo(ga);
            compiler.compileToPush(expression);
            compiler.generateGetReceiver();
            compiler.popReceiverInfo();
            ga.dup();
            ga.invokeInstanceMethod(SequenceOutputter.class, "close", new Class[0]);
            ga.invokeInstanceMethod(SequenceOutputter.class, "iterate", new Class[0]);
            return;
        }
        ga.newInstance(ReturnClauseIterator.class);
        ga.dup();
        ga.invokeDefaultConstructor(SingularityPull.class);
        for (Clause c : clauses) {
            ExpressionCompiler.allocateStatic(compiler, c);
            ga.swap();
            compiler.generateGetContext();
            ga.invokeInstanceMethod(Clause.class, "getPullStream", TuplePull.class, XPathContext.class);
        }
        FLWORExpressionCompiler.allocateStatic(compiler, flworExpr);
        compiler.generateGetContext();
        ga.invokeConstructor(ReturnClauseIterator.class, TuplePull.class, FLWORExpression.class, XPathContext.class);
    }

    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        FLWORExpressionCompiler.visitAnnotation(compiler, "FLWORExpressionCompiler-Push");
        FLWORExpression flworExpr = (FLWORExpression)expression;
        List<Clause> clauses = flworExpr.getClauseList();
        ga.newInstance(ReturnClausePush.class);
        ga.dup();
        FLWORExpressionCompiler.allocateStatic(compiler, flworExpr.getReturnClause());
        ga.invokeConstructor(ReturnClausePush.class, Expression.class);
        for (int i = clauses.size() - 1; i >= 0; --i) {
            ExpressionCompiler.allocateStatic(compiler, clauses.get(i));
            ga.swap();
            compiler.generateGetContext();
            ga.invokeInstanceMethod(Clause.class, "getPushStream", TuplePush.class, XPathContext.class);
        }
        ga.dup();
        compiler.generateGetContext();
        ga.invokeInstanceMethod(TuplePush.class, "processTuple", XPathContext.class);
        ga.invokeInstanceMethod(TuplePush.class, "close", new Class[0]);
    }
}

