/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ElementCreatorCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.Generator;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.FixedElement;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceBindingSet;

public class FixedElementCompiler
extends ElementCreatorCompiler {
    @Override
    protected void pushNodeName(CompilerService compiler, Expression expression) throws CannotCompileException {
        FixedElementCompiler.allocateStatic(compiler, ((FixedElement)expression).getElementName());
    }

    @Override
    protected void outputNamespaceNodes(CompilerService compiler, Expression expression) {
        NamespaceBinding[] bindings = ((FixedElement)expression).getActiveNamespaces();
        Generator ga = compiler.getCurrentGenerator();
        if (bindings != null) {
            for (NamespaceBinding binding : bindings) {
                compiler.generateGetReceiver();
                FixedElementCompiler.allocateStatic(compiler, binding);
                ga.push(0);
                ga.invokeInstanceMethod(Receiver.class, "namespace", NamespaceBindingSet.class, Integer.TYPE);
            }
        }
    }

    @Override
    public void identifyExpression(CompilerService compiler, Expression expression, String evalMode) {
        FixedElementCompiler.visitAnnotation(compiler, "FixedElement-" + ((FixedElement)expression).getElementName().getDisplayName());
    }
}

