/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.AxisExpressionCompiler;
import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.map.CompiledAxisMappingFunction;
import com.saxonica.ee.bytecode.map.CompiledContextMappingFunction;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.objectweb.asm.ClassVisitor;
import com.saxonica.objectweb.asm.ClassWriter;
import com.saxonica.objectweb.asm.Type;
import com.saxonica.objectweb.asm.commons.Method;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ContextMappingFunction;
import net.sf.saxon.expr.ContextMappingIterator;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.AxisIterator;

public class SlashExpressionCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        Expression start = ((ContextSwitchingExpression)((Object)expression)).getSelectExpression();
        Expression step = ((ContextSwitchingExpression)((Object)expression)).getActionExpression();
        Generator ga = compiler.getCurrentGenerator();
        SlashExpressionCompiler.visitAnnotation(compiler, "SlashExpressionCompiler-Iterator");
        SlashExpressionCompiler.visitLineNumber(compiler, ga, expression);
        if (expression instanceof SlashExpression && ((SlashExpression)expression).isContextFree()) {
            ga.newInstance(MappingIterator.class);
            ga.dup();
            compiler.compileToIterator(start);
            CompiledAxisMappingFunction fn = SlashExpressionCompiler.generateAxisMappingFunction(compiler, (AxisExpression)step);
            SlashExpressionCompiler.allocateStatic(compiler, fn);
            ga.invokeConstructor(MappingIterator.class, SequenceIterator.class, MappingFunction.class);
        } else {
            ga.newInstance(ContextMappingIterator.class);
            ga.dup();
            CompiledContextMappingFunction contextMapFunc = SlashExpressionCompiler.generateMappingFunction(compiler, ((ContextSwitchingExpression)((Object)expression)).getActionExpression());
            SlashExpressionCompiler.allocateStatic(compiler, contextMapFunc);
            compiler.generateGetContext();
            ga.invokeInstanceMethod(XPathContext.class, "newMinorContext", new Class[0]);
            ga.dup();
            ga.newInstance(FocusTrackingIterator.class);
            ga.dup();
            compiler.compileToIterator(start);
            ga.invokeConstructor(FocusTrackingIterator.class, SequenceIterator.class);
            ga.invokeInstanceMethod(XPathContext.class, "setCurrentIterator", FocusIterator.class);
            ga.invokeConstructor(ContextMappingIterator.class, ContextMappingFunction.class, XPathContext.class);
        }
    }

    public static CompiledContextMappingFunction generateMappingFunction(CompilerService compiler, Expression step) throws CannotCompileException {
        compiler.checkMaxClassesLimit();
        ClassWriter cw = new ClassWriter(compiler.getFlags());
        ClassVisitor cv = cw;
        String className = "gen_SlashContextMappingFunction_" + compiler.getUniqueNumber();
        cv = compiler.makeAnnotatedTraceClassVisitor(cv, className);
        cv.visitSource(step.getLocation().getSystemId(), null);
        cv.visit(49, 1, className, null, "com/saxonica/ee/bytecode/map/CompiledContextMappingFunction", new String[0]);
        compiler.pushNewClassInfo(className, CompiledContextMappingFunction.class, cw);
        Method m = Method.getMethod("void <init> ()");
        Generator ga = new Generator(1, m, false, cv);
        ga.loadThis();
        ga.invokeConstructor(Type.getType(CompiledContextMappingFunction.class), m);
        ga.returnValue();
        ga.endMethod();
        m = Method.getMethod("net.sf.saxon.om.SequenceIterator map(net.sf.saxon.expr.XPathContext)");
        SlashExpressionCompiler.visitAnnotation(compiler, "SlashExpressionCompiler - map");
        ga = new Generator(1, m, true, cv);
        compiler.pushNewMethodInfo(ga, true, 0);
        SlashExpressionCompiler.visitLineNumber(compiler, ga, step);
        compiler.compileToIterator(step);
        ga.returnValue();
        ga.endMethod();
        compiler.popCurrentMethodInfo();
        cv.visitEnd();
        SlashExpressionCompiler.verify(cw, "Step expression at line " + step.getLocation().getLineNumber(), compiler.isDebugByteCode());
        Class mappingFunction = compiler.makeClass(cw, className);
        try {
            return (CompiledContextMappingFunction)mappingFunction.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CannotCompileException(step, e.getMessage());
        }
    }

    public static CompiledAxisMappingFunction generateAxisMappingFunction(CompilerService compiler, AxisExpression step) throws CannotCompileException {
        compiler.checkMaxClassesLimit();
        ClassWriter cw = new ClassWriter(compiler.getFlags());
        ClassVisitor cv = cw;
        String className = "gen_AxisMappingFunction_" + compiler.getUniqueNumber();
        cv = compiler.makeAnnotatedTraceClassVisitor(cv, className);
        cv.visitSource(step.getLocation().getSystemId(), null);
        cv.visit(49, 1, className, null, "com/saxonica/ee/bytecode/map/CompiledAxisMappingFunction", new String[0]);
        compiler.pushNewClassInfo(className, CompiledAxisMappingFunction.class, cw);
        Method m = Method.getMethod("void <init> ()");
        Generator ga = new Generator(1, m, false, cv);
        ga.loadThis();
        ga.invokeConstructor(Type.getType(CompiledAxisMappingFunction.class), m);
        ga.returnValue();
        ga.endMethod();
        m = Method.getMethod("net.sf.saxon.tree.iter.AxisIterator map(net.sf.saxon.om.NodeInfo)");
        SlashExpressionCompiler.visitAnnotation(compiler, "SlashExpressionCompiler - axisMap");
        ga = new Generator(1, m, true, cv);
        compiler.pushNewMethodInfo(ga, false, 0);
        SlashExpressionCompiler.visitLineNumber(compiler, ga, step);
        ga.loadArg(0);
        AxisExpressionCompiler.iterate(compiler, step.getAxis(), step.getNodeTest());
        ga.checkClass(AxisIterator.class);
        ga.returnValue();
        ga.endMethod();
        compiler.popCurrentMethodInfo();
        cv.visitEnd();
        SlashExpressionCompiler.verify(cw, "Step expression at line " + step.getLocation().getLineNumber(), compiler.isDebugByteCode());
        Class mappingFunction = compiler.makeClass(cw, className);
        try {
            return (CompiledAxisMappingFunction)mappingFunction.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CannotCompileException(step, e.getMessage());
        }
    }

    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        Expression select = ((ContextSwitchingExpression)((Object)expression)).getSelectExpression();
        Expression action = ((ContextSwitchingExpression)((Object)expression)).getActionExpression();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        SlashExpressionCompiler.visitAnnotation(compiler, "SlashExpressionCompiler-Push");
        SlashExpressionCompiler.visitLineNumber(compiler, ga, expression);
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "newMinorContext", new Class[0]);
        int context2Var = methodInfo.allocateLocal(XPathContext.class);
        SlashExpressionCompiler.visitAnnotation(compiler, "SlashExpressionCompiler - newMinorContext");
        ga.storeLocal(context2Var);
        ga.loadLocal(context2Var);
        ga.newInstance(FocusTrackingIterator.class);
        ga.dup();
        compiler.compileToIterator(select);
        ga.invokeConstructor(FocusTrackingIterator.class, SequenceIterator.class);
        int iterVar = methodInfo.allocateLocal(SequenceIterator.class);
        ga.dup();
        ga.storeLocal(iterVar);
        ga.invokeInstanceMethod(XPathContext.class, "setCurrentIterator", FocusIterator.class);
        methodInfo.pushContextVariableInfo(context2Var, false);
        LabelInfo forEachDone = methodInfo.newLabel("forEachDone");
        LabelInfo loop = methodInfo.placeNewLabel("forEachLoop");
        ga.loadLocal(iterVar);
        ga.showObjectVariable(compiler, "forEachSelectIterator", iterVar);
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        ga.ifNull(forEachDone.label());
        SlashExpressionCompiler.visitAnnotation(compiler, "SlashExpressionCompiler - compileAction");
        compiler.compileToPush(action);
        ga.goTo(loop);
        methodInfo.placeLabel(forEachDone);
        methodInfo.popContextVariableInfo();
        methodInfo.releaseLocal(context2Var);
        methodInfo.releaseLocal(iterVar);
    }
}

