/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.ItemFeed;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;

public class BufferingFeed
extends ItemFeed {
    private List<Item<?>> inputValue = new ArrayList(4);

    public BufferingFeed(Expression expr, Feed result, XPathContext context) {
        super(expr, result, context);
    }

    @Override
    public void processItem(Item<?> item) throws XPathException {
        this.inputValue.add(item);
        if (this.inputValue.size() == 2) {
            XPathContext c = this.getContext();
            c.getController().getErrorListener().warning(new XPathException("Execution of " + this.getExpression().toShortString() + " is not fully streamed", "SXST0067", this.getExpression().getLocation()));
        }
    }

    @Override
    public void close() throws XPathException {
        ((XPathContextMinor)this.getContext()).makeStackFrameMutable();
        this.getContext().getStackFrame().pushDynamicValue(SequenceExtent.makeSequenceExtent(this.inputValue));
        this.inputValue = new ArrayList(4);
        SequenceIterator<?> iter = this.getExpression().iterate(this.getContext());
        iter.forEachOrFail(item -> this.getResult().processItem(item));
        this.getResult().close();
    }
}

