/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.trans;

import com.saxonica.ee.trans.Characteristic;
import com.saxonica.ee.trans.PreconditionMatcher;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.z.IntSet;

public abstract class Precondition {
    int slotNumber;

    public void setSlotNumber(int slotNumber) {
        this.slotNumber = slotNumber;
    }

    public final boolean isSatisfied(PreconditionMatcher matcher) throws XPathException {
        Boolean b = matcher.getPreconditionState(this.slotNumber);
        if (b == null) {
            b = this.testPrecondition(matcher);
            matcher.setPreconditionState(this.slotNumber, b);
        }
        return b;
    }

    protected abstract boolean testPrecondition(PreconditionMatcher var1) throws XPathException;

    public static class BooleanPrecondition
    extends Precondition {
        Characteristic<Boolean> characteristic;

        public BooleanPrecondition(Characteristic<Boolean> characteristic) {
            this.characteristic = characteristic;
        }

        @Override
        public boolean testPrecondition(PreconditionMatcher matcher) throws XPathException {
            return matcher.obtainCharacteristic(this.characteristic);
        }

        public int hashCode() {
            return this.characteristic.hashCode() ^ 0x1E28;
        }

        public boolean equals(Object obj) {
            if (obj instanceof BooleanPrecondition) {
                BooleanPrecondition other = (BooleanPrecondition)obj;
                return this.characteristic.equals(other.characteristic);
            }
            return false;
        }

        public String toString() {
            return this.characteristic.toString();
        }
    }

    public static class NumericComparisonPrecondition
    extends Precondition {
        Characteristic<NumericValue> characteristic;
        long required;

        public NumericComparisonPrecondition(Characteristic<NumericValue> characteristic, long required) {
            this.characteristic = characteristic;
            this.required = required;
        }

        @Override
        public boolean testPrecondition(PreconditionMatcher matcher) throws XPathException {
            NumericValue comparand = matcher.obtainCharacteristic(this.characteristic);
            return !comparand.isNaN() && comparand.compareTo(this.required) == 0;
        }

        public int hashCode() {
            return this.characteristic.hashCode() ^ (int)this.required;
        }

        public boolean equals(Object obj) {
            if (obj instanceof NumericComparisonPrecondition) {
                NumericComparisonPrecondition other = (NumericComparisonPrecondition)obj;
                return this.required == other.required && this.characteristic.equals(other.characteristic);
            }
            return false;
        }

        public String toString() {
            return "hash(" + this.characteristic + ")=" + Long.toHexString(this.required);
        }
    }

    public static class StringHashPrecondition
    extends Precondition {
        Characteristic<IntSet> characteristic;
        int hash;
        StringCollator collator;

        public StringHashPrecondition(Characteristic<IntSet> characteristic, AtomicMatchKey required, StringCollator collator) {
            this.characteristic = characteristic;
            this.collator = collator;
            this.hash = required.hashCode();
        }

        @Override
        public boolean testPrecondition(PreconditionMatcher matcher) throws XPathException {
            IntSet comparand = matcher.obtainCharacteristic(this.characteristic);
            return comparand.contains(this.hash);
        }

        public int hashCode() {
            return this.characteristic.hashCode() ^ this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof StringHashPrecondition) {
                StringHashPrecondition other = (StringHashPrecondition)obj;
                return this.collator == other.collator && this.hash == other.hash && this.characteristic.equals(other.characteristic);
            }
            return false;
        }

        public String toString() {
            return "hash(" + this.characteristic + ")=" + Integer.toHexString(this.hash);
        }
    }
}

