/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query;

import de.ids_mannheim.korap.query.SimpleSpanQuery;
import de.ids_mannheim.korap.query.spans.RepetitionSpans;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public class SpanRepetitionQuery
extends SimpleSpanQuery {
    private int min;
    private int max;

    public SpanRepetitionQuery(SpanQuery sq, int min, int max, boolean collectPayloads) {
        super(sq, collectPayloads);
        if (min < 1) {
            throw new IllegalArgumentException("Minimum repetition must not lower than 1.");
        }
        this.min = min;
        this.max = max;
    }

    @Override
    public SimpleSpanQuery clone() {
        SpanRepetitionQuery sq = new SpanRepetitionQuery((SpanQuery)this.firstClause.clone(), this.min, this.max, this.collectPayloads);
        sq.setBoost(this.getBoost());
        return sq;
    }

    @Override
    public Spans getSpans(LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        return new RepetitionSpans(this, context, acceptDocs, termContexts);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("spanRepetition(");
        sb.append(this.firstClause.toString(field));
        sb.append("{");
        sb.append(this.min);
        sb.append(",");
        sb.append(this.max);
        sb.append("})");
        sb.append(ToStringUtils.boost(this.getBoost()));
        return sb.toString();
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }
}

