/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode.converter;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.converter.ConverterCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.MessageTemplate;
import com.saxonica.ee.bytecode.util.OnEmpty;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.FloatValue;

public class StringToFloatCompiler
extends ConverterCompiler {
    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        CastExpression cast = (CastExpression)expression;
        Expression base = cast.getBaseExpression();
        AtomicType targetType = cast.getTargetType();
        Converter converter = cast.getConverter();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        AtomicType sourceType = (AtomicType)base.getItemType();
        boolean allowsEmpty = Cardinality.allowsZero(cast.getCardinality());
        ExpressionCompiler.visitAnnotation(compiler, "StringToFloatConverter-Item");
        if (allowsEmpty) {
            LabelInfo empty = methodInfo.newLabel("returnEmpty");
            LabelInfo end = methodInfo.newLabel("end");
            this.compileToPrimitive(compiler, expression, CharSequence.class, new OnEmpty.UnwindAndJump(empty));
            ga.invokeStaticMethod(FloatValue.class, "makeFloatValue", Float.TYPE);
            ga.goTo(end);
            methodInfo.placeLabel(empty);
            ga.pushNull();
            methodInfo.placeLabel(end);
        } else {
            this.compileToPrimitive(compiler, expression, CharSequence.class, OnEmpty.RETURN_NULL);
            ga.invokeStaticMethod(FloatValue.class, "makeFloatValue", Float.TYPE);
        }
    }

    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        CastExpression cast = (CastExpression)expression;
        Expression base = cast.getBaseExpression();
        AtomicType targetType = cast.getTargetType();
        Converter converter = cast.getConverter();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        TypeHierarchy th = compiler.getConfiguration().getTypeHierarchy();
        AtomicType sourceType = (AtomicType)base.getItemType();
        boolean allowsEmpty = Cardinality.allowsZero(cast.getCardinality());
        ExpressionCompiler.visitAnnotation(compiler, "StringToFloatConverter-Primitive");
        if (allowsEmpty && !(onEmpty instanceof OnEmpty.UnwindAndJump)) {
            throw new IllegalArgumentException();
        }
        compiler.compileToPrimitive(base, CharSequence.class, onEmpty);
        int strValue = methodInfo.allocateLocal(CharSequence.class);
        ga.storeLocal(strValue);
        ExpressionCompiler.allocateStatic(compiler, compiler.getConfiguration().getConversionRules().getStringToDoubleConverter());
        ga.loadLocal(strValue);
        LabelInfo L0 = methodInfo.newLabel("L0_castExpr");
        LabelInfo L1 = methodInfo.newLabel("L1_castExpr");
        LabelInfo L2 = methodInfo.newLabel("L2_castExpr");
        LabelInfo done = methodInfo.newLabel("doneCast");
        ga.visitTryCatchBlock(L0, L1, L2, "java/lang/NumberFormatException");
        methodInfo.placeLabel(L0);
        ga.invokeInstanceMethod(StringToDouble.class, "stringToNumber", CharSequence.class);
        ga.cast(Type.DOUBLE_TYPE, Type.FLOAT_TYPE);
        methodInfo.placeLabel(L1);
        ga.goTo(done.label());
        methodInfo.placeLabel(L2);
        compiler.generateParameterizedDynamicError(new MessageTemplate(ga, "Cannot cast string to float: {$1}", strValue), "FORG0001", cast.getLocation(), false);
        methodInfo.placeLabel(done);
        methodInfo.releaseLocal(strValue);
    }
}

