/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.optim;

import com.saxonica.ee.optim.SearchableValue;
import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.ManualIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.AtomicValue;

class SmallSearchableValue<T extends Item<?>>
extends SearchableValue<T> {
    SmallSearchableValue(T[] array, int end) {
        this.value = array;
        this.end = end;
    }

    @Override
    public SequenceIterator<T> findItems(Expression use, SequenceIterator<? extends AtomicValue> values, boolean convertUntypedToOther, boolean firstOnly, AtomicComparer comparer, XPathContext context) throws XPathException {
        ArrayList<Item> selected = new ArrayList<Item>();
        XPathContextMajor c2 = context.newContext();
        ManualIterator<Item> manual = new ManualIterator<Item>();
        c2.setCurrentIterator(manual);
        ArrayList soughtValues = new ArrayList();
        values.forEachOrFail(soughtValues::add);
        if (soughtValues.isEmpty()) {
            return EmptyIterator.emptyIterator();
        }
        EqualityComparer compare = convertUntypedToOther ? (a, b) -> GeneralComparison.compare(a, 50, b, comparer, true, c2, use.getRetainedStaticContext()) : (a, b) -> ValueComparison.compare(a, 50, b, comparer, true);
        for (int i = 0; i < this.end; ++i) {
            Object key;
            manual.setContextItem(this.value[i]);
            SequenceIterator<?> keys = use.iterate(c2);
            while ((key = keys.next()) != null) {
                AtomicSequence atomized = key.atomize();
                for (AtomicValue sought : soughtValues) {
                    for (AtomicValue val : atomized) {
                        if (!compare.compare(val, sought)) continue;
                        if (firstOnly) {
                            return SingletonIterator.makeIterator(this.value[i]);
                        }
                        selected.add(this.value[i]);
                    }
                }
            }
        }
        return new ListIterator(selected);
    }

    @FunctionalInterface
    private static interface EqualityComparer {
        public boolean compare(AtomicValue var1, AtomicValue var2) throws XPathException;
    }
}

