/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream;

import com.saxonica.ee.bytecode.CompiledExpression;
import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.PostureAndSweep;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.trans.ContextItemStaticInfoEE;
import java.util.HashSet;
import java.util.List;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.SourceDocument;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.functions.AccumulatorFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.UType;

public class Streamability {
    public static final int OFF = 0;
    public static final int STANDARD = 1;
    public static final int EXTENDED = 2;

    public static Operand getConsumingOperand(Expression exp) {
        for (Operand o : exp.operands()) {
            Expression e = o.getChildExpression();
            PostureAndSweep ps = Streamability.getPostureAndSweepIfKnown(e);
            if (ps == null) {
                return null;
            }
            if (ps.getSweep() == Sweep.CONSUMING) {
                return o;
            }
            if (o.getUsage() == OperandUsage.TRANSMISSION && ps.getPosture() != Posture.GROUNDED) {
                return o;
            }
            if (o.getUsage() != OperandUsage.ABSORPTION || !ps.getPosture().isIncremental()) continue;
            return o;
        }
        return null;
    }

    public static Expression rewriteQuantifiedExpressionAsFilterExpression(QuantifiedExpression quant) throws XPathException {
        Expression select = quant.getSequence();
        Expression test = quant.getAction().copy(new RebindingMap());
        RetainedStaticContext rsc = quant.getRetainedStaticContext();
        if ((test = Streamability.replaceVariableReferenceByDot(test, quant)) != null) {
            if (quant.getOperator() == 32) {
                Expression fn = SystemFunction.makeCall("boolean", rsc, test);
                FilterExpression fe = new FilterExpression(select, fn);
                return SystemFunction.makeCall("exists", rsc, fe);
            }
            Expression fn = SystemFunction.makeCall("not", rsc, test);
            FilterExpression fe = new FilterExpression(select, fn);
            return SystemFunction.makeCall("empty", rsc, fe);
        }
        return null;
    }

    public static Expression rewriteForExpressionAsMappingExpression(ForExpression forEx) {
        Expression select = forEx.getSequence();
        Expression step = forEx.getAction().copy(new RebindingMap());
        if ((step = Streamability.replaceVariableReferenceByDot(step, forEx)) != null) {
            return new ForEach(select, step);
        }
        return null;
    }

    private static Expression replaceVariableReferenceByDot(Expression test, Binding binding) {
        for (Operand info : test.operands()) {
            if (!info.hasSameFocus() && ExpressionTool.dependsOnVariable(info.getChildExpression(), new Binding[]{binding})) {
                return null;
            }
            if (info.getChildExpression() instanceof LocalVariableReference && ((LocalVariableReference)info.getChildExpression()).getBinding() == binding) {
                info.setChildExpression(new ContextItemExpression());
                continue;
            }
            Expression e2 = Streamability.replaceVariableReferenceByDot(info.getChildExpression(), binding);
            if (e2 != null) continue;
            return null;
        }
        return test;
    }

    public static PostureAndSweep generalStreamabilityRules(Expression target, Iterable<Operand> operands, ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        if (target.getRetainedStaticContext().isBackwardsCompatibility()) {
            reasons.add("Instructions with effective version='1.0' are not streamable");
            return PostureAndSweep.ROAMING_AND_FREE_RANGING;
        }
        Operand potentiallyConsumingOperand = null;
        PostureAndSweep postureAndSweepOfPotentiallyConsumingOperand = null;
        Sweep widestInChoiceGroup = Sweep.MOTIONLESS;
        HashSet<Posture> choiceGroupPostures = new HashSet<Posture>();
        ContextItemStaticInfoEE newFocus = null;
        for (Operand operand : operands) {
            if (!operand.setsNewFocus()) continue;
            Streamability.getStreamability(operand.getChildExpression(), contextInfo, reasons);
            newFocus = (ContextItemStaticInfoEE)target.getConfiguration().makeContextItemStaticInfo(Streamability.getItemType(operand.getChildExpression(), contextInfo), false);
            newFocus.setContextSettingExpression(operand.getChildExpression());
        }
        boolean foundOperand = false;
        for (Operand o : operands) {
            ContextItemStaticInfoEE info2;
            Expression child = o.getChildExpression();
            foundOperand = true;
            OperandUsage usage = o.getUsage();
            if (o.hasSameFocus()) {
                info2 = contextInfo;
            } else if (o.hasSpecialFocusRules()) {
                info2 = Streamability.getCustomStaticInfo(o);
            } else {
                assert (newFocus != null);
                info2 = newFocus;
            }
            PostureAndSweep ps = Streamability.getStreamability(child, info2, reasons);
            Posture p = ps.getPosture();
            Sweep s = ps.getSweep();
            if (s == Sweep.FREE_RANGING || p == Posture.ROAMING) {
                s = Sweep.FREE_RANGING;
            } else if (p != Posture.GROUNDED) {
                ItemType t = Streamability.getItemType(child, info2);
                if (usage == OperandUsage.ABSORPTION && !t.getUType().overlaps(UType.DOCUMENT.union(UType.ELEMENT))) {
                    usage = OperandUsage.INSPECTION;
                }
                if (usage == OperandUsage.NAVIGATION) {
                    if (reasons != null) {
                        reasons.add(Streamability.describeOperand(target, o) + " selects streamed nodes in a context that allows arbitrary navigation (line " + o.getChildExpression().getLocation().getLineNumber() + ")");
                    }
                    s = Sweep.FREE_RANGING;
                } else if (usage == OperandUsage.ABSORPTION) {
                    if (p == Posture.CLIMBING) {
                        if (reasons != null) {
                            reasons.add(Streamability.describeOperand(target, o) + " reads the string value or typed value of a node in climbing posture (line " + o.getChildExpression().getLocation().getLineNumber() + ")");
                        }
                        s = Sweep.FREE_RANGING;
                    } else if (p == Posture.CRAWLING) {
                        s = Sweep.CONSUMING;
                    } else if (p == Posture.STRIDING) {
                        s = Sweep.CONSUMING;
                    }
                }
            }
            if (s == Sweep.FREE_RANGING) {
                return new PostureAndSweep(Posture.ROAMING, Sweep.FREE_RANGING);
            }
            if (s != Sweep.CONSUMING && (usage != OperandUsage.TRANSMISSION || p == Posture.GROUNDED)) continue;
            if (potentiallyConsumingOperand != null) {
                if (reasons != null) {
                    int line1;
                    Expression e0 = potentiallyConsumingOperand.getChildExpression();
                    Expression e1 = o.getChildExpression();
                    int line0 = e0.getLocation().getLineNumber();
                    String suffix = line0 == (line1 = e1.getLocation().getLineNumber()) ? "{" + e0.toShortString() + "} and {" + e1.toShortString() + "}, both on line " + line0 : "{" + e0.toShortString() + "} on line " + line0 + ", and {" + e1.toShortString() + "} on line " + line1;
                    if (s == Sweep.CONSUMING && Streamability.getSweep(potentiallyConsumingOperand.getChildExpression()) == Sweep.CONSUMING) {
                        reasons.add("There is more than one consuming operand: " + suffix);
                    } else {
                        reasons.add("There is more than one potentially consuming operand: " + suffix);
                    }
                }
                return new PostureAndSweep(Posture.ROAMING, Sweep.FREE_RANGING);
            }
            if (o.isInChoiceGroup()) {
                widestInChoiceGroup = Sweep.wider(widestInChoiceGroup, s);
                choiceGroupPostures.add(p);
                continue;
            }
            if (!choiceGroupPostures.isEmpty()) {
                if (reasons != null) {
                    reasons.add("There is a consuming operand in a test condition (line " + o.getChildExpression().getLocation().getLineNumber() + "), and another in a previous conditional branch");
                }
                return new PostureAndSweep(Posture.ROAMING, Sweep.FREE_RANGING);
            }
            potentiallyConsumingOperand = o;
            postureAndSweepOfPotentiallyConsumingOperand = ps;
        }
        if (!foundOperand) {
            return new PostureAndSweep(Posture.GROUNDED, Sweep.MOTIONLESS);
        }
        if (!choiceGroupPostures.isEmpty()) {
            return new PostureAndSweep(Posture.combinedPosture(choiceGroupPostures), widestInChoiceGroup);
        }
        if (potentiallyConsumingOperand != null) {
            if (potentiallyConsumingOperand.isEvaluatedRepeatedly()) {
                if (reasons != null) {
                    reasons.add("A consuming operand is evaluated repeatedly");
                }
                return PostureAndSweep.ROAMING_AND_FREE_RANGING;
            }
            OperandUsage operandUsage = potentiallyConsumingOperand.getUsage();
            if (operandUsage == OperandUsage.ABSORPTION || operandUsage == OperandUsage.INSPECTION) {
                return new PostureAndSweep(Posture.GROUNDED, Sweep.CONSUMING);
            }
            return postureAndSweepOfPotentiallyConsumingOperand;
        }
        return new PostureAndSweep(Posture.GROUNDED, Sweep.MOTIONLESS);
    }

    private static ItemType getItemType(Expression exp, ContextItemStaticInfo info) {
        if (info.isStrictStreamabilityRules()) {
            return exp.getStaticUType(info.getItemType().getUType()).toItemType();
        }
        return exp.getItemType();
    }

    private static ContextItemStaticInfoEE getCustomStaticInfo(Operand o) {
        Expression exp = o.getParentExpression();
        if (exp instanceof SortKeyDefinition) {
            ContextItemStaticInfoEE ciso = new ContextItemStaticInfoEE(exp.getItemType(), false);
            ciso.setContextPostureGrounded();
            return ciso;
        }
        if (exp instanceof SourceDocument) {
            ContextItemStaticInfoEE ciso = new ContextItemStaticInfoEE(NodeKindTest.DOCUMENT, false);
            ciso.setContextPostureGrounded();
            return ciso;
        }
        assert (false);
        return null;
    }

    private static String describeOperand(Expression target, Operand o) {
        if (o.getChildExpression() instanceof ContextItemExpression && target instanceof LetExpression && ((LetExpression)target).getVariableQName().getLocalPart().startsWith("current")) {
            return "The current() function";
        }
        return "Operand {" + o.getChildExpression().toShortString() + "} of {" + target.toShortString() + "}";
    }

    public static boolean isChildlessNodeKind(ItemType type) {
        return type instanceof NodeTest && !type.getUType().overlaps(UType.PARENT_NODE_KINDS);
    }

    public static Pattern toStreamingPattern(Expression expr, Configuration config) {
        if (expr instanceof Instruction) {
            return null;
        }
        StreamingAdjunct adj = StreamingAdjunct.makeStreamingAdjunct(config, expr);
        Pattern pat = adj.toStreamingPattern(config);
        if (pat != null) {
            pat.setRecoverable(false);
        }
        return pat;
    }

    public static PostureAndSweep getStreamability(Expression exp, ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        PostureAndSweep postureAndSweep = (PostureAndSweep)exp.getExtraProperty("P+S");
        if (postureAndSweep == null) {
            if (exp instanceof Pattern) {
                if (contextInfo.getContextItemPosture() == Posture.GROUNDED || ((Pattern)exp).isMotionless()) {
                    postureAndSweep = PostureAndSweep.GROUNDED_AND_MOTIONLESS;
                } else {
                    if (reasons != null) {
                        reasons.add("The pattern " + exp.toShortString() + " is not motionless");
                    }
                    postureAndSweep = PostureAndSweep.ROAMING_AND_FREE_RANGING;
                }
            } else if (exp.isCallOn(AccumulatorFn.AccumulatorAfter.class)) {
                Sweep sweep = Streamability.computeAccumulatorAfterSweep((SystemFunctionCall)exp, contextInfo, reasons);
                postureAndSweep = new PostureAndSweep(Posture.GROUNDED, sweep);
            } else {
                StreamingAdjunct adjunct = StreamingAdjunct.makeStreamingAdjunct(exp.getConfiguration(), exp);
                postureAndSweep = adjunct.computeStreamability(contextInfo, reasons);
            }
            exp.setExtraProperty("P+S", postureAndSweep);
        }
        return postureAndSweep;
    }

    public static Posture getPosture(Expression exp) {
        PostureAndSweep postureAndSweep = Streamability.getPostureAndSweepIfKnown(exp);
        if (postureAndSweep != null) {
            return postureAndSweep.getPosture();
        }
        if (exp instanceof CompiledExpression) {
            return Streamability.getPosture(exp.getInterpretedExpression());
        }
        throw new IllegalStateException("getPosture() called when streamability has not yet been computed");
    }

    public static Sweep getSweep(Expression exp) {
        PostureAndSweep postureAndSweep = Streamability.getPostureAndSweepIfKnown(exp);
        if (postureAndSweep != null) {
            return postureAndSweep.getSweep();
        }
        if (exp instanceof CompiledExpression) {
            return Streamability.getSweep(exp.getInterpretedExpression());
        }
        throw new IllegalStateException(exp.getClass().getName() + ".getSweep() called when streamability has not yet been computed");
    }

    public static PostureAndSweep getPostureAndSweepIfKnown(Expression exp) {
        return (PostureAndSweep)exp.getExtraProperty("P+S");
    }

    public static void setPostureAndSweep(Expression exp, PostureAndSweep ps) {
        exp.setExtraProperty("P+S", ps);
    }

    public static Sweep computeAccumulatorAfterSweep(SystemFunctionCall call, ContextItemStaticInfoEE contextInfo, List<String> reasons) {
        Expression parent;
        boolean strict = contextInfo.isStrictStreamabilityRules();
        Sweep firstArgSweep = Streamability.getStreamability(call.getArg(0), contextInfo, reasons).getSweep();
        if (firstArgSweep != Sweep.MOTIONLESS) {
            reasons.add("First argument of accumulator-after() is " + (Object)((Object)firstArgSweep));
            return Sweep.FREE_RANGING;
        }
        if (contextInfo.getContextItemPosture() == Posture.GROUNDED) {
            return Sweep.MOTIONLESS;
        }
        if (contextInfo.getItemType().getUType().intersection(UType.PARENT_NODE_KINDS).equals(UType.VOID)) {
            return Sweep.MOTIONLESS;
        }
        AccumulatorFn.Phase phase = contextInfo.getAccumulatorPhase();
        if (phase == AccumulatorFn.Phase.BEFORE) {
            return Sweep.FREE_RANGING;
        }
        if (phase == AccumulatorFn.Phase.AFTER) {
            return Sweep.MOTIONLESS;
        }
        Expression focusSettingContainer = ExpressionTool.getFocusSettingContainer(call);
        if (focusSettingContainer != null) {
            for (parent = call.getParentExpression(); parent != null && !(parent instanceof Instruction); parent = parent.getParentExpression()) {
            }
            if (parent != null && focusSettingContainer != ExpressionTool.getFocusSettingContainer(parent)) {
                reasons.add("Call on accumulator-after() has different focus from containing instruction");
                return Sweep.FREE_RANGING;
            }
        }
        parent = call;
        boolean foundPrecedingConsumingExpression = false;
        while (parent != null) {
            Expression grandma = parent.getParentExpression();
            if (parent.isInstruction() || !strict) {
                if (grandma != null) {
                    for (Operand sib : grandma.operands()) {
                        if (sib.getChildExpression() == parent) break;
                        PostureAndSweep pas = Streamability.getStreamability(sib.getChildExpression(), contextInfo, reasons);
                        if (pas.getSweep() != Sweep.CONSUMING) continue;
                        foundPrecedingConsumingExpression = true;
                        break;
                    }
                }
                if (foundPrecedingConsumingExpression) break;
            }
            parent = grandma;
        }
        if (!foundPrecedingConsumingExpression) {
            reasons.add("A call to accumulator-after() is consuming when there are no preceding consuming instructions");
            return Sweep.CONSUMING;
        }
        return Sweep.MOTIONLESS;
    }
}

