/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.extfn.js;

import com.saxonica.ee.extfn.js.IXSLFunctionSet;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;

public class IXSLSetStyle
extends StyleElement {
    private Expression name;
    private Expression select;
    private Expression object;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    protected boolean mayContainSequenceConstructor() {
        return false;
    }

    @Override
    protected void prepareAttributes() {
        block10: for (AttributeInfo att : this.attributes()) {
            NodeName attName = att.getNodeName();
            String f = attName.getDisplayName();
            String value = att.getValue();
            switch (f) {
                case "name": {
                    String nameAtt = Whitespace.trim(value);
                    this.name = this.makeAttributeValueTemplate(nameAtt, att);
                    continue block10;
                }
                case "select": {
                    this.select = this.makeExpression(value, att);
                    continue block10;
                }
                case "object": {
                    this.object = this.makeExpression(value, att);
                    continue block10;
                }
            }
            this.checkUnknownAttribute(attName);
        }
        if (this.object == null) {
            this.object = this.makeExpression(".", null);
        }
        if (this.name == null) {
            this.reportAbsence("name");
        }
        if (this.select == null) {
            this.reportAbsence("select");
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.checkEmpty();
        this.name = this.typeCheck("name", this.name);
        this.select = this.typeCheck("select", this.select);
        this.object = this.typeCheck("object", this.object);
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        Expression e = IXSLFunctionSet.getInstance().makeFunction("set-style", 3).makeFunctionCall(this.name, this.select, this.object);
        e.setRetainedStaticContext(this.makeRetainedStaticContext());
        return e;
    }
}

