/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.om;

import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.MultiAccumulatorWatch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.Durability;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class FleetingDocumentNode
extends FleetingParentNode
implements TreeInfo {
    private Configuration config;
    private String systemId;
    private final long documentNumber;
    private int lastNodeNumber = 1;
    private HashMap<String, Object> userData;
    private MultiAccumulatorWatch multiAccumulatorWatch;
    private Map<String, String[]> unparsedEntities;
    private List<NodeInfo> initialCommentsAndProcessingInstructions;
    private SpaceStrippingRule spaceStrippingRule = NoElementsSpaceStrippingRule.getInstance();

    public FleetingDocumentNode(long docNr) {
        this.setNodeKind(9);
        this.root = this;
        this.setSystemId("");
        this.documentNumber = docNr;
        this.setHasChildren(true);
    }

    @Override
    public NodeInfo getRootNode() {
        return this;
    }

    @Override
    public TreeInfo getTreeInfo() {
        return this;
    }

    protected int allocateNodeNumber() {
        return this.lastNodeNumber++;
    }

    @Override
    public long getDocumentNumber() {
        return this.documentNumber;
    }

    @Override
    public Durability getDurability() {
        return Durability.FLEETING;
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
    }

    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
        if (this.unparsedEntities == null) {
            this.unparsedEntities = new HashMap<String, String[]>();
        }
        this.unparsedEntities.put(name, new String[]{systemID, publicID});
    }

    public void captureInitialCommentOrProcessingInstruction(NodeInfo node) {
        if (this.initialCommentsAndProcessingInstructions == null) {
            this.initialCommentsAndProcessingInstructions = new ArrayList<NodeInfo>(4);
        }
        this.initialCommentsAndProcessingInstructions.add(node);
    }

    public void copyInitialCommentsAndProcessingInstructions(Receiver out) throws XPathException {
        if (this.initialCommentsAndProcessingInstructions != null) {
            block4: for (NodeInfo node : this.initialCommentsAndProcessingInstructions) {
                switch (node.getNodeKind()) {
                    case 8: {
                        out.comment(node.getUnicodeStringValue(), Loc.NONE, 0);
                        continue block4;
                    }
                    case 7: {
                        out.processingInstruction(node.getLocalPart(), node.getUnicodeStringValue(), Loc.NONE, 0);
                        continue block4;
                    }
                }
                throw new IllegalStateException();
            }
        }
        this.initialCommentsAndProcessingInstructions = null;
    }

    @Override
    public NodeInfo selectID(String id, boolean getParent) {
        return null;
    }

    @Override
    public AtomicSequence atomize() throws XPathException {
        return StringValue.makeUntypedAtomic(this.getUnicodeStringValue());
    }

    @Override
    public Iterator<String> getUnparsedEntityNames() {
        if (this.unparsedEntities == null) {
            List e = Collections.emptyList();
            return e.iterator();
        }
        return this.unparsedEntities.keySet().iterator();
    }

    @Override
    public String[] getUnparsedEntity(String name) {
        if (this.unparsedEntities == null) {
            return null;
        }
        return this.unparsedEntities.get(name);
    }

    @Override
    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    @Override
    public void copy(Receiver out, int copyOptions, Location locationId) throws XPathException {
        throw new UnsupportedOperationException("copy() is not supported in streaming mode for document nodes");
    }

    @Override
    public String getSystemId() {
        return this.systemId;
    }

    @Override
    public String getBaseURI() {
        return this.systemId;
    }

    public void setMultiAccumulatorWatch(MultiAccumulatorWatch multiWatch) {
        this.multiAccumulatorWatch = multiWatch;
    }

    public MultiAccumulatorWatch getMultiAccumulatorWatch() {
        return this.multiAccumulatorWatch;
    }

    @Override
    public void setSpaceStrippingRule(SpaceStrippingRule rule) {
        this.spaceStrippingRule = rule;
    }

    @Override
    public SpaceStrippingRule getSpaceStrippingRule() {
        return this.spaceStrippingRule;
    }

    @Override
    public void setUserData(String key, Object value) {
        if (this.userData == null) {
            this.userData = new HashMap(4);
        }
        if (value == null) {
            this.userData.remove(key);
        } else {
            this.userData.put(key, value);
        }
    }

    @Override
    public Object getUserData(String key) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(key);
    }

    @Override
    public void notify(Receiver out) throws XPathException {
        out.startDocument(0);
    }
}

