/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.qt4;

import com.saxonica.functions.qt4.DecodeFromURI;
import com.saxonica.functions.qt4.URIFunctions;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.StringValue;

public class ParseURI
extends URIFunctions {
    @Override
    public MapItem call(XPathContext context, Sequence[] arguments) throws XPathException {
        String authority;
        String query;
        String uristr = arguments[0].head().getStringValue();
        MapItem map = new HashTrieMap();
        map = map.addEntry(URI, new StringValue(uristr));
        uristr = uristr.replaceAll("\\\\", "/");
        try {
            this.checkOptions(arguments);
        }
        catch (IllegalArgumentException e) {
            throw new XPathException(e);
        }
        int pos = uristr.indexOf("#");
        if (pos >= 0) {
            map = map.addEntry(FRAGMENT, new StringValue(DecodeFromURI.decode(uristr.substring(pos + 1))));
            uristr = uristr.substring(0, pos);
        }
        if ((pos = uristr.indexOf("?")) >= 0) {
            query = uristr.substring(pos + 1);
            map = map.addEntry(QUERY, new StringValue(query));
            uristr = uristr.substring(0, pos);
        } else {
            query = null;
        }
        String scheme = null;
        Pattern pattern = Pattern.compile("^([A-Za-z][-+.A-Za-z0-9]+):(.*)$");
        Matcher matcher = pattern.matcher(uristr);
        if (matcher.matches()) {
            scheme = matcher.group(1).toLowerCase();
            uristr = matcher.group(2);
        }
        if (scheme == null || "file".equals(scheme)) {
            pattern = Pattern.compile("^/*([A-Za-z])[:|](.*)$");
            matcher = pattern.matcher(uristr);
            if (matcher.find()) {
                scheme = "file";
                uristr = "/" + matcher.group(1) + ":" + matcher.group(2);
            } else if (this.uncPath) {
                scheme = "file";
            }
        }
        if (scheme != null) {
            map = map.addEntry(SCHEME, new StringValue(scheme));
        }
        if (scheme != null && hierarchicalSchemes.contains(scheme)) {
            this.hierarchical = true;
            map = map.addEntry(HIERARCHICAL, BooleanValue.get(this.hierarchical));
        } else if (scheme != null && nonHierarchicalSchemes.contains(scheme)) {
            this.hierarchical = false;
            map = map.addEntry(HIERARCHICAL, BooleanValue.get(this.hierarchical));
        } else {
            this.hierarchical = uristr.startsWith("/");
            if (!uristr.isEmpty()) {
                map = map.addEntry(HIERARCHICAL, BooleanValue.get(this.hierarchical));
            }
        }
        String filepath = null;
        if ("file".equals(scheme)) {
            authority = null;
            pattern = Pattern.compile("^/*(//[^/].*)$");
            matcher = pattern.matcher(uristr);
            filepath = this.uncPath && matcher.find() ? (uristr = matcher.group(1)) : ((uristr = uristr.replaceAll("^/+", "/")).matches("^/[A-Za-z]:.*$") ? uristr.substring(1) : uristr);
        } else if (this.hierarchical) {
            pattern = Pattern.compile("^//([^/]+)$");
            matcher = pattern.matcher(uristr);
            if (matcher.find()) {
                authority = matcher.group(1);
                uristr = "";
            } else {
                pattern = Pattern.compile("^//([^/]*)(/.*)$");
                matcher = pattern.matcher(uristr);
                if (matcher.find()) {
                    authority = matcher.group(1) != null && !matcher.group(1).isEmpty() ? matcher.group(1) : null;
                    uristr = matcher.group(2);
                } else {
                    authority = null;
                }
            }
        } else {
            authority = null;
        }
        if (authority != null) {
            map = map.addEntry(AUTHORITY, new StringValue(authority));
        }
        String port = null;
        if (authority != null) {
            pos = authority.indexOf("@");
            String userinfo = pos >= 0 && (this.allowDeprecatedFeatures || !authority.substring(0, pos).contains(":")) ? authority.substring(0, pos) : null;
            if (userinfo != null) {
                map = map.addEntry(USERINFO, new StringValue(userinfo));
            }
            if ((matcher = (pattern = Pattern.compile("^([^@]*@)?(\\[[^]]*])(:([^:]*))?$")).matcher(authority)).find()) {
                map = map.addEntry(HOST, new StringValue(matcher.group(2)));
                port = "".equals(matcher.group(4)) ? null : matcher.group(4);
            } else {
                pattern = Pattern.compile("^([^@]*@)?\\[.*$");
                matcher = pattern.matcher(authority);
                if (matcher.find()) {
                    throw new RuntimeException("Unparsable authority component");
                }
                pattern = Pattern.compile("^([^@]*@)?([^:]+)(:([^:]*))?$");
                matcher = pattern.matcher(authority);
                if (matcher.find()) {
                    map = map.addEntry(HOST, new StringValue(matcher.group(2)));
                    String string = port = "".equals(matcher.group(4)) ? null : matcher.group(4);
                }
            }
        }
        if (port != null && this.omitDefaultPorts && port.equals(defaultPorts.get(scheme))) {
            port = null;
        }
        if (port != null) {
            map = map.addEntry(PORT, new StringValue(port));
        }
        if (!"".equals(uristr)) {
            if (filepath == null && (scheme == null || "file".equals(scheme))) {
                filepath = uristr;
            }
            map = map.addEntry(PATH, new StringValue(uristr));
            GroundedValue pathSegments = EmptySequence.getInstance();
            pos = uristr.indexOf(this.pathSeparator);
            while (pos >= 0) {
                String seg = DecodeFromURI.decode(uristr.substring(0, pos));
                if (pathSegments.getLength() == 0 && "tel".equals(scheme) && seg.startsWith(" ")) {
                    seg = "+" + seg.substring(1);
                }
                pathSegments = pathSegments.concatenate(new StringValue(seg));
                uristr = uristr.substring(pos + 1);
                pos = uristr.indexOf(this.pathSeparator);
            }
            pathSegments = pathSegments.concatenate(new StringValue(DecodeFromURI.decode(uristr)));
            map = map.addEntry(PATH_SEGMENTS, pathSegments);
        }
        if (filepath != null) {
            String decoded = DecodeFromURI.decode(filepath);
            map = map.addEntry(FILEPATH, new StringValue(decoded));
        }
        if (query != null) {
            HashTrieMap querySegments = new HashTrieMap();
            for (String str : query.split("" + this.querySeparator)) {
                StringValue value;
                StringValue key;
                pos = str.indexOf("=");
                if (pos >= 0) {
                    key = new StringValue(DecodeFromURI.decode(str.substring(0, pos)));
                    value = new StringValue(DecodeFromURI.decode(str.substring(pos + 1)));
                } else {
                    key = new StringValue("");
                    value = new StringValue(DecodeFromURI.decode(str));
                }
                GroundedValue currentValue = querySegments.get(key);
                querySegments = currentValue == null ? querySegments.addEntry(key, value) : querySegments.addEntry(key, currentValue.concatenate(value));
            }
            map = map.addEntry(QUERY_PARAMETERS, querySegments);
        }
        return map;
    }
}

