/*
 * Decompiled with CFR 0.152.
 */
package marmot.test.morph;

import java.util.Arrays;
import marmot.morph.MorphDictionaryOptions;
import marmot.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;

public class MorphDictionaryOptionsTest {
    @Test
    public void simpleFilenameTest() {
        String option_string = "/bla/bla";
        MorphDictionaryOptions options = MorphDictionaryOptions.parse(option_string);
        Assert.assertEquals((Object)options.getFilename(), (Object)option_string);
    }

    @Test
    public void indexTest() {
        int[] indexes = new int[]{1, 2, 3};
        String option_string = "/bla/bla,indexes=[1,2,3]";
        MorphDictionaryOptions options = MorphDictionaryOptions.parse(option_string);
        Assert.assertEquals((Object)options.getFilename(), (Object)"/bla/bla");
        Assert.assertTrue((boolean)Arrays.equals(options.getIndexes(), indexes));
        option_string = "indexes=[3,1,2],/bla/bla";
        options = MorphDictionaryOptions.parse(option_string);
        Assert.assertEquals((Object)options.getFilename(), (Object)"/bla/bla");
        Assert.assertTrue((boolean)Arrays.equals(options.getIndexes(), indexes));
    }

    @Test
    public void suffixTest() {
        int[] indexes = new int[]{1, 2, 3};
        String option_string = "type=suffix,indexes=[3,1,2],/bla/bla";
        MorphDictionaryOptions options = MorphDictionaryOptions.parse(option_string);
        Assert.assertEquals((Object)options.getFilename(), (Object)"/bla/bla");
        Assert.assertTrue((boolean)Arrays.equals(options.getIndexes(), indexes));
        Assert.assertEquals((Object)((Object)options.getDictType()), (Object)((Object)MorphDictionaryOptions.DictionaryType.suffix));
        option_string = "type=suffix,/bla/bla,indexes=[3,1,2]";
        options = MorphDictionaryOptions.parse(option_string);
        Assert.assertEquals((Object)options.getFilename(), (Object)"/bla/bla");
        Assert.assertTrue((boolean)Arrays.equals(options.getIndexes(), indexes));
        Assert.assertEquals((Object)((Object)options.getDictType()), (Object)((Object)MorphDictionaryOptions.DictionaryType.suffix));
        option_string = "/bla/bla,indexes=[3,1,2],type=suffix";
        options = MorphDictionaryOptions.parse(option_string);
        Assert.assertEquals((Object)options.getFilename(), (Object)"/bla/bla");
        Assert.assertTrue((boolean)Arrays.equals(options.getIndexes(), indexes));
        Assert.assertEquals((Object)((Object)options.getDictType()), (Object)((Object)MorphDictionaryOptions.DictionaryType.suffix));
    }

    @Test
    public void normalizeTest() {
        int[] indexes = new int[]{1, 2, 3};
        String option_string = "norm=none,type=suffix,indexes=[3,1,2],/bla/bla";
        MorphDictionaryOptions options = MorphDictionaryOptions.parse(option_string);
        Assert.assertEquals((Object)options.getFilename(), (Object)"/bla/bla");
        Assert.assertTrue((boolean)Arrays.equals(options.getIndexes(), indexes));
        Assert.assertEquals((Object)((Object)options.getNormalize()), (Object)((Object)StringUtils.Mode.none));
        Assert.assertEquals((Object)((Object)options.getDictType()), (Object)((Object)MorphDictionaryOptions.DictionaryType.suffix));
        option_string = "type=suffix,norm=lower,/bla/bla,indexes=[3,1,2]";
        options = MorphDictionaryOptions.parse(option_string);
        Assert.assertEquals((Object)options.getFilename(), (Object)"/bla/bla");
        Assert.assertTrue((boolean)Arrays.equals(options.getIndexes(), indexes));
        Assert.assertEquals((Object)((Object)options.getNormalize()), (Object)((Object)StringUtils.Mode.lower));
        Assert.assertEquals((Object)((Object)options.getDictType()), (Object)((Object)MorphDictionaryOptions.DictionaryType.suffix));
        option_string = "/bla/bla,indexes=[3,1,2],norm=umlaut,type=suffix";
        options = MorphDictionaryOptions.parse(option_string);
        Assert.assertEquals((Object)options.getFilename(), (Object)"/bla/bla");
        Assert.assertTrue((boolean)Arrays.equals(options.getIndexes(), indexes));
        Assert.assertEquals((Object)((Object)options.getNormalize()), (Object)((Object)StringUtils.Mode.umlaut));
        Assert.assertEquals((Object)((Object)options.getDictType()), (Object)((Object)MorphDictionaryOptions.DictionaryType.suffix));
    }
}

