/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToBooleanCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import net.sf.saxon.expr.EquivalenceComparison;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;

public class EquivalenceComparisonCompiler
extends ToBooleanCompiler {
    @Override
    public void compileToBoolean(CompilerService compiler, Expression expression) throws CannotCompileException {
        EquivalenceComparison test = (EquivalenceComparison)expression;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        EquivalenceComparisonCompiler.visitAnnotation(compiler, "EquivalenceComparisonCompiler");
        EquivalenceComparisonCompiler.visitLineNumber(compiler, ga, expression);
        LabelInfo done = methodInfo.newLabel("EqCdone");
        LabelInfo returnFalse = methodInfo.newLabel("EqFalse");
        LabelInfo returnTrue = methodInfo.newLabel("EqTrue");
        int op0Var = methodInfo.allocateLocal(AtomicValue.class);
        int op1Var = methodInfo.allocateLocal(AtomicValue.class);
        compiler.compileToItem(test.getLhsExpression());
        ga.checkClass(AtomicValue.class);
        ga.storeLocal(op0Var);
        compiler.compileToItem(test.getRhsExpression());
        ga.checkClass(AtomicValue.class);
        ga.storeLocal(op1Var);
        if (Cardinality.allowsZero(test.getLhsExpression().getCardinality()) || Cardinality.allowsZero(test.getLhsExpression().getCardinality())) {
            LabelInfo op0Null = methodInfo.newLabel("op0Null");
            LabelInfo doneNullCheck = methodInfo.newLabel("doneNullCheck");
            ga.loadLocal(op0Var);
            ga.ifNull(op0Null.label());
            ga.loadLocal(op1Var);
            ga.ifNull(returnFalse.label());
            ga.goTo(doneNullCheck);
            methodInfo.placeLabel(op0Null);
            ga.loadLocal(op1Var);
            ga.ifNull(returnTrue.label());
            ga.goTo(returnFalse.label());
            methodInfo.placeLabel(doneNullCheck);
        }
        if (!test.isKnownToBeComparable()) {
            ga.loadLocal(op0Var);
            ga.invokeInstanceMethod(AtomicValue.class, "getPrimitiveType", new Class[0]);
            ga.loadLocal(op1Var);
            ga.invokeInstanceMethod(AtomicValue.class, "getPrimitiveType", new Class[0]);
            ga.push(false);
            ga.invokeStaticMethod(Type.class, "isGuaranteedComparable", BuiltInAtomicType.class, BuiltInAtomicType.class, Boolean.TYPE);
            ga.ifFalse(returnFalse);
        }
        EquivalenceComparisonCompiler.allocateStatic(compiler, test.getComparer());
        compiler.generateGetContext();
        ga.invokeInstanceMethod(AtomicComparer.class, "provideContext", XPathContext.class);
        ga.loadLocal(op0Var);
        ga.loadLocal(op1Var);
        ga.invokeInstanceMethod(AtomicComparer.class, "comparesEqual", AtomicValue.class, AtomicValue.class);
        ga.ifFalse(returnFalse);
        methodInfo.placeLabel(returnTrue);
        ga.push(true);
        ga.goTo(done);
        methodInfo.placeLabel(returnFalse);
        ga.push(false);
        methodInfo.placeLabel(done);
        methodInfo.releaseLocal(op0Var);
        methodInfo.releaseLocal(op1Var);
    }
}

