/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;

public class FeedToReceiver
extends ItemFeed {
    private Receiver receiver;
    private NoOpenCloseReceiver innerReceiver;

    public FeedToReceiver(Feed out, XPathContext context) {
        super(out, context);
    }

    @Override
    public PipelineConfiguration getPipelineConfiguration() {
        return this.getResult().getPipelineConfiguration();
    }

    @Override
    public SequenceReceiver getReceiver() {
        return this.innerReceiver;
    }

    public void setReceiver(SequenceReceiver out) {
        this.receiver = out;
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        this.getResult().open(terminator);
        this.receiver = this.getResult().getReceiver();
        this.innerReceiver = new NoOpenCloseReceiver(this.receiver);
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        return this.innerReceiver;
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
    }

    @Override
    public void processItem(Item<?> item) throws XPathException {
        this.receiver.append(item);
    }

    @Override
    public void close() throws XPathException {
        this.getResult().close();
    }

    private static class NoOpenCloseReceiver
    extends ProxyReceiver {
        public NoOpenCloseReceiver(Receiver nextReceiver) {
            super(nextReceiver);
        }

        @Override
        public void open() throws XPathException {
        }

        @Override
        public void close() throws XPathException {
        }
    }
}

