/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.jaxp;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.jaxp.SchemaReference;
import com.saxonica.ee.jaxp.URIResourceResolver;
import com.saxonica.ee.schema.sdoc.LSSchemaResolver;
import java.util.function.Supplier;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class SchemaFactoryImpl
extends SchemaFactory
implements Configuration.ApiProvider {
    public static final String XSD_LANGUAGE_IDENTIFIER = "http://www.w3.org/XML/XMLSchema";
    public static final String XSD10_LANGUAGE_IDENTIFIER = "http://www.w3.org/XML/XMLSchema/v1.0";
    public static final String XSD11_LANGUAGE_IDENTIFIER = "http://www.w3.org/XML/XMLSchema/v1.1";
    public static boolean ENABLED = true;
    private static Supplier<EnterpriseConfiguration> configurationFactory = EnterpriseConfiguration::new;
    static ErrorHandler DRACONIAN_ERROR_HANDLER = new ErrorHandler(){

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }
    };
    EnterpriseConfiguration config;
    ErrorListener errorListener;

    public SchemaFactoryImpl() {
        this.config = configurationFactory.get();
        this.config.setProcessor(this);
        this.setErrorHandler(DRACONIAN_ERROR_HANDLER);
    }

    public SchemaFactoryImpl(EnterpriseConfiguration config) {
        this.config = config;
        config.checkLicensedFeature(1, "schema processing", -1);
        this.errorListener = config.getErrorListener();
    }

    public static void setConfigurationFactory(Supplier<EnterpriseConfiguration> factory) {
        configurationFactory = factory;
    }

    @Override
    public boolean isSchemaLanguageSupported(String language) {
        if (!ENABLED) {
            return false;
        }
        boolean b = this.isSchemaLanguageSupportedX(language);
        if (System.getProperty("jaxp.debug") != null) {
            this.config.getStandardErrorOutput().println("Calling com.saxonica.SchemaFactoryImpl.isSchemaLanguageSupported(\"" + language + "\"); language supported? " + b);
        }
        if (b) {
            boolean licensed = this.config.isLicensedFeature(1);
            if (System.getProperty("jaxp.debug") != null) {
                this.config.getStandardErrorOutput().println("Is Saxon-EE schema validation licensed? " + licensed);
            }
            return licensed;
        }
        return false;
    }

    private boolean isSchemaLanguageSupportedX(String language) {
        if (language.equals(XSD11_LANGUAGE_IDENTIFIER)) {
            this.config.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", "1.1");
            return true;
        }
        if (language.equals(XSD10_LANGUAGE_IDENTIFIER)) {
            this.config.setConfigurationProperty("http://saxon.sf.net/feature/xsd-version", "1.0");
            return true;
        }
        return language.equals("http://www.w3.org/2001/XMLSchema") || language.equals(XSD_LANGUAGE_IDENTIFIER);
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            errorHandler = DRACONIAN_ERROR_HANDLER;
        }
        this.errorListener = new ErrorListenerWrappingErrorHandler(errorHandler);
    }

    @Override
    public ErrorHandler getErrorHandler() {
        if (this.errorListener instanceof ErrorListenerWrappingErrorHandler) {
            ErrorHandler eh = ((ErrorListenerWrappingErrorHandler)this.errorListener).getErrorHandler();
            return eh == DRACONIAN_ERROR_HANDLER ? null : eh;
        }
        return null;
    }

    @Override
    public void setResourceResolver(LSResourceResolver lsResourceResolver) {
        this.config.setURIResolver(new URIResourceResolver(lsResourceResolver));
        this.config.setSchemaURIResolver(new LSSchemaResolver(lsResourceResolver, this.config));
    }

    @Override
    public LSResourceResolver getResourceResolver() {
        URIResolver resolver = this.config.getURIResolver();
        if (resolver instanceof URIResourceResolver) {
            return ((URIResourceResolver)resolver).getLSResourceResolver();
        }
        return null;
    }

    @Override
    public Schema newSchema(Source[] sources) throws SAXException {
        try {
            for (Source source : sources) {
                this.config.addSchemaSource(source, this.errorListener);
            }
        }
        catch (SchemaException e) {
            throw SchemaFactoryImpl.toSAXException(e);
        }
        return new SchemaReference(this.config.getSuperSchema());
    }

    @Override
    public Schema newSchema() {
        return new SchemaReference(this.config.getSuperSchema());
    }

    @Override
    public Object getProperty(String name) throws SAXNotSupportedException {
        try {
            return this.config.getConfigurationProperty(name);
        }
        catch (IllegalArgumentException err) {
            throw new SAXNotSupportedException(err.getMessage());
        }
    }

    @Override
    public void setProperty(String name, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        try {
            this.config.setConfigurationProperty(name, object);
        }
        catch (IllegalArgumentException err) {
            throw new SAXNotSupportedException(err.getMessage());
        }
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://javax.xml.XMLConstants/feature/secure-processing".equals(name)) {
            return (Boolean)this.getConfiguration().getConfigurationProperty("http://saxon.sf.net/feature/parserFeature?uri=" + name);
        }
        return super.getFeature(name);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://javax.xml.XMLConstants/feature/secure-processing".equals(name)) {
            this.getConfiguration().setConfigurationProperty("http://saxon.sf.net/feature/parserFeature?uri=" + name, (Object)value);
        } else {
            super.setFeature(name, value);
        }
    }

    public EnterpriseConfiguration getConfiguration() {
        return this.config;
    }

    private static SAXParseException toSAXException(TransformerException err) {
        if (err.getException() instanceof SAXParseException) {
            return (SAXParseException)err.getException();
        }
        SourceLocator loc = err.getLocator();
        if (loc != null && !(loc instanceof Locator)) {
            loc = new ExplicitLocation(loc);
        }
        return new SAXParseException(err.getMessage(), (Locator)((Object)loc), err);
    }

    private static TransformerException toTransformerException(SAXException err) {
        if (err.getException() instanceof TransformerException) {
            return (TransformerException)err.getException();
        }
        return new TransformerException(err);
    }

    public static class ErrorListenerWrappingErrorHandler
    implements ErrorListener {
        private ErrorHandler handler;

        public ErrorListenerWrappingErrorHandler(ErrorHandler handler) {
            this.handler = handler;
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
            try {
                this.handler.warning(SchemaFactoryImpl.toSAXException(exception));
            }
            catch (SAXException e) {
                throw SchemaFactoryImpl.toTransformerException(e);
            }
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
            try {
                if (exception instanceof XPathException) {
                    if (((XPathException)exception).hasBeenReported()) {
                        return;
                    }
                    ((XPathException)exception).setHasBeenReported(true);
                }
                this.handler.error(SchemaFactoryImpl.toSAXException(exception));
            }
            catch (SAXException e) {
                throw SchemaFactoryImpl.toTransformerException(e);
            }
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            try {
                if (exception instanceof XPathException) {
                    if (((XPathException)exception).hasBeenReported()) {
                        return;
                    }
                    ((XPathException)exception).setHasBeenReported(true);
                }
                this.handler.fatalError(SchemaFactoryImpl.toSAXException(exception));
            }
            catch (SAXException e) {
                throw SchemaFactoryImpl.toTransformerException(e);
            }
        }

        public ErrorHandler getErrorHandler() {
            return this.handler;
        }
    }
}

