/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.ParentConstructorAdjunct;
import com.saxonica.ee.stream.feed.ComplexNodeEventFeed;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyBuilder;

public class DocumentInstrAdjunct
extends ParentConstructorAdjunct
implements FeedMaker {
    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        return new DocumentInstrFeed(this.getExpression(), out, context);
    }

    public static class DocumentInstrFeed
    extends ComplexNodeEventFeed {
        private Builder builder;

        public DocumentInstrFeed(Expression exp, Feed result, XPathContext context) {
            super(exp, result, context);
        }

        @Override
        protected void processLeft(XPathContext context) throws XPathException {
            DocumentInstr exp = (DocumentInstr)this.getExpression();
            try {
                Controller controller = context.getController();
                Configuration config = controller.getConfiguration();
                this.builder = controller.makeBuilder();
                if (this.builder instanceof TinyBuilder) {
                    ((TinyBuilder)this.builder).setStatistics(config.getTreeStatistics().SOURCE_DOCUMENT_STATISTICS);
                }
                this.builder.setBaseURI(exp.getStaticBaseURIString());
                this.builder.setTiming(false);
                PipelineConfiguration pipe = controller.makePipelineConfiguration();
                pipe.setXPathContext(context);
                pipe.setHostLanguage(50);
                this.builder.setPipelineConfiguration(pipe);
                Receiver out = ComplexContentOutputter.makeComplexContentReceiver(this.builder, exp.getValidationOptions());
                context.setReceiver(out);
                out.open();
                out.startDocument(0);
                this.setReceiver(out);
            }
            catch (XPathException e) {
                e.maybeSetLocation(exp.getLocation());
                e.maybeSetContext(context);
                this.dynamicError(e);
            }
        }

        @Override
        protected void processRight(XPathContext context) throws XPathException {
            this.getReceiver().endDocument();
            this.getResult().processItem(this.builder.getCurrentRoot());
        }
    }
}

