/*
 * Decompiled with CFR 0.152.
 */
package marmot.util;

import java.util.List;

public class GeneralLevenshteinLattice<T> {
    protected int[][] cost_lattice_;
    protected short[][] op_lattice_;
    protected static final short START = 1;
    protected static final short INSERT = 2;
    protected static final short DELETE = 4;
    protected static final short COPY = 8;
    protected static final short REPLACE = 16;
    protected List<T> input_;
    protected List<T> output_;
    protected int replace_cost_;
    protected int insert_cost_;
    protected int delete_cost_;
    private boolean initialized_;

    public GeneralLevenshteinLattice(List<T> input, List<T> output) {
        this(input, output, 1, 1, 2);
    }

    public GeneralLevenshteinLattice(List<T> input, List<T> output, int insert_cost, int delete_cost, int replace_cost) {
        this.input_ = input;
        this.output_ = output;
        this.replace_cost_ = replace_cost;
        this.insert_cost_ = insert_cost;
        this.delete_cost_ = delete_cost;
        this.initialized_ = false;
    }

    protected void init() {
        if (!this.initialized_) {
            this.fillLattice();
        }
        this.initialized_ = true;
    }

    protected int min(int a, int b, int c) {
        return Math.min(a, Math.min(b, c));
    }

    protected void fillLattice() {
        int input_index;
        int input_length = this.input_.size();
        int output_length = this.output_.size();
        this.cost_lattice_ = new int[input_length + 1][output_length + 1];
        this.op_lattice_ = new short[input_length + 1][output_length + 1];
        this.op_lattice_[0][0] = 1;
        for (input_index = 1; input_index <= input_length; ++input_index) {
            this.cost_lattice_[input_index][0] = this.delete_cost_ * input_index;
            this.op_lattice_[input_index][0] = 4;
        }
        for (int output_index = 1; output_index <= output_length; ++output_index) {
            this.cost_lattice_[0][output_index] = this.insert_cost_ * output_index;
            this.op_lattice_[0][output_index] = 2;
        }
        for (input_index = 1; input_index <= input_length; ++input_index) {
            T current_input = this.input_.get(input_index - 1);
            for (int output_index = 1; output_index <= output_length; ++output_index) {
                int minimal_cost;
                int diag_cost;
                int diag_op;
                T current_output = this.output_.get(output_index - 1);
                if (current_input.equals(current_output)) {
                    diag_op = 8;
                    diag_cost = this.getCopyCost(input_index);
                } else {
                    diag_op = 16;
                    diag_cost = this.getReplaceCost(current_input, current_output);
                }
                int minimal_diag_cost = this.cost_lattice_[input_index - 1][output_index - 1] + diag_cost;
                int minimal_delete_cost = this.cost_lattice_[input_index - 1][output_index] + this.delete_cost_;
                int minimal_insert_cost = this.cost_lattice_[input_index][output_index - 1] + this.insert_cost_;
                this.cost_lattice_[input_index][output_index] = minimal_cost = this.min(minimal_delete_cost, minimal_insert_cost, minimal_diag_cost);
                int minimal_cost_op = 0;
                if (minimal_cost == minimal_diag_cost) {
                    minimal_cost_op = (short)(minimal_cost_op | diag_op);
                }
                if (minimal_cost == minimal_delete_cost) {
                    minimal_cost_op = (short)(minimal_cost_op | 4);
                }
                if (minimal_cost == minimal_insert_cost) {
                    minimal_cost_op = (short)(minimal_cost_op | 2);
                }
                this.op_lattice_[input_index][output_index] = minimal_cost_op;
            }
        }
    }

    protected int getCopyCost(int input_index) {
        return 0;
    }

    protected int getReplaceCost(T input, T output) {
        return this.replace_cost_;
    }

    public int getDistance() {
        this.init();
        return this.cost_lattice_[this.input_.size()][this.output_.size()];
    }
}

