/*
 * Decompiled with CFR 0.152.
 */
package marmot.util;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class Cache<K, V> {
    protected int current_time_ = 0;
    protected Map<K, CacheEntry> storage_ = new HashMap<K, CacheEntry>();

    public void put(K key, V value) {
        CacheEntry entry = new CacheEntry(value, this.current_time_);
        this.storage_.put(key, entry);
    }

    public V get(K key) {
        ++this.current_time_;
        CacheEntry entry = this.storage_.get(key);
        if (entry == null) {
            return null;
        }
        entry.setTime(this.current_time_);
        return entry.getValue();
    }

    public void cleanup(int delta) {
        LinkedList<K> list = new LinkedList<K>();
        for (Map.Entry<K, CacheEntry> entry : this.storage_.entrySet()) {
            CacheEntry centry = entry.getValue();
            if (this.current_time_ - centry.getTime() <= delta) continue;
            list.add(entry.getKey());
        }
        for (Map.Entry<K, CacheEntry> key : list) {
            this.storage_.remove(key);
        }
    }

    class CacheEntry {
        protected V value_;
        protected int time_;

        public CacheEntry(V value, int time) {
            this.time_ = time;
            this.value_ = value;
        }

        public void setTime(int time) {
            this.time_ = time;
        }

        public V getValue() {
            return this.value_;
        }

        public int getTime() {
            return this.time_;
        }
    }
}

