/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.xom;

import java.util.ArrayList;
import java.util.Stack;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.option.xom.XOMDocumentWrapper;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.IllegalNameException;
import nu.xom.MalformedURIException;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.ParentNode;

public class XOMWriter
extends Builder {
    private Document document;
    private final Stack<ParentNode> ancestors = new Stack();
    private final Stack<NamespaceMap> nsStack = new Stack();
    private final NodeFactory nodeFactory;
    private boolean implicitDocumentNode = false;
    private final StringBuilder textBuffer = new StringBuilder(64);

    public XOMWriter(PipelineConfiguration pipe) {
        super(pipe);
        this.nodeFactory = new NodeFactory();
        this.nsStack.push(NamespaceMap.emptyMap());
    }

    public XOMWriter(PipelineConfiguration pipe, NodeFactory factory) {
        super(pipe);
        this.nodeFactory = factory;
        this.nsStack.push(NamespaceMap.emptyMap());
    }

    @Override
    public void setUnparsedEntity(String name, String systemID, String publicID) throws XPathException {
    }

    @Override
    public void open() {
    }

    @Override
    public void close() {
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        this.document = this.nodeFactory.startMakingDocument();
        try {
            this.document.setBaseURI(this.systemId);
        }
        catch (MalformedURIException e) {
            throw new XPathException(e);
        }
        this.ancestors.push((ParentNode)this.document);
        this.textBuffer.setLength(0);
    }

    @Override
    public void endDocument() throws XPathException {
        this.nodeFactory.finishMakingDocument(this.document);
        this.ancestors.pop();
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        Element element;
        this.flush();
        String qname = elemName.getDisplayName();
        NamespaceUri uri = elemName.getNamespaceUri();
        if (this.ancestors.isEmpty()) {
            this.startDocument(0);
            this.implicitDocumentNode = true;
        }
        if (this.ancestors.size() == 1) {
            element = this.nodeFactory.makeRootElement(qname, uri.toString());
            this.document.setRootElement(element);
            int c = this.document.getChildCount();
            if (c > 1) {
                int i;
                ArrayList<Node> otherChildren = new ArrayList<Node>(c);
                for (i = 1; i < c; ++i) {
                    Node n = this.document.removeChild(1);
                    otherChildren.add(n);
                }
                for (i = 0; i < otherChildren.size(); ++i) {
                    this.document.insertChild((Node)otherChildren.get(i), i);
                }
            }
        } else {
            element = this.nodeFactory.startMakingElement(qname, uri.toString());
        }
        if (element == null) {
            throw new XPathException("XOM node factory returned null");
        }
        this.ancestors.push((ParentNode)element);
        NamespaceMap parentNamespaces = this.nsStack.peek();
        if (namespaces != parentNamespaces) {
            NamespaceBinding[] declarations;
            for (NamespaceBinding ns : declarations = namespaces.getDifferences(parentNamespaces, false)) {
                String nsprefix = ns.getPrefix();
                String nsuri = ns.getNamespaceUri().toString();
                try {
                    element.addNamespaceDeclaration(nsprefix, nsuri);
                }
                catch (MalformedURIException e) {
                    throw new XPathException("XOM requires namespace names to be legal URIs: " + uri);
                }
            }
        }
        this.nsStack.push(namespaces);
        for (AttributeInfo att : attributes) {
            Nodes nodes;
            String attqname = att.getNodeName().getDisplayName();
            NamespaceUri atturi = att.getNodeName().getNamespaceUri();
            try {
                nodes = this.nodeFactory.makeAttribute(attqname, atturi.toString(), att.getValue(), Attribute.Type.CDATA);
            }
            catch (IllegalNameException e) {
                throw new XPathException(e.getMessage());
            }
            for (int n = 0; n < nodes.size(); ++n) {
                Node node = nodes.get(n);
                if (node instanceof Attribute) {
                    element.addAttribute((Attribute)node);
                    continue;
                }
                element.appendChild(node);
            }
        }
    }

    @Override
    public void endElement() throws XPathException {
        this.flush();
        this.nsStack.pop();
        Element element = (Element)this.ancestors.pop();
        Node parent = (Node)this.ancestors.peek();
        Nodes nodes = this.nodeFactory.finishMakingElement(element);
        if (parent == this.document) {
            if (this.implicitDocumentNode) {
                this.endDocument();
            }
        } else {
            for (int n = 0; n < nodes.size(); ++n) {
                Node node = nodes.get(n);
                if (node instanceof Attribute) {
                    ((Element)parent).addAttribute((Attribute)node);
                    continue;
                }
                ((Element)parent).appendChild(node);
            }
        }
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        this.textBuffer.append(chars);
    }

    private void flush() {
        if (this.textBuffer.length() != 0) {
            Nodes nodes = this.nodeFactory.makeText(this.textBuffer.toString());
            for (int n = 0; n < nodes.size(); ++n) {
                Node node = nodes.get(n);
                if (node instanceof Attribute) {
                    ((Element)this.ancestors.peek()).addAttribute((Attribute)node);
                    continue;
                }
                this.ancestors.peek().appendChild(node);
            }
            this.textBuffer.setLength(0);
        }
    }

    @Override
    public void processingInstruction(String target, UnicodeString data, Location locationId, int properties) throws XPathException {
        this.flush();
        Nodes nodes = this.nodeFactory.makeProcessingInstruction(target, data.toString());
        for (int n = 0; n < nodes.size(); ++n) {
            Node node = nodes.get(n);
            if (node instanceof Attribute) {
                ((Element)this.ancestors.peek()).addAttribute((Attribute)node);
                continue;
            }
            this.ancestors.peek().appendChild(node);
        }
    }

    @Override
    public void comment(UnicodeString chars, Location locationId, int properties) throws XPathException {
        this.flush();
        Nodes nodes = this.nodeFactory.makeComment(chars.toString());
        for (int n = 0; n < nodes.size(); ++n) {
            Node node = nodes.get(n);
            if (node instanceof Attribute) {
                ((Element)this.ancestors.peek()).addAttribute((Attribute)node);
                continue;
            }
            this.ancestors.peek().appendChild(node);
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return false;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public NodeInfo getCurrentRoot() {
        return new XOMDocumentWrapper((Node)this.document, this.config);
    }
}

