/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.constants.RelationDirection;
import de.ids_mannheim.korap.query.SpanRelationQuery;
import de.ids_mannheim.korap.query.spans.CandidateSpan;
import de.ids_mannheim.korap.query.spans.RelationBaseSpans;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.util.Bits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationSpans
extends RelationBaseSpans {
    private static final boolean DEBUG = false;
    private int currentDoc;
    private int currentPosition;
    private RelationDirection direction;
    private Spans relationTermSpan;
    protected Logger logger = LoggerFactory.getLogger(RelationSpans.class);
    private List<CandidateSpan> candidateList;
    private byte tempSourceNum;
    private byte tempTargetNum;
    private byte sourceClass;
    private byte targetClass;

    public RelationSpans(SpanRelationQuery relationSpanQuery, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(relationSpanQuery, context, acceptDocs, termContexts);
        this.direction = relationSpanQuery.getDirection();
        this.tempSourceNum = relationSpanQuery.getTempSourceNum();
        this.tempTargetNum = relationSpanQuery.getTempTargetNum();
        this.sourceClass = relationSpanQuery.getSourceClass();
        this.targetClass = relationSpanQuery.getTargetClass();
        this.candidateList = new ArrayList<CandidateSpan>();
        this.relationTermSpan = this.firstSpans;
        this.hasMoreSpans = this.relationTermSpan.next();
    }

    @Override
    public boolean next() throws IOException {
        this.isStartEnumeration = false;
        return this.advance();
    }

    private boolean advance() throws IOException {
        while (this.hasMoreSpans || !this.candidateList.isEmpty()) {
            if (!this.candidateList.isEmpty()) {
                CandidateSpan cs = this.candidateList.get(0);
                this.matchDocNumber = cs.getDoc();
                this.matchStartPosition = cs.getStart();
                this.matchEndPosition = cs.getEnd();
                this.matchPayload = cs.getPayloads();
                this.setRightStart(cs.getRightStart());
                this.setRightEnd(cs.getRightEnd());
                this.spanId = cs.getSpanId();
                this.leftId = cs.getLeftId();
                this.rightId = cs.getRightId();
                this.candidateList.remove(0);
                return true;
            }
            this.setCandidateList();
            if (!this.hasMoreSpans) continue;
            this.currentDoc = this.relationTermSpan.doc();
            this.currentPosition = this.relationTermSpan.start();
        }
        return false;
    }

    private void setCandidateList() throws IOException {
        while (this.hasMoreSpans && this.relationTermSpan.doc() == this.currentDoc && this.relationTermSpan.start() == this.currentPosition) {
            CandidateSpan cs = new CandidateSpan(this.relationTermSpan);
            this.readPayload(cs);
            this.setPayload(cs);
            this.candidateList.add(cs);
            this.hasMoreSpans = this.relationTermSpan.next();
        }
        Collections.sort(this.candidateList);
    }

    private void readPayload(CandidateSpan cs) {
        List payload = (List)cs.getPayloads();
        int length = ((byte[])payload.get(0)).length;
        ByteBuffer bb = ByteBuffer.allocate(length);
        bb.put((byte[])payload.get(0));
        cs.setLeftStart(cs.start);
        this.payloadTypeIdentifier = bb.get(0);
        if (this.payloadTypeIdentifier == PayloadTypeIdentifier.TERM_TO_TERM.value) {
            int i = bb.getInt(1);
            cs.setLeftEnd(cs.start + 1);
            cs.setRightStart(i);
            cs.setRightEnd(i + 1);
            if (length > 5) {
                cs.setLeftId(bb.getShort(5));
                cs.setRightId(bb.getShort(7));
                cs.setSpanId(bb.getShort(9));
            }
        } else if (this.payloadTypeIdentifier == PayloadTypeIdentifier.TERM_TO_ELEMENT.value) {
            cs.setLeftEnd(cs.start + 1);
            cs.setRightStart(bb.getInt(9));
            cs.setRightEnd(bb.getInt(13));
            if (length > 17) {
                cs.setLeftId(bb.getShort(17));
                cs.setRightId(bb.getShort(19));
                cs.setSpanId(bb.getShort(21));
            }
        } else if (this.payloadTypeIdentifier == PayloadTypeIdentifier.ELEMENT_TO_TERM.value) {
            cs.setEnd(bb.getInt(9));
            cs.setLeftEnd(cs.end);
            int i = bb.getInt(13);
            cs.setRightStart(i);
            cs.setRightEnd(i + 1);
            if (length > 17) {
                cs.setLeftId(bb.getShort(17));
                cs.setRightId(bb.getShort(19));
                cs.setSpanId(bb.getShort(21));
            }
        } else if (this.payloadTypeIdentifier == PayloadTypeIdentifier.ELEMENT_TO_ELEMENT.value) {
            cs.setEnd(bb.getInt(17));
            cs.setLeftEnd(cs.end);
            cs.setRightStart(bb.getInt(21));
            cs.setRightEnd(bb.getInt(25));
            if (length > 28) {
                cs.setLeftId(bb.getShort(29));
                cs.setRightId(bb.getShort(31));
                cs.setSpanId(bb.getShort(33));
            }
        }
    }

    private void setPayload(CandidateSpan cs) throws IOException {
        ArrayList<byte[]> payload = new ArrayList<byte[]>();
        if (this.relationTermSpan.isPayloadAvailable()) {
            payload.addAll(this.relationTermSpan.getPayload());
        }
        if (this.direction.equals((Object)RelationDirection.RIGHT)) {
            payload.add(this.createClassPayload(cs.getLeftStart(), cs.getLeftEnd(), this.tempSourceNum, false));
            payload.add(this.createClassPayload(cs.getRightStart(), cs.getRightEnd(), this.tempTargetNum, false));
            if (this.sourceClass > 0) {
                payload.add(this.createClassPayload(cs.getLeftStart(), cs.getLeftEnd(), this.sourceClass, true));
            }
            if (this.targetClass > 0) {
                payload.add(this.createClassPayload(cs.getRightStart(), cs.getRightEnd(), this.targetClass, true));
            }
        } else {
            payload.add(this.createClassPayload(cs.getRightStart(), cs.getRightEnd(), this.tempSourceNum, false));
            payload.add(this.createClassPayload(cs.getLeftStart(), cs.getLeftEnd(), this.tempTargetNum, false));
            if (this.sourceClass > 0) {
                payload.add(this.createClassPayload(cs.getRightStart(), cs.getRightEnd(), this.sourceClass, true));
            }
            if (this.targetClass > 0) {
                payload.add(this.createClassPayload(cs.getLeftStart(), cs.getLeftEnd(), this.targetClass, true));
            }
        }
        cs.setPayloads(payload);
    }

    private byte[] createClassPayload(int start, int end, byte classNumber, boolean keep) {
        ByteBuffer buffer = null;
        buffer = keep ? ByteBuffer.allocate(10) : ByteBuffer.allocate(11);
        Byte classPTI = 0;
        buffer.put(classPTI);
        buffer.putInt(start);
        buffer.putInt(end);
        buffer.put(classNumber);
        return buffer.array();
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (this.hasMoreSpans && this.firstSpans.doc() < target && !this.firstSpans.skipTo(target)) {
            this.candidateList.clear();
            return false;
        }
        this.setCandidateList();
        this.matchPayload.clear();
        this.isStartEnumeration = false;
        return this.advance();
    }

    @Override
    public long cost() {
        return this.firstSpans.cost();
    }

    @Override
    public int getRightStart() {
        return this.rightStart;
    }

    @Override
    public void setRightStart(int rightStart) {
        this.rightStart = rightStart;
    }

    @Override
    public int getRightEnd() {
        return this.rightEnd;
    }

    @Override
    public void setRightEnd(int rightEnd) {
        this.rightEnd = rightEnd;
    }

    public byte getTempSourceNum() {
        return this.tempSourceNum;
    }

    public void setTempSourceNum(byte tempSourceNum) {
        this.tempSourceNum = tempSourceNum;
    }

    public byte getTempTargetNum() {
        return this.tempTargetNum;
    }

    public void setTempTargetNum(byte tempTargetNum) {
        this.tempTargetNum = tempTargetNum;
    }

    public RelationDirection getDirection() {
        return this.direction;
    }

    public void setDirection(RelationDirection direction) {
        this.direction = direction;
    }

    public static enum PayloadTypeIdentifier {
        TERM_TO_TERM(32),
        TERM_TO_ELEMENT(33),
        ELEMENT_TO_TERM(34),
        ELEMENT_TO_ELEMENT(35);

        private byte value;

        private PayloadTypeIdentifier(int value) {
            this.value = (byte)value;
        }
    }
}

