/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph;

import java.util.Arrays;
import java.util.Collection;
import lemming.lemma.ranker.RankerModel;
import marmot.core.ArrayFloatFeatureVector;
import marmot.core.FeatureVector;
import marmot.core.FloatFeatureVector;
import marmot.core.FloatWeights;
import marmot.core.Model;
import marmot.core.Sequence;
import marmot.core.State;
import marmot.core.WeightVector;
import marmot.morph.FloatHashDictionary;
import marmot.morph.MorphDictionary;
import marmot.morph.MorphDictionaryOptions;
import marmot.morph.MorphFeatureVector;
import marmot.morph.MorphModel;
import marmot.morph.MorphOptions;
import marmot.morph.Word;
import marmot.util.Encoder;
import marmot.util.FeatureTable;

public class MorphWeightVector
implements WeightVector,
FloatWeights {
    private static final long serialVersionUID = 1L;
    private int max_affix_length_;
    private int num_state_features_;
    private static final int ENCODER_CAPACITY_ = 10;
    private boolean use_hash_vector;
    private transient Encoder encoder_;
    private double accumulated_penalty_;
    private transient double[] accumulated_penalties_;
    private transient double[] accumulated_float_penalties_;
    private double[] weights_;
    private double[] float_weights_;
    private boolean extend_feature_set_;
    private MorphModel model_;
    private FeatureTable feature_table_;
    private int simple_sub_morph_start_index_;
    private int signature_bits_;
    private int word_bits_;
    private int[] tag_bits_;
    private int state_feature_bits_;
    private int char_bits_;
    private int shape_bits_;
    private int order_bits_;
    private int[] num_tags_;
    private int total_num_tags_;
    private int level_bits_;
    private int max_level_;
    private double scale_factor_;
    private boolean shape_;
    private int initial_vector_size_;
    private int token_feature_bits_;
    private int max_transition_feature_level_;
    private MorphDictionary mdict_;
    private FloatHashDictionary fdict_;
    private int mdict_bits_;
    private boolean use_state_features_;
    private boolean use_form_feature_;
    private boolean use_rare_feature_;
    private boolean use_lexical_context_feature_;
    private boolean use_affix_features_;
    private boolean use_signature_features_;
    private boolean use_infix_features_;
    private boolean use_bigrams_;
    private boolean use_hash_feature_table_;

    public MorphWeightVector(MorphOptions options) {
        this.shape_ = options.getShape();
        this.max_transition_feature_level_ = options.getMaxTransitionFeatureLevel();
        this.initial_vector_size_ = options.getInitialVectorSize();
        this.use_state_features_ = options.getUseDefaultFeatures();
        this.use_hash_vector = options.getUseHashVector();
        this.max_affix_length_ = options.getMaxAffixLength();
        this.use_hash_feature_table_ = options.getUseHashFeatureTable();
        this.use_form_feature_ = true;
        this.use_rare_feature_ = true;
        this.use_lexical_context_feature_ = true;
        this.use_affix_features_ = true;
        this.use_signature_features_ = true;
        this.use_infix_features_ = false;
        this.use_bigrams_ = true;
        String feature_template = options.getFeatureTemplates();
        if (feature_template != null) {
            this.use_form_feature_ = false;
            this.use_rare_feature_ = false;
            this.use_lexical_context_feature_ = false;
            this.use_affix_features_ = false;
            this.use_signature_features_ = false;
            this.use_bigrams_ = false;
            String[] stringArray = feature_template.toLowerCase().split(",");
            int n = stringArray.length;
            block18: for (int i = 0; i < n; ++i) {
                String feat;
                switch (feat = stringArray[i]) {
                    case "form": {
                        this.use_form_feature_ = true;
                        continue block18;
                    }
                    case "affix": {
                        this.use_affix_features_ = true;
                        continue block18;
                    }
                    case "rare": {
                        this.use_rare_feature_ = true;
                        continue block18;
                    }
                    case "context": {
                        this.use_lexical_context_feature_ = true;
                        continue block18;
                    }
                    case "sig": {
                        this.use_signature_features_ = true;
                        continue block18;
                    }
                    case "bigrams": {
                        this.use_bigrams_ = true;
                        continue block18;
                    }
                    case "infix": {
                        this.use_infix_features_ = true;
                        continue block18;
                    }
                    default: {
                        throw new RuntimeException("Unknown value: " + feat);
                    }
                }
            }
        }
        if (!this.use_state_features_) {
            this.use_form_feature_ = false;
            this.use_rare_feature_ = false;
            this.use_lexical_context_feature_ = false;
            this.use_affix_features_ = false;
            this.use_signature_features_ = false;
            this.use_bigrams_ = false;
        }
        if (!options.getMorphDict().isEmpty()) {
            this.mdict_ = MorphDictionary.create(options.getMorphDict());
            this.mdict_bits_ = Encoder.bitsNeeded(this.mdict_.numTags());
        }
        this.num_state_features_ = 0;
        if (this.use_form_feature_) {
            ++this.num_state_features_;
        }
        if (this.use_rare_feature_) {
            ++this.num_state_features_;
        }
        if (this.use_affix_features_) {
            this.num_state_features_ += 2;
        }
        if (this.use_lexical_context_feature_) {
            this.num_state_features_ += 2;
        }
        if (this.use_signature_features_) {
            ++this.num_state_features_;
        }
        if (this.shape_) {
            this.num_state_features_ += 3;
        }
        if (this.mdict_ != null) {
            ++this.num_state_features_;
        }
        if (this.use_infix_features_) {
            ++this.num_state_features_;
        }
        ++this.num_state_features_;
        if (!options.getFloatTypeDict().isEmpty()) {
            this.fdict_ = new FloatHashDictionary();
            MorphDictionaryOptions opt = MorphDictionaryOptions.parse(options.getFloatTypeDict(), false);
            if (opt.getIndexes() == null) {
                int[] indexes = new int[]{0};
                opt.setIndexes(indexes);
            }
            this.fdict_.init(opt);
        }
    }

    @Override
    public void setExtendFeatureSet(boolean flag) {
        this.extend_feature_set_ = flag;
    }

    @Override
    public void setPenalty(boolean penalize, double accumulated_penalty) {
        if (!penalize) {
            this.accumulated_penalties_ = null;
            this.accumulated_float_penalties_ = null;
            this.accumulated_penalty_ = 0.0;
        } else {
            this.accumulated_penalty_ = accumulated_penalty / this.scale_factor_;
            if (this.accumulated_penalties_ == null) {
                this.accumulated_penalties_ = new double[this.weights_.length];
            }
            if (this.accumulated_float_penalties_ == null && this.float_weights_ != null) {
                this.accumulated_float_penalties_ = new double[this.float_weights_.length];
            }
        }
        RankerModel model = this.model_.getLemmaModel();
        if (model != null) {
            model.setPenalty(penalize, accumulated_penalty);
        }
    }

    @Override
    public FeatureVector extractStateFeatures(State state) {
        this.prepareEncoder();
        MorphFeatureVector new_vector = new MorphFeatureVector(1 + state.getLevel(), state.getVector());
        int fc = 0;
        this.encoder_.append(0, this.order_bits_);
        this.encoder_.append(state.getLevel() + 1, this.level_bits_);
        this.encoder_.append(fc, 2);
        for (State run = state.getZeroOrderState(); run != null; run = run.getSubLevelState()) {
            this.encoder_.append(run.getLevel(), this.level_bits_);
            this.encoder_.append(run.getIndex(), this.tag_bits_[run.getLevel()]);
            this.addFeature(new_vector);
        }
        this.encoder_.reset();
        ++fc;
        new_vector.setIsState(true);
        new_vector.setWordIndex(((MorphFeatureVector)state.getVector()).getWordIndex());
        return new_vector;
    }

    @Override
    public FeatureVector extractStateFeatures(Sequence sequence, int token_index) {
        int[] token_feature_indexes;
        this.prepareEncoder();
        Word word = (Word)sequence.get(token_index);
        int[] mdict_indexes = null;
        if (this.mdict_ != null) {
            mdict_indexes = this.mdict_.getIndexes(word.getWordForm());
        }
        short[] chars = word.getCharIndexes();
        assert (chars != null);
        int form_index = word.getWordFormIndex();
        boolean is_rare = this.model_.isRare(form_index);
        MorphFeatureVector features = new MorphFeatureVector(20);
        int fc = 0;
        if (this.use_state_features_) {
            short c;
            int position;
            if (this.use_form_feature_) {
                if (form_index >= 0) {
                    this.encoder_.append(0, this.order_bits_);
                    this.encoder_.append(0, this.level_bits_);
                    this.encoder_.append(fc, this.state_feature_bits_);
                    this.encoder_.append(form_index, this.word_bits_);
                    this.addFeature(features);
                    this.encoder_.reset();
                }
                ++fc;
            }
            if (this.use_rare_feature_) {
                this.encoder_.append(0, this.order_bits_);
                this.encoder_.append(0, this.level_bits_);
                this.encoder_.append(fc, this.state_feature_bits_);
                this.encoder_.append(is_rare);
                this.addFeature(features);
                this.encoder_.reset();
                ++fc;
            }
            if (this.shape_) {
                int shape_index = -1;
                shape_index = word.getWordShapeIndex();
                if (is_rare && shape_index >= 0) {
                    this.encoder_.append(0, this.order_bits_);
                    this.encoder_.append(0, this.level_bits_);
                    this.encoder_.append(fc, this.state_feature_bits_);
                    this.encoder_.append(shape_index, this.shape_bits_);
                    this.addFeature(features);
                    this.encoder_.reset();
                }
                ++fc;
            }
            if (token_index - 1 >= 0) {
                int pform_index = ((Word)sequence.get(token_index - 1)).getWordFormIndex();
                if (this.use_lexical_context_feature_ && pform_index >= 0) {
                    this.encoder_.append(0, this.order_bits_);
                    this.encoder_.append(0, this.level_bits_);
                    this.encoder_.append(fc, this.state_feature_bits_);
                    this.encoder_.append(pform_index, this.word_bits_);
                    this.addFeature(features);
                    if (form_index >= 0 && this.use_bigrams_) {
                        this.encoder_.append(form_index, this.word_bits_);
                        this.addFeature(features);
                    }
                    this.encoder_.reset();
                }
                int pshape_index = -1;
                if (this.shape_) {
                    pshape_index = ((Word)sequence.get(token_index - 1)).getWordShapeIndex();
                }
                if (pshape_index >= 0) {
                    this.encoder_.append(0, this.order_bits_);
                    this.encoder_.append(0, this.level_bits_);
                    this.encoder_.append(fc + 1, this.state_feature_bits_);
                    this.encoder_.append(pshape_index, this.shape_bits_);
                    if (this.model_.isRare(pform_index)) {
                        this.addFeature(features);
                    }
                    this.encoder_.reset();
                }
            }
            if (this.use_lexical_context_feature_) {
                ++fc;
            }
            if (this.shape_) {
                ++fc;
            }
            if (token_index + 1 < sequence.size()) {
                int nform_index = ((Word)sequence.get(token_index + 1)).getWordFormIndex();
                if (this.use_lexical_context_feature_ && nform_index >= 0) {
                    this.encoder_.append(0, this.order_bits_);
                    this.encoder_.append(0, this.level_bits_);
                    this.encoder_.append(fc, this.state_feature_bits_);
                    this.encoder_.append(nform_index, this.word_bits_);
                    this.addFeature(features);
                    if (form_index >= 0 && this.use_bigrams_) {
                        this.encoder_.append(form_index, this.word_bits_);
                        this.addFeature(features);
                    }
                    this.encoder_.reset();
                }
                int nshape_index = -1;
                if (this.shape_) {
                    nshape_index = ((Word)sequence.get(token_index + 1)).getWordShapeIndex();
                }
                if (nshape_index >= 0) {
                    this.encoder_.append(0, this.order_bits_);
                    this.encoder_.append(0, this.level_bits_);
                    this.encoder_.append(fc + 1, this.state_feature_bits_);
                    this.encoder_.append(nshape_index, this.shape_bits_);
                    if (this.model_.isRare(nform_index)) {
                        this.addFeature(features);
                    }
                    this.encoder_.reset();
                }
            }
            if (this.use_lexical_context_feature_) {
                ++fc;
            }
            if (this.shape_) {
                ++fc;
            }
            if (this.use_signature_features_) {
                if (is_rare) {
                    int signature = word.getWordSignature();
                    this.encoder_.append(0, this.order_bits_);
                    this.encoder_.append(0, this.level_bits_);
                    this.encoder_.append(fc, this.state_feature_bits_);
                    this.encoder_.append(signature, this.signature_bits_);
                    this.addFeature(features);
                    this.encoder_.reset();
                }
                ++fc;
            }
            if (this.use_infix_features_) {
                if (is_rare) {
                    assert (chars != null);
                    this.encoder_.append(0, this.order_bits_);
                    this.encoder_.append(0, this.level_bits_);
                    this.encoder_.append(fc, this.state_feature_bits_);
                    for (position = 0; position < chars.length; ++position) {
                        short c2;
                        int end_position;
                        for (int length = 0; length < this.max_affix_length_ && (end_position = position + length) < chars.length && (c2 = chars[end_position]) >= 0; ++length) {
                            this.encoder_.append(c2, this.char_bits_);
                            this.addFeature(features);
                        }
                        this.encoder_.reset();
                    }
                }
                ++fc;
            }
            if (this.use_affix_features_) {
                if (is_rare) {
                    this.encoder_.append(0, this.order_bits_);
                    this.encoder_.append(0, this.level_bits_);
                    this.encoder_.append(fc, this.state_feature_bits_);
                    for (position = 0; position < Math.min(chars.length, this.max_affix_length_); ++position) {
                        assert (chars != null);
                        c = chars[position];
                        if (c < 0) break;
                        this.encoder_.append(c, this.char_bits_);
                        this.addFeature(features);
                    }
                    this.encoder_.reset();
                }
                ++fc;
            }
            if (this.use_affix_features_) {
                if (is_rare) {
                    this.encoder_.append(0, this.order_bits_);
                    this.encoder_.append(0, this.level_bits_);
                    this.encoder_.append(fc, this.state_feature_bits_);
                    for (position = 0; position < Math.min(chars.length, this.max_affix_length_) && (c = chars[chars.length - position - 1]) >= 0; ++position) {
                        this.encoder_.append(c, this.char_bits_);
                        this.addFeature(features);
                    }
                    this.encoder_.reset();
                }
                ++fc;
            }
        }
        if ((token_feature_indexes = word.getTokenFeatureIndexes()) != null) {
            for (int token_feature_index : token_feature_indexes) {
                if (token_feature_index < 0) continue;
                this.encoder_.append(0, this.order_bits_);
                this.encoder_.append(0, this.level_bits_);
                this.encoder_.append(fc, this.state_feature_bits_);
                this.encoder_.append(token_feature_index, this.token_feature_bits_);
                this.addFeature(features);
                this.encoder_.reset();
            }
            ++fc;
        }
        if (this.fdict_ != null) {
            FloatFeatureVector vector = this.extractFloatFeatures(sequence, token_index);
            features.setFloatVector(vector);
        } else {
            token_feature_indexes = word.getWeightedTokenFeatureIndexes();
            if (token_feature_indexes != null) {
                features.setFloatVector(new ArrayFloatFeatureVector(token_feature_indexes, word.getWeightedTokenFeatureWeights(), this.model_.getWeightedTokenFeatureTable().size()));
            }
        }
        if (this.mdict_ != null) {
            if (mdict_indexes != null) {
                for (int index : mdict_indexes) {
                    if (index < 0) continue;
                    this.encoder_.append(0, this.order_bits_);
                    this.encoder_.append(0, this.level_bits_);
                    this.encoder_.append(fc, this.state_feature_bits_);
                    this.encoder_.append(index, this.mdict_bits_);
                    this.addFeature(features);
                    this.encoder_.reset();
                }
            }
            ++fc;
        }
        features.setIsState(true);
        features.setWordIndex(form_index);
        assert (fc == this.num_state_features_ || fc + 1 == this.num_state_features_) : String.format("%d != %d", fc, this.num_state_features_);
        return features;
    }

    private void addFeature(FeatureVector features) {
        int index = this.feature_table_.getFeatureIndex(this.encoder_, this.extend_feature_set_);
        if (index >= 0) {
            features.add(index);
        }
    }

    private FloatFeatureVector extractFloatFeatures(Sequence sentence, int token_index) {
        FloatFeatureVector current_vector = null;
        if (token_index >= 0 && token_index < sentence.size()) {
            String form = ((Word)sentence.get(token_index)).getWordForm();
            current_vector = this.fdict_.getVector(form);
        }
        return current_vector;
    }

    @Override
    public FeatureVector extractTransitionFeatures(State state) {
        this.prepareEncoder();
        int max_level = state.getLevel();
        int order = state.getOrder();
        FeatureVector features = new FeatureVector(max_level + 1 + this.model_.getNumSubTags());
        for (int depth = 0; depth <= max_level; ++depth) {
            int level = max_level - depth;
            if (this.max_transition_feature_level_ >= 0 && level > this.max_transition_feature_level_) continue;
            this.encoder_.append(order, this.order_bits_);
            this.encoder_.append(level, this.level_bits_);
            this.encoder_.append(0, 1);
            for (State run = state; run != null; run = run.getPreviousSubOrderState()) {
                State sub_state = run.getSubLevel(depth);
                int index = sub_state.getIndex();
                this.encoder_.append(index, this.tag_bits_[level]);
            }
            this.addFeature(features);
            this.encoder_.reset();
        }
        return features;
    }

    protected double getWeight(int index) {
        return this.weights_[index];
    }

    @Override
    public double dotProduct(State state, FeatureVector vector) {
        int index;
        assert (vector != null);
        State zero_order_state = state.getZeroOrderState();
        int tag_index = this.getUniversalIndex(zero_order_state);
        double score = 0.0;
        for (int findex = 0; findex < vector.size(); ++findex) {
            int feature = vector.get(findex);
            int index2 = this.getIndex(feature, tag_index);
            score += this.getWeight(index2);
        }
        FloatFeatureVector float_vector = vector.getFloatVector();
        if (float_vector != null) {
            score += float_vector.getDotProduct(this, tag_index, 0);
        }
        score += this.dotProductSubTags(zero_order_state, vector);
        if (vector.getIsState() && (index = this.getObservedIndex((MorphFeatureVector)vector, state)) >= 0) {
            score += this.getWeight(index);
        }
        return score * this.scale_factor_;
    }

    @Override
    public double getFloatWeight(int index) {
        return this.float_weights_[index];
    }

    @Override
    public int getFloatIndex(int feature, int tag_index) {
        return feature * this.total_num_tags_ + tag_index;
    }

    private double dotProductSubTags(State state, FeatureVector vector) {
        int level = state.getLevel();
        if (level >= this.model_.getTagToSubTags().length) {
            return 0.0;
        }
        int[][] tag_to_subtag = this.model_.getTagToSubTags()[level];
        if (tag_to_subtag == null) {
            return 0.0;
        }
        int[] indexes = tag_to_subtag[state.getIndex()];
        if (indexes == null) {
            return 0.0;
        }
        double score = 0.0;
        for (int index : indexes) {
            int simple_index = this.getSimpleSubMorphIndex(index);
            for (int findex = 0; findex < vector.size(); ++findex) {
                int feature = vector.get(findex);
                int f_index = this.getIndex(feature, simple_index);
                score += this.getWeight(f_index);
            }
            FloatFeatureVector float_vector = vector.getFloatVector();
            if (float_vector == null) continue;
            score += float_vector.getDotProduct(this, simple_index, 0);
        }
        return score;
    }

    private int getProductIndex(State state) {
        if (state.getLevel() == 0) {
            return state.getIndex();
        }
        int size = this.num_tags_[state.getLevel()];
        return this.getProductIndex(state.getSubLevelState()) * size + state.getIndex();
    }

    private int getUniversalIndex(int tag_index, int level) {
        for (int clevel = 0; clevel < level; ++clevel) {
            tag_index += this.num_tags_[clevel];
        }
        return tag_index;
    }

    private int getUniversalIndex(State zero_order_state) {
        return this.getUniversalIndex(zero_order_state.getIndex(), zero_order_state.getLevel());
    }

    private int getIndex(int feature, int tag_index) {
        int index = feature * this.total_num_tags_ + tag_index;
        int capacity = this.weights_.length - 2 * this.max_level_;
        int h2 = index;
        if (this.use_hash_vector) {
            h2 ^= h2 >>> 20 ^ h2 >>> 12;
            h2 = h2 ^ h2 >>> 7 ^ h2 >>> 4;
            h2 &= capacity - 1;
        } else if (index >= capacity) {
            int old_capacity = capacity;
            capacity = 3 * (index + 1) / 2;
            int length = capacity + 2 * this.max_level_;
            this.weights_ = Arrays.copyOf(this.weights_, length);
            if (this.accumulated_penalties_ != null) {
                this.accumulated_penalties_ = Arrays.copyOf(this.accumulated_penalties_, length);
            }
            for (int i = 0; i < 2 * this.max_level_; ++i) {
                this.weights_[capacity + i] = this.weights_[old_capacity + i];
                this.weights_[old_capacity + i] = 0.0;
                if (this.accumulated_penalties_ == null) continue;
                this.accumulated_penalties_[capacity + i] = this.accumulated_penalties_[old_capacity + i];
                this.accumulated_penalties_[old_capacity + i] = 0.0;
            }
        }
        assert (h2 >= 0) : String.format("H: %d", h2);
        assert (h2 < capacity) : String.format("H: %d Capacity: %d", h2, capacity);
        return h2;
    }

    @Override
    public void init(Model model, Collection<Sequence> sequences) {
        int capacity;
        int max_level = model.getTagTables().size();
        this.feature_table_ = FeatureTable.StaticMethods.create(this.use_hash_feature_table_);
        this.model_ = (MorphModel)model;
        this.max_level_ = max_level;
        this.num_tags_ = new int[max_level];
        this.total_num_tags_ = 0;
        this.tag_bits_ = new int[max_level];
        for (int level = 0; level < Math.min(model.getTagTables().size(), max_level); ++level) {
            this.num_tags_[level] = model.getTagTables().get(level).size();
            this.tag_bits_[level] = Encoder.bitsNeeded(this.num_tags_[level]);
            this.total_num_tags_ += this.num_tags_[level];
        }
        this.simple_sub_morph_start_index_ = this.total_num_tags_;
        this.total_num_tags_ += this.model_.getNumSubTags();
        this.word_bits_ = Encoder.bitsNeeded(this.model_.getWordTable().size());
        this.state_feature_bits_ = Encoder.bitsNeeded(this.num_state_features_);
        this.char_bits_ = Encoder.bitsNeeded(this.model_.getCharTable().size());
        if (this.shape_) {
            this.shape_bits_ = Encoder.bitsNeeded(this.model_.getNumShapes());
        }
        this.order_bits_ = Encoder.bitsNeeded(model.getOrder());
        this.level_bits_ = Encoder.bitsNeeded(max_level);
        this.signature_bits_ = Encoder.bitsNeeded(this.model_.getMaxSignature());
        this.token_feature_bits_ = Encoder.bitsNeeded(this.model_.getTokenFeatureTable().size());
        this.float_weights_ = this.fdict_ != null ? new double[this.fdict_.getDimension() * this.total_num_tags_] : new double[this.model_.getWeightedTokenFeatureTable().size() * this.total_num_tags_];
        this.extend_feature_set_ = true;
        this.scale_factor_ = 1.0;
        int initial_size = this.initial_vector_size_;
        for (capacity = 1; capacity < initial_size; capacity <<= 1) {
        }
        this.weights_ = new double[capacity + 2 * max_level];
    }

    private void update(State state, double value) {
        FeatureVector vector = state.getVector();
        if (vector != null) {
            State run = state.getZeroOrderState();
            while (run != null) {
                int index;
                int tag_index = this.getUniversalIndex(run);
                for (int findex = 0; findex < vector.size(); ++findex) {
                    int feature = vector.get(findex);
                    index = this.getIndex(feature, tag_index);
                    this.updateWeight(index, value);
                }
                FloatFeatureVector float_vector = vector.getFloatVector();
                if (float_vector != null) {
                    float_vector.updateFloatWeight(this, tag_index, 0, value);
                }
                this.updateSubTags(run, vector, value);
                if (state.getOrder() == 1) {
                    run = null;
                    State sub_level_state = state.getSubLevelState();
                    if (sub_level_state != null) {
                        this.update(sub_level_state, value);
                    }
                    if (!vector.getIsState() || (index = this.getObservedIndex((MorphFeatureVector)vector, state)) < 0) continue;
                    this.updateWeight(index, value);
                    continue;
                }
                run = run.getSubLevelState();
            }
        }
    }

    private void updateSubTags(State state, FeatureVector vector, double value) {
        int level = state.getLevel();
        if (level >= this.model_.getTagToSubTags().length) {
            return;
        }
        int[][] tag_to_subtag = this.model_.getTagToSubTags()[level];
        if (tag_to_subtag == null) {
            return;
        }
        int[] indexes = tag_to_subtag[state.getIndex()];
        if (indexes == null) {
            return;
        }
        for (int index : indexes) {
            int simple_index = this.getSimpleSubMorphIndex(index);
            for (int findex = 0; findex < vector.size(); ++findex) {
                int feature = vector.get(findex);
                int f_index = this.getIndex(feature, simple_index);
                this.updateWeight(f_index, value);
            }
            FloatFeatureVector float_vector = vector.getFloatVector();
            if (float_vector == null) continue;
            float_vector.updateFloatWeight(this, simple_index, 0, value);
        }
    }

    protected int getSimpleSubMorphIndex(int sub_morph_index) {
        return this.simple_sub_morph_start_index_ + sub_morph_index;
    }

    protected void updateWeight(int index, double value) {
        int n = index;
        this.weights_[n] = this.weights_[n] + value;
        if (this.accumulated_penalties_ != null) {
            this.weights_[index] = this.applyPenalty(index, this.weights_[index], this.accumulated_penalties_);
        }
    }

    @Override
    public void updateFloatWeight(int index, double value) {
        int n = index;
        this.float_weights_[n] = this.float_weights_[n] + value;
        if (this.accumulated_penalties_ != null) {
            this.float_weights_[index] = this.applyPenalty(index, this.float_weights_[index], this.accumulated_float_penalties_);
        }
    }

    protected int getObservedIndex(MorphFeatureVector vector, State state) {
        int product_index;
        int level;
        int word_index = vector.getWordIndex();
        int feature = this.model_.hasBeenObserved(word_index, level = state.getLevel(), product_index = this.getProductIndex(state)) ? 0 : 1;
        int start_index = this.weights_.length - this.max_level_ * 2;
        int index = start_index + level * 2 + feature;
        return index;
    }

    protected double applyPenalty(int index, double weight, double[] accumulated_penalty) {
        double z = weight;
        if (z - 1.0E-10 > 0.0) {
            weight = Math.max(0.0, z - (this.accumulated_penalty_ + accumulated_penalty[index]));
        } else if (z + 1.0E-10 < 0.0) {
            weight = Math.min(0.0, z + (this.accumulated_penalty_ - accumulated_penalty[index]));
        }
        int n = index;
        accumulated_penalty[n] = accumulated_penalty[n] + (weight - z);
        return weight;
    }

    protected void prepareEncoder() {
        if (this.encoder_ == null) {
            this.encoder_ = new Encoder(10);
        }
        this.encoder_.reset();
    }

    @Override
    public void updateWeights(State state, double value, boolean is_transition) {
        this.update(state, value /= this.scale_factor_);
        if (!is_transition) {
            while ((state = state.getSubOrderState()) != null) {
                this.update(state, value);
            }
        }
    }

    @Override
    public void scaleBy(double scale_factor) {
        this.accumulated_penalty_ /= scale_factor;
        this.scale_factor_ *= scale_factor;
    }

    @Override
    public double[] getWeights() {
        return this.weights_;
    }

    @Override
    public void setWeights(double[] weights) {
        this.weights_ = weights;
    }

    public MorphDictionary getMorphDict() {
        return this.mdict_;
    }

    @Override
    public double[] getFloatWeights() {
        return this.float_weights_;
    }

    @Override
    public void setFloatWeights(double[] weights) {
        this.float_weights_ = weights;
    }

    public MorphModel getModel() {
        return this.model_;
    }

    public FeatureTable getFeatureTable() {
        return this.feature_table_;
    }
}

