/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToPushCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.IterateInstr;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.FocusTrackingIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.rules.Rule;

public class IterateInstrCompiler
extends ToPushCompiler {
    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        IterateInstr instr = (IterateInstr)expression;
        IterateInstrCompiler.visitAnnotation(compiler, "IterateInstrCompiler-Push");
        IterateInstrCompiler.visitLineNumber(compiler, ga, expression);
        int iterVar = methodInfo.allocateLocal(FocusIterator.class);
        ga.newInstance(FocusTrackingIterator.class);
        ga.dup();
        compiler.compileToIterator(instr.getSelectExpression());
        ga.invokeConstructor(FocusTrackingIterator.class, SequenceIterator.class);
        ga.storeLocal(iterVar);
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "newContext", new Class[0]);
        int context2Var = methodInfo.allocateLocal(XPathContextMajor.class);
        ga.storeLocal(context2Var);
        ga.loadLocal(context2Var);
        ga.loadLocal(iterVar);
        ga.invokeInstanceMethod(XPathContext.class, "setCurrentIterator", FocusIterator.class);
        ga.loadLocal(context2Var);
        ga.pushNull();
        ga.invokeInstanceMethod(XPathContextMajor.class, "setCurrentTemplateRule", Rule.class);
        compiler.compileToPush(instr.getInitiallyExp());
        methodInfo.pushContextVariableInfo(context2Var, false);
        LabelInfo loop = methodInfo.placeNewLabel("iterLoop");
        methodInfo.getXslIterateLoopLabelStack().push(loop);
        LabelInfo iterBreak = methodInfo.newLabel("iterBreak");
        methodInfo.getXslIterateBreakLabelStack().push(iterBreak);
        ga.loadLocal(iterVar);
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        LabelInfo completion = methodInfo.newLabel("onCompletion");
        ga.ifNull(completion.label());
        compiler.compileToPush(instr.getActionExpression());
        ga.goTo(loop);
        methodInfo.placeLabel(completion);
        compiler.compileToPush(instr.getOnCompletion());
        LabelInfo end = methodInfo.newLabel("iterateEnd");
        ga.goTo(end);
        methodInfo.placeLabel(iterBreak);
        ga.loadLocal(iterVar);
        ga.invokeInstanceMethod(SequenceIterator.class, "close", new Class[0]);
        methodInfo.placeLabel(end);
        methodInfo.popContextVariableInfo();
        methodInfo.getXslIterateLoopLabelStack().pop();
        methodInfo.getXslIterateBreakLabelStack().pop();
        methodInfo.releaseLocal(context2Var);
        methodInfo.releaseLocal(iterVar);
    }
}

