/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.index;

import de.ids_mannheim.korap.index.MultiTerm;
import de.ids_mannheim.korap.index.MultiTermTokenStream;
import de.ids_mannheim.korap.util.CorpusDataException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTermToken {
    public List<MultiTerm> terms;
    private short i = 0;
    private boolean sorted = false;
    public static final boolean DEBUG = false;
    private final Logger log = LoggerFactory.getLogger(MultiTermTokenStream.class);

    public MultiTermToken(MultiTerm terms, MultiTerm ... moreTerms) {
        this.terms = new ArrayList<MultiTerm>(16);
        this.terms.add(terms);
        this.i = 0;
        while (this.i < moreTerms.length) {
            this.terms.add(moreTerms[this.i]);
            this.i = (short)(this.i + 1);
        }
    }

    public MultiTermToken(char prefix, String surface) {
        this.terms = new ArrayList<MultiTerm>(16);
        try {
            MultiTerm term = new MultiTerm(prefix, surface);
            this.terms.add(term);
        }
        catch (CorpusDataException cde) {
            this.log.error("{}: {}", (Object)cde.getErrorCode(), (Object)cde.getMessage());
        }
    }

    public MultiTermToken(String terms, String ... moreTerms) throws CorpusDataException {
        this.terms = new ArrayList<MultiTerm>(16);
        MultiTerm term = new MultiTerm(terms);
        try {
            this.terms.add(term);
            this.i = 0;
            while (this.i < moreTerms.length) {
                term = new MultiTerm(moreTerms[this.i]);
                this.terms.add(term);
                this.i = (short)(this.i + 1);
            }
        }
        catch (CorpusDataException cde) {
            this.log.error("{}: {}", (Object)cde.getErrorCode(), (Object)cde.getMessage());
        }
    }

    public MultiTermToken add(MultiTerm term) {
        this.terms.add(term);
        this.sorted = false;
        return this;
    }

    public MultiTermToken add(String term) throws CorpusDataException {
        if (term.length() == 0) {
            return this;
        }
        try {
            this.add(new MultiTerm(term));
        }
        catch (CorpusDataException cde) {
            this.log.error("{}: {}", (Object)cde.getErrorCode(), (Object)cde.getMessage());
        }
        return this;
    }

    public MultiTermToken add(char prefix, String term) {
        if (term.length() == 0) {
            return this;
        }
        try {
            this.add(new MultiTerm(prefix, term));
        }
        catch (CorpusDataException cde) {
            this.log.error("{}: {}", (Object)cde.getErrorCode(), (Object)cde.getMessage());
        }
        return this;
    }

    public MultiTerm get(int index) {
        return this.sort().terms.get(index);
    }

    public int getSize() {
        return this.terms.size();
    }

    public MultiTermToken sort() {
        if (this.sorted) {
            return this;
        }
        Collections.sort(this.terms);
        this.sorted = true;
        return this;
    }

    public String toString() {
        this.sort();
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        this.i = 0;
        while (this.i < this.terms.size() - 1) {
            sb.append(this.terms.get(this.i).toString()).append('|');
            this.i = (short)(this.i + 1);
        }
        sb.append(this.terms.get(this.i).toString()).append(']');
        return sb.toString();
    }
}

