/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToBooleanCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;

public class QuantifiedExpressionCompiler
extends ToBooleanCompiler {
    @Override
    public void compileToBoolean(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        QuantifiedExpressionCompiler.visitAnnotation(compiler, "QuantifiedExpression-Boolean");
        QuantifiedExpression quanExpr = (QuantifiedExpression)expression;
        Expression base = quanExpr.getSequence();
        Expression action = quanExpr.getAction();
        boolean some = quanExpr.getOperator() == 32;
        int slotNum = quanExpr.getLocalSlotNumber();
        compiler.compileToIterator(base);
        int iterVar = methodInfo.allocateLocal(SequenceIterator.class);
        ga.storeLocal(iterVar);
        LabelInfo end = methodInfo.newLabel("endQF");
        LabelInfo notSatisfied = methodInfo.newLabel("notSatisfied");
        LabelInfo done = methodInfo.newLabel("doneQF");
        LabelInfo loop = methodInfo.placeNewLabel("loop");
        ga.loadLocal(iterVar);
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        ga.dup();
        ga.ifNull(done.label());
        compiler.generateGetContext();
        ga.swap();
        ga.push(slotNum);
        ga.swap();
        ga.invokeInstanceMethod(XPathContext.class, "setLocalVariable", Integer.TYPE, Sequence.class);
        compiler.compileToBoolean(action);
        if (some) {
            ga.ifFalse(notSatisfied);
        } else {
            ga.ifTrue(notSatisfied);
        }
        ga.loadLocal(iterVar);
        ga.invokeInstanceMethod(SequenceIterator.class, "close", new Class[0]);
        ga.push(some);
        ga.goTo(end);
        methodInfo.placeLabel(notSatisfied);
        ga.goTo(loop);
        methodInfo.placeLabel(done);
        ga.pop();
        ga.push(!some);
        methodInfo.placeLabel(end);
        methodInfo.releaseLocal(iterVar);
    }
}

