/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.Posture;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.CopyOfFeed;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.functions.CollatingFunctionFree;
import net.sf.saxon.functions.DeepEqual;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.BooleanValue;

public class DeepEqualStreamer
extends StreamingAdjunct
implements FeedMaker {
    private int consumingArg = -1;

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        this.consumingArg = DeepEqualStreamer.findConsumingArg(this.getExpression(), this.consumingArg);
        return super.getWatchMaker(forGrouping);
    }

    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        this.consumingArg = DeepEqualStreamer.findConsumingArg(this.getExpression(), this.consumingArg);
        if (this.consumingArg >= 2) {
            return this.getDefaultFeedMaker(this.consumingArg).makeItemFeed(watchManager, out, context);
        }
        SystemFunctionCall call = (SystemFunctionCall)this.getExpression();
        Posture posture = Streamability.getPosture(call.getArg(this.consumingArg));
        if (posture == Posture.GROUNDED || posture == Posture.CLIMBING) {
            return new GroundedDeepEqualFeed(call, out, context, this.consumingArg);
        }
        GroundedDeepEqualFeed comparisonFeed = new GroundedDeepEqualFeed(call, out, context, this.consumingArg);
        return new CopyOfFeed(watchManager, (Feed)comparisonFeed, context);
    }

    private static class GroundedDeepEqualFeed
    extends ItemFeed {
        int consumingArg;
        SequenceIterator other;
        AtomicComparer comparer;
        boolean done;

        public GroundedDeepEqualFeed(SystemFunctionCall exp, Feed result, XPathContext context, int consumingArg) throws XPathException {
            super(exp, result, context);
            DeepEqual function;
            this.other = exp.getArg(1 - consumingArg).iterate(context);
            this.consumingArg = consumingArg;
            SystemFunctionCall call = (SystemFunctionCall)this.getExpression();
            if (call.isCallOn(CollatingFunctionFree.class)) {
                CollatingFunctionFree fn = (CollatingFunctionFree)call.getTargetFunction();
                String collation = call.getArg(2).evaluateAsString(context).toString();
                try {
                    function = (DeepEqual)fn.bindCollation(collation);
                }
                catch (XPathException e) {
                    this.dynamicError(e);
                    this.done = true;
                    return;
                }
            } else {
                function = (DeepEqual)call.getTargetFunction();
            }
            this.comparer = function.getAtomicComparer(this.getContext());
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            Object otherItem;
            if (!(this.done || (otherItem = this.other.next()) != null && DeepEqual.deepEqual(SingletonIterator.makeIterator(item), SingletonIterator.makeIterator(otherItem), this.comparer, this.getContext(), 0))) {
                this.getResult().processItem(BooleanValue.FALSE);
                this.getResult().close();
                this.done = true;
                this.getTerminator().terminate();
            }
        }

        @Override
        public void close() throws XPathException {
            if (!this.done) {
                boolean more = this.other.next() != null;
                this.getResult().processItem(BooleanValue.get(!more));
                this.getResult().close();
            }
        }
    }
}

